/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.CodeAttr;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantUTFInfo;
import com.go.trove.classfile.ConstantValueAttr;
import com.go.trove.classfile.DeprecatedAttr;
import com.go.trove.classfile.ExceptionsAttr;
import com.go.trove.classfile.InnerClassesAttr;
import com.go.trove.classfile.LineNumberTableAttr;
import com.go.trove.classfile.LocalVariableTableAttr;
import com.go.trove.classfile.SourceFileAttr;
import com.go.trove.classfile.SyntheticAttr;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Attribute {
    static final String CODE = "Code";
    static final String CONSTANT_VALUE = "ConstantValue";
    static final String DEPRECATED = "Deprecated";
    static final String EXCEPTIONS = "Exceptions";
    static final String INNER_CLASSES = "InnerClasses";
    static final String LINE_NUMBER_TABLE = "LineNumberTable";
    static final String LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    static final String SOURCE_FILE = "SourceFile";
    static final String SYNTHETIC = "Synthetic";
    protected final ConstantPool mCp;
    private String mName;
    private ConstantUTFInfo mNameConstant;

    protected Attribute(ConstantPool constantPool, String string) {
        this.mCp = constantPool;
        this.mName = string;
        this.mNameConstant = ConstantUTFInfo.make(constantPool, string);
    }

    public ConstantPool getConstantPool() {
        return this.mCp;
    }

    public String getName() {
        return this.mName;
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public abstract int getLength();

    public void writeTo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.mNameConstant.getIndex());
        dataOutput.writeInt(this.getLength());
    }

    static Attribute readFrom(ConstantPool constantPool, DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        String string = ((ConstantUTFInfo)constantPool.getConstant(n)).getValue();
        int n2 = dataInput.readInt();
        if (string.equals(CODE)) {
            return CodeAttr.define(constantPool, dataInput, string, n2);
        }
        if (string.equals(CONSTANT_VALUE)) {
            return ConstantValueAttr.define(constantPool, dataInput, string, n2);
        }
        if (string.equals(DEPRECATED)) {
            return DeprecatedAttr.define(constantPool, dataInput, string, n2);
        }
        if (string.equals(EXCEPTIONS)) {
            return ExceptionsAttr.define(constantPool, dataInput, string, n2);
        }
        if (string.equals(INNER_CLASSES)) {
            return InnerClassesAttr.define(constantPool, dataInput, string, n2);
        }
        if (string.equals(LINE_NUMBER_TABLE)) {
            return LineNumberTableAttr.define(constantPool, dataInput, string, n2);
        }
        if (string.equals(LOCAL_VARIABLE_TABLE)) {
            return LocalVariableTableAttr.define(constantPool, dataInput, string, n2);
        }
        if (string.equals(SOURCE_FILE)) {
            return SourceFileAttr.define(constantPool, dataInput, string, n2);
        }
        if (string.equals(SYNTHETIC)) {
            return SyntheticAttr.define(constantPool, dataInput, string, n2);
        }
        return Attribute.define(constantPool, dataInput, string, n2);
    }

    static Attribute define(ConstantPool constantPool, DataInput dataInput, String string, final int n) throws IOException {
        final byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return new Attribute(constantPool, string){

            public int getLength() {
                return n;
            }

            public void writeTo(DataOutput dataOutput) throws IOException {
                super.writeTo(dataOutput);
                dataOutput.write(byArray);
            }
        };
    }
}

