/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.AccessFlags;
import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.DeprecatedAttr;
import com.go.trove.classfile.FieldInfo;
import com.go.trove.classfile.InnerClassesAttr;
import com.go.trove.classfile.MethodDescriptor;
import com.go.trove.classfile.MethodInfo;
import com.go.trove.classfile.SourceFileAttr;
import com.go.trove.classfile.SyntheticAttr;
import com.go.trove.classfile.TypeDescriptor;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassFile {
    private static final int MAGIC = -889275714;
    private static final int JDK1_1_MAJOR_VERSION = 45;
    private static final int JDK1_1_MINOR_VERSION = 3;
    private int mMajorVersion = 45;
    private int mMinorVersion = 3;
    private String mClassName;
    private String mSuperClassName;
    private TypeDescriptor mType;
    private ConstantPool mCp;
    private AccessFlags mAccessFlags;
    private ConstantClassInfo mThisClass;
    private ConstantClassInfo mSuperClass;
    private List mInterfaces = new ArrayList(2);
    private Set mInterfaceSet = new HashSet(7);
    private List mFields = new ArrayList();
    private List mMethods = new ArrayList();
    private List mAttributes = new ArrayList();
    private SourceFileAttr mSource;
    private List mInnerClasses;
    private int mAnonymousInnerClassCount = 0;
    private InnerClassesAttr mInnerClassesAttr;
    private ClassFile mOuterClass;
    static /* synthetic */ Class class$java$lang$Object;

    public ClassFile(String string) {
        this(string, (String)null);
    }

    public ClassFile(String string, Class clazz) {
        this(string, clazz.getName());
    }

    public ClassFile(String string, String string2) {
        if (string2 == null) {
            string2 = (class$java$lang$Object == null ? (class$java$lang$Object = ClassFile.class$("java.lang.Object")) : class$java$lang$Object).getName();
        }
        this.mCp = new ConstantPool();
        this.mAccessFlags = new AccessFlags(1);
        this.mThisClass = ConstantClassInfo.make(this.mCp, string);
        this.mSuperClass = ConstantClassInfo.make(this.mCp, string2);
        this.mClassName = string;
        this.mSuperClassName = string2;
    }

    private ClassFile(ConstantPool constantPool, AccessFlags accessFlags, ConstantClassInfo constantClassInfo, ConstantClassInfo constantClassInfo2) {
        this.mCp = constantPool;
        this.mAccessFlags = accessFlags;
        this.mThisClass = constantClassInfo;
        this.mSuperClass = constantClassInfo2;
        this.mClassName = constantClassInfo.getClassName();
        if (constantClassInfo2 != null) {
            this.mSuperClassName = constantClassInfo2.getClassName();
        }
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getSuperClassName() {
        return this.mSuperClassName;
    }

    public TypeDescriptor getType() {
        if (this.mType == null) {
            this.mType = new TypeDescriptor(this.mClassName);
        }
        return this.mType;
    }

    public AccessFlags getAccessFlags() {
        return this.mAccessFlags;
    }

    public String[] getInterfaces() {
        int n = this.mInterfaces.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((ConstantClassInfo)this.mInterfaces.get(n2)).getClassName();
            ++n2;
        }
        return stringArray;
    }

    public FieldInfo[] getFields() {
        FieldInfo[] fieldInfoArray = new FieldInfo[this.mFields.size()];
        return this.mFields.toArray(fieldInfoArray);
    }

    public MethodInfo[] getMethods() {
        Object object;
        int n = this.mMethods.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            object = (MethodInfo)this.mMethods.get(n2);
            String string = ((MethodInfo)object).getName();
            if (!"<init>".equals(string) && !"<clinit>".equals(string)) {
                arrayList.add(object);
            }
            ++n2;
        }
        object = new MethodInfo[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public MethodInfo[] getConstructors() {
        Object object;
        int n = this.mMethods.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            object = (MethodInfo)this.mMethods.get(n2);
            if ("<init>".equals(((MethodInfo)object).getName())) {
                arrayList.add(object);
            }
            ++n2;
        }
        object = new MethodInfo[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public MethodInfo getInitializer() {
        int n = this.mMethods.size();
        int n2 = 0;
        while (n2 < n) {
            MethodInfo methodInfo = (MethodInfo)this.mMethods.get(n2);
            if ("<clinit>".equals(methodInfo.getName())) {
                return methodInfo;
            }
            ++n2;
        }
        return null;
    }

    public ClassFile[] getInnerClasses() {
        if (this.mInnerClasses == null) {
            return new ClassFile[0];
        }
        ClassFile[] classFileArray = new ClassFile[this.mInnerClasses.size()];
        return this.mInnerClasses.toArray(classFileArray);
    }

    public boolean isInnerClass() {
        return this.mOuterClass != null;
    }

    public ClassFile getOuterClass() {
        return this.mOuterClass;
    }

    public int getClassDepth() {
        int n = 0;
        ClassFile classFile = this.mOuterClass;
        while (classFile != null) {
            ++n;
            classFile = classFile.mOuterClass;
        }
        return n;
    }

    public String getSourceFile() {
        if (this.mSource == null) {
            return null;
        }
        return this.mSource.getFileName();
    }

    public boolean isSynthetic() {
        int n = this.mAttributes.size();
        while (--n >= 0) {
            Object e = this.mAttributes.get(n);
            if (!(e instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int n = this.mAttributes.size();
        while (--n >= 0) {
            Object e = this.mAttributes.get(n);
            if (!(e instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public ConstantPool getConstantPool() {
        return this.mCp;
    }

    public void addInterface(String string) {
        if (!this.mInterfaceSet.contains(string)) {
            this.mInterfaces.add(ConstantClassInfo.make(this.mCp, string));
            this.mInterfaceSet.add(string);
        }
    }

    public void addInterface(Class clazz) {
        this.addInterface(clazz.getName());
    }

    public FieldInfo addField(AccessFlags accessFlags, String string, TypeDescriptor typeDescriptor) {
        FieldInfo fieldInfo = new FieldInfo(this, accessFlags, string, typeDescriptor);
        this.mFields.add(fieldInfo);
        return fieldInfo;
    }

    public MethodInfo addMethod(AccessFlags accessFlags, String string, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(typeDescriptor, typeDescriptorArray);
        return this.addMethod(accessFlags, string, methodDescriptor);
    }

    public MethodInfo addMethod(AccessFlags accessFlags, String string, MethodDescriptor methodDescriptor) {
        MethodInfo methodInfo = new MethodInfo(this, accessFlags, string, methodDescriptor);
        this.mMethods.add(methodInfo);
        return methodInfo;
    }

    public MethodInfo addMethod(Method method) {
        AccessFlags accessFlags = new AccessFlags(method.getModifiers());
        accessFlags.setAbstract(false);
        TypeDescriptor typeDescriptor = new TypeDescriptor(method.getReturnType());
        Class<?>[] classArray = method.getParameterTypes();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[classArray.length];
        int n = 0;
        while (n < typeDescriptorArray.length) {
            typeDescriptorArray[n] = new TypeDescriptor(classArray[n]);
            ++n;
        }
        MethodInfo methodInfo = this.addMethod(accessFlags, method.getName(), typeDescriptor, typeDescriptorArray);
        Class<?>[] classArray2 = method.getExceptionTypes();
        int n2 = 0;
        while (n2 < classArray2.length) {
            methodInfo.addException(classArray2[n2].getName());
            ++n2;
        }
        return methodInfo;
    }

    public MethodInfo addConstructor(AccessFlags accessFlags, TypeDescriptor[] typeDescriptorArray) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(null, typeDescriptorArray);
        MethodInfo methodInfo = new MethodInfo(this, accessFlags, "<init>", methodDescriptor);
        this.mMethods.add(methodInfo);
        return methodInfo;
    }

    public MethodInfo addInitializer() {
        MethodDescriptor methodDescriptor = new MethodDescriptor(null, null);
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setStatic(true);
        MethodInfo methodInfo = new MethodInfo(this, accessFlags, "<clinit>", methodDescriptor);
        this.mMethods.add(methodInfo);
        return methodInfo;
    }

    public ClassFile addInnerClass(String string) {
        return this.addInnerClass(string, (String)null);
    }

    public ClassFile addInnerClass(String string, Class clazz) {
        return this.addInnerClass(string, clazz.getName());
    }

    public ClassFile addInnerClass(String string, String string2) {
        String string3 = string == null ? this.mClassName + '$' + ++this.mAnonymousInnerClassCount : this.mClassName + '$' + string;
        ClassFile classFile = new ClassFile(string3, string2);
        AccessFlags accessFlags = classFile.getAccessFlags();
        accessFlags.setPrivate(true);
        accessFlags.setStatic(true);
        classFile.mOuterClass = this;
        if (this.mInnerClasses == null) {
            this.mInnerClasses = new ArrayList();
        }
        this.mInnerClasses.add(classFile);
        if (this.mInnerClassesAttr == null) {
            this.addAttribute(new InnerClassesAttr(this.mCp));
        }
        this.mInnerClassesAttr.addInnerClass(string3, this.mClassName, string, accessFlags);
        classFile.addAttribute(new InnerClassesAttr(classFile.getConstantPool()));
        classFile.mInnerClassesAttr.addInnerClass(string3, this.mClassName, string, accessFlags);
        return classFile;
    }

    public void setSourceFile(String string) {
        this.addAttribute(new SourceFileAttr(this.mCp, string));
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attribute) {
        if (attribute instanceof SourceFileAttr) {
            if (this.mSource != null) {
                this.mAttributes.remove(this.mSource);
            }
            this.mSource = (SourceFileAttr)attribute;
        } else if (attribute instanceof InnerClassesAttr) {
            if (this.mInnerClassesAttr != null) {
                this.mAttributes.remove(this.mInnerClassesAttr);
            }
            this.mInnerClassesAttr = (InnerClassesAttr)attribute;
        }
        this.mAttributes.add(attribute);
    }

    public void setVersion(int n, int n2) throws IllegalArgumentException {
        if (n != 45 || n2 != 3) {
            throw new IllegalArgumentException("Version " + n + ", " + n2 + " is not supported");
        }
        this.mMajorVersion = n;
        this.mMinorVersion = n2;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (!(outputStream instanceof DataOutput)) {
            outputStream = new DataOutputStream(outputStream);
        }
        this.writeTo((DataOutput)((Object)outputStream));
        outputStream.flush();
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        int n;
        dataOutput.writeInt(-889275714);
        dataOutput.writeShort(this.mMinorVersion);
        dataOutput.writeShort(this.mMajorVersion);
        this.mCp.writeTo(dataOutput);
        int n2 = this.mAccessFlags.getModifier();
        n2 |= 0x20;
        n2 &= 0xFFFFFFF1;
        if (this.isInnerClass() && this.mAccessFlags.isProtected()) {
            n2 |= 1;
        }
        dataOutput.writeShort(n2);
        dataOutput.writeShort(this.mThisClass.getIndex());
        if (this.mSuperClass != null) {
            dataOutput.writeShort(this.mSuperClass.getIndex());
        } else {
            dataOutput.writeShort(0);
        }
        int n3 = this.mInterfaces.size();
        if (n3 >= 65535) {
            throw new RuntimeException("Interfaces count cannot exceed 65535: " + n3);
        }
        dataOutput.writeShort(n3);
        int n4 = 0;
        while (n4 < n3) {
            n = ((ConstantInfo)this.mInterfaces.get(n4)).getIndex();
            dataOutput.writeShort(n);
            ++n4;
        }
        n3 = this.mFields.size();
        if (n3 >= 65535) {
            throw new RuntimeException("Field count cannot exceed 65535: " + n3);
        }
        dataOutput.writeShort(n3);
        n = 0;
        while (n < n3) {
            FieldInfo fieldInfo = (FieldInfo)this.mFields.get(n);
            fieldInfo.writeTo(dataOutput);
            ++n;
        }
        n3 = this.mMethods.size();
        if (n3 >= 65535) {
            throw new RuntimeException("Method count cannot exceed 65535: " + n3);
        }
        dataOutput.writeShort(n3);
        int n5 = 0;
        while (n5 < n3) {
            MethodInfo methodInfo = (MethodInfo)this.mMethods.get(n5);
            methodInfo.writeTo(dataOutput);
            ++n5;
        }
        n3 = this.mAttributes.size();
        if (n3 >= 65535) {
            throw new RuntimeException("Attribute count cannot exceed 65535: " + n3);
        }
        dataOutput.writeShort(n3);
        int n6 = 0;
        while (n6 < n3) {
            Attribute attribute = (Attribute)this.mAttributes.get(n6);
            attribute.writeTo(dataOutput);
            ++n6;
        }
    }

    public static ClassFile readFrom(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof DataInput)) {
            inputStream = new DataInputStream(inputStream);
        }
        return ClassFile.readFrom((DataInput)((Object)inputStream));
    }

    public static ClassFile readFrom(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != -889275714) {
            throw new IOException("Incorrect magic number: 0x" + Integer.toHexString(n));
        }
        int n2 = dataInput.readUnsignedShort();
        if (n2 != 3) {
            throw new IOException("Minor version " + n2 + " not supported, version " + 3 + " is.");
        }
        int n3 = dataInput.readUnsignedShort();
        if (n3 != 45) {
            throw new IOException("Major version " + n3 + "not supported, version " + 45 + " is.");
        }
        ConstantPool constantPool = ConstantPool.readFrom(dataInput);
        AccessFlags accessFlags = new AccessFlags(dataInput.readUnsignedShort());
        int n4 = dataInput.readUnsignedShort();
        ConstantClassInfo constantClassInfo = (ConstantClassInfo)constantPool.getConstant(n4);
        n4 = dataInput.readUnsignedShort();
        ConstantClassInfo constantClassInfo2 = null;
        if (n4 > 0) {
            constantClassInfo2 = (ConstantClassInfo)constantPool.getConstant(n4);
        }
        ClassFile classFile = new ClassFile(constantPool, accessFlags, constantClassInfo, constantClassInfo2);
        int n5 = dataInput.readUnsignedShort();
        int n6 = 0;
        while (n6 < n5) {
            n4 = dataInput.readUnsignedShort();
            ConstantClassInfo constantClassInfo3 = (ConstantClassInfo)constantPool.getConstant(n4);
            classFile.addInterface(constantClassInfo3.getClassName());
            ++n6;
        }
        n5 = dataInput.readUnsignedShort();
        int n7 = 0;
        while (n7 < n5) {
            classFile.mFields.add(FieldInfo.readFrom(classFile, dataInput));
            ++n7;
        }
        n5 = dataInput.readUnsignedShort();
        int n8 = 0;
        while (n8 < n5) {
            classFile.mMethods.add(MethodInfo.readFrom(classFile, dataInput));
            ++n8;
        }
        n5 = dataInput.readUnsignedShort();
        int n9 = 0;
        while (n9 < n5) {
            classFile.addAttribute(Attribute.readFrom(constantPool, dataInput));
            ++n9;
        }
        return classFile;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

