/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.CodeBuffer;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ExceptionHandler;
import com.go.trove.classfile.LineNumberTableAttr;
import com.go.trove.classfile.LocalVariable;
import com.go.trove.classfile.LocalVariableTableAttr;
import com.go.trove.classfile.Location;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CodeAttr
extends Attribute {
    private CodeBuffer mCodeBuffer;
    private List mAttributes = new ArrayList(2);
    private LineNumberTableAttr mLineNumberTable;
    private LocalVariableTableAttr mLocalVariableTable;

    CodeAttr(ConstantPool constantPool) {
        super(constantPool, "Code");
    }

    public CodeBuffer getCodeBuffer() {
        return this.mCodeBuffer;
    }

    public void setCodeBuffer(CodeBuffer codeBuffer) {
        this.mCodeBuffer = codeBuffer;
    }

    public int getLineNumber(Location location) {
        if (this.mLineNumberTable == null || location.getLocation() < 0) {
            return -1;
        }
        return this.mLineNumberTable.getLineNumber(location);
    }

    public void mapLineNumber(Location location, int n) {
        if (this.mLineNumberTable == null) {
            this.addAttribute(new LineNumberTableAttr(this.mCp));
        }
        this.mLineNumberTable.addEntry(location, n);
    }

    public void localVariableUse(LocalVariable localVariable) {
        if (this.mLocalVariableTable == null) {
            this.addAttribute(new LocalVariableTableAttr(this.mCp));
        }
        this.mLocalVariableTable.addEntry(localVariable);
    }

    public void addAttribute(Attribute attribute) {
        if (attribute instanceof LineNumberTableAttr) {
            if (this.mLineNumberTable != null) {
                this.mAttributes.remove(this.mLineNumberTable);
            }
            this.mLineNumberTable = (LineNumberTableAttr)attribute;
        } else if (attribute instanceof LocalVariableTableAttr) {
            if (this.mLocalVariableTable != null) {
                this.mAttributes.remove(this.mLocalVariableTable);
            }
            this.mLocalVariableTable = (LocalVariableTableAttr)attribute;
        }
        this.mAttributes.add(attribute);
    }

    public int getLength() {
        int n;
        int n2;
        byte[] byArray;
        if (this.mCodeBuffer != null && (byArray = this.mCodeBuffer.getByteCodes()).length > 0) {
            ExceptionHandler[] exceptionHandlerArray = this.mCodeBuffer.getExceptionHandlers();
            n2 = exceptionHandlerArray == null ? 0 : exceptionHandlerArray.length;
            n = 12 + byArray.length + 8 * n2;
        } else {
            n = 13;
        }
        n2 = this.mAttributes.size();
        int n3 = 0;
        while (n3 < n2) {
            n += ((Attribute)this.mAttributes.get(n3)).getLength();
            n += 6;
            ++n3;
        }
        return n;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        int n;
        int n2;
        super.writeTo(dataOutput);
        if (this.mCodeBuffer == null) {
            throw new NullPointerException("CodeAttr has no CodeBuffer set");
        }
        ExceptionHandler[] exceptionHandlerArray = this.mCodeBuffer.getExceptionHandlers();
        dataOutput.writeShort(this.mCodeBuffer.getMaxStackDepth());
        dataOutput.writeShort(this.mCodeBuffer.getMaxLocals());
        byte[] byArray = this.mCodeBuffer.getByteCodes();
        dataOutput.writeInt(byArray.length);
        dataOutput.write(byArray);
        if (exceptionHandlerArray != null) {
            n2 = exceptionHandlerArray.length;
            dataOutput.writeShort(n2);
            n = 0;
            while (n < n2) {
                exceptionHandlerArray[n].writeTo(dataOutput);
                ++n;
            }
        } else {
            dataOutput.writeShort(0);
        }
        n2 = this.mAttributes.size();
        dataOutput.writeShort(n2);
        n = 0;
        while (n < n2) {
            Attribute attribute = (Attribute)this.mAttributes.get(n);
            attribute.writeTo(dataOutput);
            ++n;
        }
    }

    static Attribute define(ConstantPool constantPool, DataInput dataInput, String string, int n) throws IOException {
        CodeAttr codeAttr = new CodeAttr(constantPool);
        final int n2 = dataInput.readUnsignedShort();
        final int n3 = dataInput.readUnsignedShort();
        final byte[] byArray = new byte[dataInput.readInt()];
        dataInput.readFully(byArray);
        int n4 = dataInput.readUnsignedShort();
        final ExceptionHandler[] exceptionHandlerArray = new ExceptionHandler[n4];
        int n5 = 0;
        while (n5 < n4) {
            exceptionHandlerArray[n5] = ExceptionHandler.readFrom(constantPool, dataInput);
            ++n5;
        }
        codeAttr.mCodeBuffer = new CodeBuffer(){

            public int getMaxStackDepth() {
                return n2;
            }

            public int getMaxLocals() {
                return n3;
            }

            public byte[] getByteCodes() {
                return (byte[])byArray.clone();
            }

            public ExceptionHandler[] getExceptionHandlers() {
                return (ExceptionHandler[])exceptionHandlerArray.clone();
            }
        };
        int n6 = dataInput.readUnsignedShort();
        int n7 = 0;
        while (n7 < n6) {
            codeAttr.addAttribute(Attribute.readFrom(constantPool, dataInput));
            ++n7;
        }
        return codeAttr;
    }
}

