/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ClassFile;
import com.go.trove.classfile.CodeAssembler;
import com.go.trove.classfile.CodeAttr;
import com.go.trove.classfile.CodeBuffer;
import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantDoubleInfo;
import com.go.trove.classfile.ConstantFieldInfo;
import com.go.trove.classfile.ConstantFloatInfo;
import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantIntegerInfo;
import com.go.trove.classfile.ConstantInterfaceMethodInfo;
import com.go.trove.classfile.ConstantLongInfo;
import com.go.trove.classfile.ConstantMethodInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantStringInfo;
import com.go.trove.classfile.ExceptionHandler;
import com.go.trove.classfile.InstructionList;
import com.go.trove.classfile.Label;
import com.go.trove.classfile.LocalVariable;
import com.go.trove.classfile.Location;
import com.go.trove.classfile.MethodInfo;
import com.go.trove.classfile.Opcode;
import com.go.trove.classfile.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CodeBuilder
implements CodeBuffer,
CodeAssembler {
    private CodeAttr mCodeAttr;
    private ClassFile mClassFile;
    private ConstantPool mCp;
    private InstructionList mInstructions = new InstructionList();
    private LocalVariable mThisReference;
    private LocalVariable[] mParameters;
    private boolean mSaveLineNumberInfo;
    private boolean mSaveLocalVariableInfo;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$String;

    public CodeBuilder(MethodInfo methodInfo) {
        this(methodInfo, true, false);
    }

    public CodeBuilder(MethodInfo methodInfo, boolean bl, boolean bl2) {
        LocalVariable localVariable;
        this.mCodeAttr = methodInfo.getCodeAttr();
        this.mClassFile = methodInfo.getClassFile();
        this.mCp = this.mClassFile.getConstantPool();
        this.mCodeAttr.setCodeBuffer(this);
        this.mSaveLineNumberInfo = bl;
        this.mSaveLocalVariableInfo = bl2;
        int n = 0;
        if (!methodInfo.getAccessFlags().isStatic()) {
            this.mThisReference = localVariable = this.mInstructions.createLocalParameter("this", this.mClassFile.getType(), n++);
            if (bl2) {
                this.mCodeAttr.localVariableUse(localVariable);
            }
        }
        TypeDescriptor[] typeDescriptorArray = methodInfo.getMethodDescriptor().getParameterTypes();
        int n2 = typeDescriptorArray.length;
        this.mParameters = new LocalVariable[n2];
        int n3 = 0;
        while (n3 < typeDescriptorArray.length) {
            n += (localVariable = this.mInstructions.createLocalParameter(null, typeDescriptorArray[n3], n)).isDoubleWord() ? 2 : 1;
            this.mParameters[n3] = localVariable;
            if (bl2) {
                this.mCodeAttr.localVariableUse(localVariable);
            }
            ++n3;
        }
    }

    public int getMaxStackDepth() {
        return this.mInstructions.getMaxStackDepth();
    }

    public int getMaxLocals() {
        return this.mInstructions.getMaxLocals();
    }

    public byte[] getByteCodes() {
        return this.mInstructions.getByteCodes();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.mInstructions.getExceptionHandlers();
    }

    private void addCode(int n, byte by) {
        new InstructionList.CodeInstruction(this.mInstructions, n, new byte[]{by});
    }

    private void addCode(int n, byte by, byte by2) {
        new InstructionList.CodeInstruction(this.mInstructions, n, new byte[]{by, by2});
    }

    private void addCode(int n, byte by, short s) {
        new InstructionList.CodeInstruction(this.mInstructions, n, new byte[]{by, (byte)(s >> 8), (byte)s});
    }

    private void addCode(int n, byte by, int n2) {
        byte[] byArray = new byte[]{by, (byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        new InstructionList.CodeInstruction(this.mInstructions, n, byArray);
    }

    private void addCode(int n, byte by, ConstantInfo constantInfo) {
        new InstructionList.ConstantOperandInstruction(this.mInstructions, n, new byte[]{by, 0, 0}, constantInfo);
    }

    public LocalVariable[] getParameters() {
        return (LocalVariable[])this.mParameters.clone();
    }

    public LocalVariable createLocalVariable(String string, TypeDescriptor typeDescriptor) {
        LocalVariable localVariable = this.mInstructions.createLocalVariable(string, typeDescriptor);
        if (this.mSaveLocalVariableInfo) {
            this.mCodeAttr.localVariableUse(localVariable);
        }
        return localVariable;
    }

    public Label createLabel() {
        return new InstructionList.LabelInstruction(this.mInstructions);
    }

    public void exceptionHandler(Location location, Location location2, String string) {
        Label label = this.createLabel().setLocation();
        ConstantClassInfo constantClassInfo = string == null ? null : ConstantClassInfo.make(this.mCp, string);
        ExceptionHandler exceptionHandler = new ExceptionHandler(location, location2, label, constantClassInfo);
        this.mInstructions.addExceptionHandler(exceptionHandler);
    }

    public void mapLineNumber(int n) {
        if (this.mSaveLineNumberInfo) {
            this.mCodeAttr.mapLineNumber(this.createLabel().setLocation(), n);
        }
    }

    public void loadConstant(String string) {
        if (string == null) {
            this.addCode(1, (byte)1);
            return;
        }
        int n = string.length();
        if (n <= 21845) {
            ConstantStringInfo constantStringInfo = ConstantStringInfo.make(this.mCp, string);
            new InstructionList.LoadConstantInstruction(this.mInstructions, 1, constantStringInfo);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        if (n2 <= 65535) {
            ConstantStringInfo constantStringInfo = ConstantStringInfo.make(this.mCp, string);
            new InstructionList.LoadConstantInstruction(this.mInstructions, 1, constantStringInfo);
            return;
        }
        TypeDescriptor typeDescriptor = new TypeDescriptor(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = CodeBuilder.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        TypeDescriptor typeDescriptor2 = new TypeDescriptor(Integer.TYPE);
        TypeDescriptor typeDescriptor3 = new TypeDescriptor(class$java$lang$String == null ? (class$java$lang$String = CodeBuilder.class$("java.lang.String")) : class$java$lang$String);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor3};
        this.newObject(typeDescriptor);
        this.dup();
        this.loadConstant(n);
        this.invokeConstructor("java.lang.StringBuffer", new TypeDescriptor[]{typeDescriptor2});
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4;
            n2 = 0;
            while (n4 < n) {
                char c = string.charAt(n4);
                int n6 = c >= '\u0001' && c <= '\u007f' ? 1 : (c > '\u07ff' ? 3 : 2);
                if (n2 + n6 > 65535) break;
                n2 += n6;
                ++n4;
            }
            String string2 = string.substring(n5, n4);
            ConstantStringInfo constantStringInfo = ConstantStringInfo.make(this.mCp, string2);
            new InstructionList.LoadConstantInstruction(this.mInstructions, 1, constantStringInfo);
            this.invokeVirtual("java.lang.StringBuffer", "append", typeDescriptor, typeDescriptorArray);
        }
        this.invokeVirtual("java.lang.StringBuffer", "toString", typeDescriptor3, null);
    }

    public void loadConstant(boolean bl) {
        this.loadConstant(bl ? 1 : 0);
    }

    public void loadConstant(int n) {
        if (-1 <= n && n <= 5) {
            byte by;
            switch (n) {
                case -1: {
                    by = 2;
                    break;
                }
                case 0: {
                    by = 3;
                    break;
                }
                case 1: {
                    by = 4;
                    break;
                }
                case 2: {
                    by = 5;
                    break;
                }
                case 3: {
                    by = 6;
                    break;
                }
                case 4: {
                    by = 7;
                    break;
                }
                case 5: {
                    by = 8;
                    break;
                }
                default: {
                    by = 0;
                }
            }
            this.addCode(1, by);
        } else if (-128 <= n && n <= 127) {
            this.addCode(1, (byte)16, (byte)n);
        } else if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
            this.addCode(1, (byte)17, (short)n);
        } else {
            ConstantIntegerInfo constantIntegerInfo = ConstantIntegerInfo.make(this.mCp, n);
            new InstructionList.LoadConstantInstruction(this.mInstructions, 1, constantIntegerInfo);
        }
    }

    public void loadConstant(long l) {
        if (l == 0L) {
            this.addCode(2, (byte)9);
        } else if (l == 1L) {
            this.addCode(2, (byte)10);
        } else {
            ConstantLongInfo constantLongInfo = ConstantLongInfo.make(this.mCp, l);
            new InstructionList.LoadConstantInstruction(this.mInstructions, 2, constantLongInfo, true);
        }
    }

    public void loadConstant(float f) {
        if (f == 0.0f) {
            this.addCode(1, (byte)11);
        } else if (f == 1.0f) {
            this.addCode(1, (byte)12);
        } else if (f == 2.0f) {
            this.addCode(1, (byte)13);
        } else {
            ConstantFloatInfo constantFloatInfo = ConstantFloatInfo.make(this.mCp, f);
            new InstructionList.LoadConstantInstruction(this.mInstructions, 1, constantFloatInfo);
        }
    }

    public void loadConstant(double d) {
        if (d == 0.0) {
            this.addCode(2, (byte)14);
        } else if (d == 1.0) {
            this.addCode(2, (byte)15);
        } else {
            ConstantDoubleInfo constantDoubleInfo = ConstantDoubleInfo.make(this.mCp, d);
            new InstructionList.LoadConstantInstruction(this.mInstructions, 2, constantDoubleInfo, true);
        }
    }

    public void loadLocal(LocalVariable localVariable) {
        if (localVariable == null) {
            throw new NullPointerException("No local variable specified");
        }
        TypeDescriptor typeDescriptor = localVariable.getType();
        Class clazz = typeDescriptor.getClassArg();
        int n = 1;
        if (clazz != null && typeDescriptor.getDimensions() == 0 && (clazz == Long.TYPE || clazz == Double.TYPE)) {
            ++n;
        }
        new InstructionList.LoadLocalInstruction(this.mInstructions, n, localVariable);
    }

    public void loadThis() {
        if (this.mThisReference == null) {
            throw new RuntimeException("Attempt to load \"this\" reference in a static method");
        }
        this.loadLocal(this.mThisReference);
    }

    public void storeLocal(LocalVariable localVariable) {
        if (localVariable == null) {
            throw new NullPointerException("No local variable specified");
        }
        TypeDescriptor typeDescriptor = localVariable.getType();
        Class clazz = typeDescriptor.getClassArg();
        int n = -1;
        if (clazz != null && typeDescriptor.getDimensions() == 0 && (clazz == Long.TYPE || clazz == Double.TYPE)) {
            --n;
        }
        new InstructionList.StoreLocalInstruction(this.mInstructions, n, localVariable);
    }

    public void loadFromArray(Class clazz) {
        int n;
        int n2;
        if (clazz == Integer.TYPE) {
            n2 = -1;
            n = 46;
        } else if (clazz == Boolean.TYPE || clazz == Byte.TYPE) {
            n2 = -1;
            n = 51;
        } else if (clazz == Short.TYPE) {
            n2 = -1;
            n = 53;
        } else if (clazz == Character.TYPE) {
            n2 = -1;
            n = 52;
        } else if (clazz == Long.TYPE) {
            n2 = 0;
            n = 47;
        } else if (clazz == Float.TYPE) {
            n2 = -1;
            n = 48;
        } else if (clazz == Double.TYPE) {
            n2 = 0;
            n = 49;
        } else {
            n2 = -1;
            n = 50;
        }
        this.addCode(n2, (byte)n);
    }

    public void storeToArray(Class clazz) {
        int n;
        int n2;
        if (clazz == Integer.TYPE) {
            n2 = -3;
            n = 79;
        } else if (clazz == Boolean.TYPE || clazz == Byte.TYPE) {
            n2 = -3;
            n = 84;
        } else if (clazz == Short.TYPE) {
            n2 = -3;
            n = 86;
        } else if (clazz == Character.TYPE) {
            n2 = -3;
            n = 85;
        } else if (clazz == Long.TYPE) {
            n2 = -4;
            n = 80;
        } else if (clazz == Float.TYPE) {
            n2 = -3;
            n = 81;
        } else if (clazz == Double.TYPE) {
            n2 = -4;
            n = 82;
        } else {
            n2 = -3;
            n = 83;
        }
        this.addCode(n2, (byte)n);
    }

    public void loadField(String string, TypeDescriptor typeDescriptor) {
        this.getfield(0, (byte)-76, this.constantField(string, typeDescriptor), typeDescriptor);
    }

    public void loadField(String string, String string2, TypeDescriptor typeDescriptor) {
        this.getfield(0, (byte)-76, this.mCp.addConstantField(string, string2, typeDescriptor), typeDescriptor);
    }

    public void loadStaticField(String string, TypeDescriptor typeDescriptor) {
        this.getfield(1, (byte)-78, this.constantField(string, typeDescriptor), typeDescriptor);
    }

    public void loadStaticField(String string, String string2, TypeDescriptor typeDescriptor) {
        this.getfield(1, (byte)-78, this.mCp.addConstantField(string, string2, typeDescriptor), typeDescriptor);
    }

    private void getfield(int n, byte by, ConstantInfo constantInfo, TypeDescriptor typeDescriptor) {
        Class clazz = typeDescriptor.getClassArg();
        if (clazz != null && typeDescriptor.getDimensions() == 0 && (clazz == Long.TYPE || clazz == Double.TYPE)) {
            ++n;
        }
        this.addCode(n, by, constantInfo);
    }

    private ConstantFieldInfo constantField(String string, TypeDescriptor typeDescriptor) {
        return this.mCp.addConstantField(this.mClassFile.getClassName(), string, typeDescriptor);
    }

    public void storeField(String string, TypeDescriptor typeDescriptor) {
        this.putfield(-1, (byte)-75, this.constantField(string, typeDescriptor), typeDescriptor);
    }

    public void storeField(String string, String string2, TypeDescriptor typeDescriptor) {
        this.putfield(-1, (byte)-75, this.mCp.addConstantField(string, string2, typeDescriptor), typeDescriptor);
    }

    public void storeStaticField(String string, TypeDescriptor typeDescriptor) {
        this.putfield(0, (byte)-77, this.constantField(string, typeDescriptor), typeDescriptor);
    }

    public void storeStaticField(String string, String string2, TypeDescriptor typeDescriptor) {
        this.putfield(0, (byte)-77, this.mCp.addConstantField(string, string2, typeDescriptor), typeDescriptor);
    }

    private void putfield(int n, byte by, ConstantInfo constantInfo, TypeDescriptor typeDescriptor) {
        Class clazz = typeDescriptor.getClassArg();
        n = clazz != null && typeDescriptor.getDimensions() == 0 && (clazz == Long.TYPE || clazz == Double.TYPE) ? (n -= 2) : --n;
        this.addCode(n, by, constantInfo);
    }

    public void returnVoid() {
        this.addCode(0, (byte)-79);
    }

    public void returnValue(Class clazz) {
        int n;
        int n2 = -1;
        if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE) {
            n = -84;
        } else if (clazz == Long.TYPE) {
            --n2;
            n = -83;
        } else if (clazz == Float.TYPE) {
            n = -82;
        } else if (clazz == Double.TYPE) {
            --n2;
            n = -81;
        } else if (clazz == Void.TYPE) {
            ++n2;
            n = -79;
        } else {
            n = -80;
        }
        this.addCode(n2, (byte)n);
    }

    public void convert(Class clazz, Class clazz2) {
        int n = 0;
        if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE) {
            int n2;
            if (clazz2 == Byte.TYPE) {
                n2 = -111;
            } else if (clazz2 == Short.TYPE) {
                n2 = -109;
            } else if (clazz2 == Character.TYPE) {
                n2 = -110;
            } else if (clazz2 == Float.TYPE) {
                n2 = -122;
            } else if (clazz2 == Long.TYPE) {
                n = 1;
                n2 = -123;
            } else if (clazz2 == Double.TYPE) {
                n = 1;
                n2 = -121;
            } else {
                if (clazz2 == Integer.TYPE) {
                    return;
                }
                throw new RuntimeException("Invalid conversion: int to " + clazz2);
            }
            this.addCode(n, (byte)n2);
            return;
        }
        if (clazz == Long.TYPE) {
            byte by;
            if (clazz2 == Integer.TYPE) {
                n = -1;
                by = -120;
            } else if (clazz2 == Float.TYPE) {
                n = -1;
                by = -119;
            } else if (clazz2 == Double.TYPE) {
                by = -118;
            } else {
                if (clazz2 == Byte.TYPE || clazz2 == Character.TYPE || clazz2 == Short.TYPE) {
                    this.convert(clazz, Integer.TYPE);
                    this.convert(Integer.TYPE, clazz2);
                    return;
                }
                if (clazz2 == Long.TYPE) {
                    return;
                }
                throw new RuntimeException("Invalid conversion: long to " + clazz2);
            }
            this.addCode(n, by);
            return;
        }
        if (clazz == Float.TYPE) {
            int n3;
            if (clazz2 == Integer.TYPE) {
                n3 = -117;
            } else if (clazz2 == Long.TYPE) {
                n = 1;
                n3 = -116;
            } else if (clazz2 == Double.TYPE) {
                n = 1;
                n3 = -115;
            } else {
                if (clazz2 == Byte.TYPE || clazz2 == Character.TYPE || clazz2 == Short.TYPE) {
                    this.convert(clazz, Integer.TYPE);
                    this.convert(Integer.TYPE, clazz2);
                    return;
                }
                if (clazz2 == Float.TYPE) {
                    return;
                }
                throw new RuntimeException("Invalid conversion: float to " + clazz2);
            }
            this.addCode(n, (byte)n3);
            return;
        }
        if (clazz == Double.TYPE) {
            byte by;
            if (clazz2 == Integer.TYPE) {
                n = -1;
                by = -114;
            } else if (clazz2 == Float.TYPE) {
                n = -1;
                by = -112;
            } else if (clazz2 == Long.TYPE) {
                by = -113;
            } else {
                if (clazz2 == Byte.TYPE || clazz2 == Character.TYPE || clazz2 == Short.TYPE) {
                    this.convert(clazz, Integer.TYPE);
                    this.convert(Integer.TYPE, clazz2);
                    return;
                }
                if (clazz2 == Double.TYPE) {
                    return;
                }
                throw new RuntimeException("Invalid conversion: double to " + clazz2);
            }
            this.addCode(n, by);
            return;
        }
        throw new RuntimeException("Invalid conversion: " + clazz + " to " + clazz2);
    }

    public void invoke(Method method) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(method.getReturnType());
        Class<?>[] classArray = method.getParameterTypes();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[classArray.length];
        int n = 0;
        while (n < typeDescriptorArray.length) {
            typeDescriptorArray[n] = new TypeDescriptor(classArray[n]);
            ++n;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isStatic(method.getModifiers())) {
            this.invokeStatic(clazz.getName(), method.getName(), typeDescriptor, typeDescriptorArray);
        } else if (clazz.isInterface()) {
            this.invokeInterface(clazz.getName(), method.getName(), typeDescriptor, typeDescriptorArray);
        } else {
            this.invokeVirtual(clazz.getName(), method.getName(), typeDescriptor, typeDescriptorArray);
        }
    }

    public void invoke(Constructor constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[classArray.length];
        int n = 0;
        while (n < typeDescriptorArray.length) {
            typeDescriptorArray[n] = new TypeDescriptor(classArray[n]);
            ++n;
        }
        this.invokeConstructor(constructor.getDeclaringClass().toString(), typeDescriptorArray);
    }

    public void invokeVirtual(String string, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        ConstantMethodInfo constantMethodInfo = this.mCp.addConstantMethod(this.mClassFile.getClassName(), string, typeDescriptor, typeDescriptorArray);
        int n = this.returnSize(typeDescriptor) - 1;
        if (typeDescriptorArray != null) {
            n -= this.argSize(typeDescriptorArray);
        }
        this.addCode(n, (byte)-74, constantMethodInfo);
    }

    public void invokeVirtual(String string, String string2, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        ConstantMethodInfo constantMethodInfo = this.mCp.addConstantMethod(string, string2, typeDescriptor, typeDescriptorArray);
        int n = this.returnSize(typeDescriptor) - 1;
        if (typeDescriptorArray != null) {
            n -= this.argSize(typeDescriptorArray);
        }
        this.addCode(n, (byte)-74, constantMethodInfo);
    }

    public void invokeStatic(String string, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        ConstantMethodInfo constantMethodInfo = this.mCp.addConstantMethod(this.mClassFile.getClassName(), string, typeDescriptor, typeDescriptorArray);
        int n = this.returnSize(typeDescriptor) - 0;
        if (typeDescriptorArray != null) {
            n -= this.argSize(typeDescriptorArray);
        }
        this.addCode(n, (byte)-72, constantMethodInfo);
    }

    public void invokeStatic(String string, String string2, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        ConstantMethodInfo constantMethodInfo = this.mCp.addConstantMethod(string, string2, typeDescriptor, typeDescriptorArray);
        int n = this.returnSize(typeDescriptor) - 0;
        if (typeDescriptorArray != null) {
            n -= this.argSize(typeDescriptorArray);
        }
        this.addCode(n, (byte)-72, constantMethodInfo);
    }

    public void invokeInterface(String string, String string2, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        ConstantInterfaceMethodInfo constantInterfaceMethodInfo = this.mCp.addConstantInterfaceMethod(string, string2, typeDescriptor, typeDescriptorArray);
        int n = 1;
        if (typeDescriptorArray != null) {
            n += this.argSize(typeDescriptorArray);
        }
        int n2 = this.returnSize(typeDescriptor) - n;
        byte[] byArray = new byte[]{-71, 0, 0, (byte)n, 0};
        new InstructionList.ConstantOperandInstruction(this.mInstructions, n2, byArray, constantInterfaceMethodInfo);
    }

    public void invokePrivate(String string, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        ConstantMethodInfo constantMethodInfo = this.mCp.addConstantMethod(this.mClassFile.getClassName(), string, typeDescriptor, typeDescriptorArray);
        int n = this.returnSize(typeDescriptor) - 1;
        if (typeDescriptorArray != null) {
            n -= this.argSize(typeDescriptorArray);
        }
        this.addCode(n, (byte)-73, constantMethodInfo);
    }

    public void invokeSuper(String string, String string2, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        ConstantMethodInfo constantMethodInfo = this.mCp.addConstantMethod(string, string2, typeDescriptor, typeDescriptorArray);
        int n = this.returnSize(typeDescriptor) - 1;
        if (typeDescriptorArray != null) {
            n -= this.argSize(typeDescriptorArray);
        }
        this.addCode(n, (byte)-73, constantMethodInfo);
    }

    public void invokeSuper(Method method) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(method.getReturnType());
        Class<?>[] classArray = method.getParameterTypes();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[classArray.length];
        int n = 0;
        while (n < typeDescriptorArray.length) {
            typeDescriptorArray[n] = new TypeDescriptor(classArray[n]);
            ++n;
        }
        this.invokeSuper(method.getDeclaringClass().getName(), method.getName(), typeDescriptor, typeDescriptorArray);
    }

    public void invokeConstructor(TypeDescriptor[] typeDescriptorArray) {
        ConstantMethodInfo constantMethodInfo = this.mCp.addConstantConstructor(this.mClassFile.getClassName(), typeDescriptorArray);
        int n = -1;
        if (typeDescriptorArray != null) {
            n -= this.argSize(typeDescriptorArray);
        }
        this.addCode(n, (byte)-73, constantMethodInfo);
    }

    public void invokeConstructor(String string, TypeDescriptor[] typeDescriptorArray) {
        ConstantMethodInfo constantMethodInfo = this.mCp.addConstantConstructor(string, typeDescriptorArray);
        int n = -1;
        if (typeDescriptorArray != null) {
            n -= this.argSize(typeDescriptorArray);
        }
        this.addCode(n, (byte)-73, constantMethodInfo);
    }

    public void invokeSuperConstructor(TypeDescriptor[] typeDescriptorArray) {
        this.invokeConstructor(this.mClassFile.getSuperClassName(), typeDescriptorArray);
    }

    public void invokeSuper(Constructor constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[classArray.length];
        int n = 0;
        while (n < typeDescriptorArray.length) {
            typeDescriptorArray[n] = new TypeDescriptor(classArray[n]);
            ++n;
        }
        this.invokeSuperConstructor(typeDescriptorArray);
    }

    private int returnSize(TypeDescriptor typeDescriptor) {
        if (typeDescriptor == null) {
            return 0;
        }
        String string = typeDescriptor.getClassName();
        if (string.equals(Void.TYPE.getName())) {
            return 0;
        }
        if (string.equals(Long.TYPE.getName()) || string.equals(Double.TYPE.getName())) {
            return 2;
        }
        return 1;
    }

    private int argSize(TypeDescriptor[] typeDescriptorArray) {
        int n = 0;
        if (typeDescriptorArray != null) {
            int n2 = 0;
            while (n2 < typeDescriptorArray.length) {
                String string = typeDescriptorArray[n2].getClassName();
                n = string.equals(Long.TYPE.getName()) || string.equals(Double.TYPE.getName()) ? (n += 2) : ++n;
                ++n2;
            }
        }
        return n;
    }

    public void newObject(TypeDescriptor typeDescriptor) {
        int n = typeDescriptor.getSpecifiedDimensions();
        if (n == 0) {
            ConstantClassInfo constantClassInfo = this.mCp.addConstantClass(typeDescriptor);
            this.addCode(1, (byte)-69, constantClassInfo);
            return;
        }
        TypeDescriptor typeDescriptor2 = typeDescriptor.getComponentType();
        if (n == 1) {
            Object object;
            if (typeDescriptor2.getDimensions() == 0 && (object = typeDescriptor2.getClassArg()) != null && ((Class)object).isPrimitive()) {
                int n2 = 0;
                if (object == Integer.TYPE) {
                    n2 = 10;
                } else if (object == Byte.TYPE) {
                    n2 = 8;
                } else if (object == Boolean.TYPE) {
                    n2 = 4;
                } else if (object == Character.TYPE) {
                    n2 = 5;
                } else if (object == Float.TYPE) {
                    n2 = 6;
                } else if (object == Double.TYPE) {
                    n2 = 7;
                } else if (object == Short.TYPE) {
                    n2 = 9;
                } else if (object == Long.TYPE) {
                    n2 = 11;
                }
                this.addCode(0, (byte)-68, (byte)n2);
                return;
            }
            object = this.mCp.addConstantClass(typeDescriptor2);
            this.addCode(0, (byte)-67, (ConstantInfo)object);
            return;
        }
        int n3 = -(n - 1);
        ConstantClassInfo constantClassInfo = this.mCp.addConstantClass(typeDescriptor2);
        byte[] byArray = new byte[]{-59, 0, 0, (byte)n};
        new InstructionList.ConstantOperandInstruction(this.mInstructions, n3, byArray, constantClassInfo);
    }

    public void dup() {
        this.addCode(1, (byte)89);
    }

    public void dupX1() {
        this.addCode(1, (byte)90);
    }

    public void dupX2() {
        this.addCode(1, (byte)91);
    }

    public void dup2() {
        this.addCode(2, (byte)92);
    }

    public void dup2X1() {
        this.addCode(2, (byte)93);
    }

    public void dup2X2() {
        this.addCode(2, (byte)94);
    }

    public void pop() {
        this.addCode(-1, (byte)87);
    }

    public void pop2() {
        this.addCode(-2, (byte)88);
    }

    public void swap() {
        this.addCode(0, (byte)95);
    }

    public void swap2() {
        this.dup2X2();
        this.pop2();
    }

    private void branch(int n, Location location, byte by) {
        new InstructionList.BranchInstruction(this.mInstructions, n, by, location);
    }

    public void branch(Location location) {
        this.branch(0, location, (byte)-89);
    }

    public void ifNullBranch(Location location, boolean bl) {
        this.branch(-1, location, bl ? (byte)-58 : -57);
    }

    public void ifEqualBranch(Location location, boolean bl) {
        this.branch(-2, location, bl ? (byte)-91 : -90);
    }

    public void ifZeroComparisonBranch(Location location, String string) throws IllegalArgumentException {
        int n;
        if ((string = string.intern()) == "==") {
            n = -103;
        } else if (string == "!=") {
            n = -102;
        } else if (string == "<") {
            n = -101;
        } else if (string == ">=") {
            n = -100;
        } else if (string == ">") {
            n = -99;
        } else if (string == "<=") {
            n = -98;
        } else {
            throw new IllegalArgumentException("Invalid comparision choice: " + string);
        }
        this.branch(-1, location, (byte)n);
    }

    public void ifComparisonBranch(Location location, String string) throws IllegalArgumentException {
        int n;
        if ((string = string.intern()) == "==") {
            n = -97;
        } else if (string == "!=") {
            n = -96;
        } else if (string == "<") {
            n = -95;
        } else if (string == ">=") {
            n = -94;
        } else if (string == ">") {
            n = -93;
        } else if (string == "<=") {
            n = -92;
        } else {
            throw new IllegalArgumentException("Invalid comparision choice: " + string);
        }
        this.branch(-2, location, (byte)n);
    }

    public void switchBranch(int[] nArray, Location[] locationArray, Location location) {
        new InstructionList.SwitchInstruction(this.mInstructions, nArray, locationArray, location);
    }

    public void jsr(Location location) {
        this.branch(1, location, (byte)-88);
    }

    public void ret(LocalVariable localVariable) {
        if (localVariable == null) {
            throw new NullPointerException("No local variable specified");
        }
        new InstructionList.RetInstruction(this.mInstructions, localVariable);
    }

    public void math(byte by) {
        int n;
        switch (by) {
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                n = 0;
                break;
            }
            case -128: 
            case -126: 
            case -107: 
            case -106: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                n = -1;
                break;
            }
            case -127: 
            case -125: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                n = -2;
                break;
            }
            case -108: 
            case -105: 
            case -104: {
                n = -3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a math opcode: " + Opcode.getMnemonic(by));
            }
        }
        this.addCode(n, by);
    }

    public void arrayLength() {
        this.addCode(0, (byte)-66);
    }

    public void throwObject() {
        this.addCode(-1, (byte)-65);
    }

    public void checkCast(TypeDescriptor typeDescriptor) {
        ConstantClassInfo constantClassInfo = this.mCp.addConstantClass(typeDescriptor);
        this.addCode(0, (byte)-64, constantClassInfo);
    }

    public void instanceOf(TypeDescriptor typeDescriptor) {
        ConstantClassInfo constantClassInfo = this.mCp.addConstantClass(typeDescriptor);
        this.addCode(0, (byte)-63, constantClassInfo);
    }

    public void integerIncrement(LocalVariable localVariable, int n) {
        if (localVariable == null) {
            throw new NullPointerException("No local variable specified");
        }
        if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
            new InstructionList.ShortIncrementInstruction(this.mInstructions, localVariable, (short)n);
        } else {
            this.loadLocal(localVariable);
            this.loadConstant(n);
            this.math((byte)96);
            this.storeLocal(localVariable);
        }
    }

    public void monitorEnter() {
        this.addCode(-1, (byte)-62);
    }

    public void monitorExit() {
        this.addCode(-1, (byte)-61);
    }

    public void nop() {
        this.addCode(0, (byte)0);
    }

    public void breakpoint() {
        this.addCode(0, (byte)-54);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

