/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.CodeAssembler;
import com.go.trove.classfile.CodeAttr;
import com.go.trove.classfile.CodeBuffer;
import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantDoubleInfo;
import com.go.trove.classfile.ConstantFieldInfo;
import com.go.trove.classfile.ConstantFloatInfo;
import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantIntegerInfo;
import com.go.trove.classfile.ConstantInterfaceMethodInfo;
import com.go.trove.classfile.ConstantLongInfo;
import com.go.trove.classfile.ConstantMethodInfo;
import com.go.trove.classfile.ConstantNameAndTypeInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantStringInfo;
import com.go.trove.classfile.Descriptor;
import com.go.trove.classfile.ExceptionHandler;
import com.go.trove.classfile.Label;
import com.go.trove.classfile.LocalVariable;
import com.go.trove.classfile.Location;
import com.go.trove.classfile.MethodDescriptor;
import com.go.trove.classfile.MethodInfo;
import com.go.trove.classfile.TypeDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CodeDisassembler {
    private final MethodInfo mMethod;
    private final String mEnclosingClassName;
    private final String mSuperClassName;
    private final CodeAttr mCode;
    private final ConstantPool mCp;
    private final byte[] mByteCodes;
    private final ExceptionHandler[] mExceptionHandlers;
    private CodeAssembler mAssembler;
    private Vector mLocals;
    private boolean mHasThis;
    private Map mLabels;
    private Map mCatchLocations;
    private int mAddress;
    static /* synthetic */ Class class$java$lang$Object;

    public CodeDisassembler(MethodInfo methodInfo) {
        this.mMethod = methodInfo;
        this.mEnclosingClassName = methodInfo.getClassFile().getClassName();
        this.mSuperClassName = methodInfo.getClassFile().getSuperClassName();
        this.mCode = methodInfo.getCodeAttr();
        this.mCp = this.mCode.getConstantPool();
        CodeBuffer codeBuffer = this.mCode.getCodeBuffer();
        this.mByteCodes = codeBuffer.getByteCodes();
        this.mExceptionHandlers = codeBuffer.getExceptionHandlers();
    }

    public synchronized void disassemble(CodeAssembler codeAssembler) {
        int n;
        Object object;
        this.mAssembler = codeAssembler;
        this.mLocals = new Vector();
        this.mHasThis = !this.mMethod.getAccessFlags().isStatic();
        this.gatherLabels();
        LocalVariable[] localVariableArray = codeAssembler.getParameters();
        int n2 = 0;
        while (n2 < localVariableArray.length) {
            object = localVariableArray[n2];
            n = object.getNumber();
            if (n >= this.mLocals.size()) {
                this.mLocals.setSize(n + 1);
            }
            this.mLocals.setElementAt(object, n);
            ++n2;
        }
        object = new Location(){

            public int getLocation() {
                return CodeDisassembler.this.mAddress;
            }

            public int compareTo(Object object) {
                int n;
                if (this == object) {
                    return 0;
                }
                Location location = (Location)object;
                int n2 = this.getLocation();
                if (n2 < (n = location.getLocation())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
        };
        n = -1;
        this.mAddress = 0;
        while (this.mAddress < this.mByteCodes.length) {
            int n3 = this.mCode.getLineNumber((Location)object);
            if (n3 != n && (n = n3) >= 0) {
                this.mAssembler.mapLineNumber(n);
            }
            this.locateLabel();
            byte by = this.mByteCodes[this.mAddress];
            block2 : switch (by) {
                default: {
                    break;
                }
                case 0: {
                    codeAssembler.nop();
                    break;
                }
                case -54: {
                    codeAssembler.breakpoint();
                    break;
                }
                case 1: {
                    codeAssembler.loadConstant(null);
                    break;
                }
                case 2: {
                    codeAssembler.loadConstant(-1);
                    break;
                }
                case 3: {
                    codeAssembler.loadConstant(0);
                    break;
                }
                case 4: {
                    codeAssembler.loadConstant(1);
                    break;
                }
                case 5: {
                    codeAssembler.loadConstant(2);
                    break;
                }
                case 6: {
                    codeAssembler.loadConstant(3);
                    break;
                }
                case 7: {
                    codeAssembler.loadConstant(4);
                    break;
                }
                case 8: {
                    codeAssembler.loadConstant(5);
                    break;
                }
                case 9: {
                    codeAssembler.loadConstant(0L);
                    break;
                }
                case 10: {
                    codeAssembler.loadConstant(1L);
                    break;
                }
                case 11: {
                    codeAssembler.loadConstant(0.0f);
                    break;
                }
                case 12: {
                    codeAssembler.loadConstant(1.0f);
                    break;
                }
                case 13: {
                    codeAssembler.loadConstant(2.0f);
                    break;
                }
                case 14: {
                    codeAssembler.loadConstant(0.0);
                    break;
                }
                case 15: {
                    codeAssembler.loadConstant(1.0);
                    break;
                }
                case 87: {
                    codeAssembler.pop();
                    break;
                }
                case 88: {
                    codeAssembler.pop2();
                    break;
                }
                case 89: {
                    codeAssembler.dup();
                    break;
                }
                case 90: {
                    codeAssembler.dupX1();
                    break;
                }
                case 91: {
                    codeAssembler.dupX2();
                    break;
                }
                case 92: {
                    codeAssembler.dup2();
                    break;
                }
                case 93: {
                    codeAssembler.dup2X2();
                    break;
                }
                case 94: {
                    codeAssembler.dup2X2();
                    break;
                }
                case 95: {
                    codeAssembler.swap();
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    codeAssembler.math(by);
                    break;
                }
                case -123: {
                    codeAssembler.convert(Integer.TYPE, Long.TYPE);
                    break;
                }
                case -122: {
                    codeAssembler.convert(Integer.TYPE, Float.TYPE);
                    break;
                }
                case -121: {
                    codeAssembler.convert(Integer.TYPE, Double.TYPE);
                    break;
                }
                case -120: {
                    codeAssembler.convert(Long.TYPE, Integer.TYPE);
                    break;
                }
                case -119: {
                    codeAssembler.convert(Long.TYPE, Float.TYPE);
                    break;
                }
                case -118: {
                    codeAssembler.convert(Long.TYPE, Double.TYPE);
                    break;
                }
                case -117: {
                    codeAssembler.convert(Float.TYPE, Integer.TYPE);
                    break;
                }
                case -116: {
                    codeAssembler.convert(Float.TYPE, Long.TYPE);
                    break;
                }
                case -115: {
                    codeAssembler.convert(Float.TYPE, Double.TYPE);
                    break;
                }
                case -114: {
                    codeAssembler.convert(Double.TYPE, Integer.TYPE);
                    break;
                }
                case -113: {
                    codeAssembler.convert(Double.TYPE, Long.TYPE);
                    break;
                }
                case -112: {
                    codeAssembler.convert(Double.TYPE, Float.TYPE);
                    break;
                }
                case -111: {
                    codeAssembler.convert(Integer.TYPE, Byte.TYPE);
                    break;
                }
                case -110: {
                    codeAssembler.convert(Integer.TYPE, Character.TYPE);
                    break;
                }
                case -109: {
                    codeAssembler.convert(Integer.TYPE, Short.TYPE);
                    break;
                }
                case -84: {
                    codeAssembler.returnValue(Integer.TYPE);
                    break;
                }
                case -83: {
                    codeAssembler.returnValue(Long.TYPE);
                    break;
                }
                case -82: {
                    codeAssembler.returnValue(Float.TYPE);
                    break;
                }
                case -81: {
                    codeAssembler.returnValue(Double.TYPE);
                    break;
                }
                case -80: {
                    codeAssembler.returnValue(class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object);
                    break;
                }
                case -79: {
                    codeAssembler.returnVoid();
                    break;
                }
                case 46: {
                    codeAssembler.loadFromArray(Integer.TYPE);
                    break;
                }
                case 47: {
                    codeAssembler.loadFromArray(Long.TYPE);
                    break;
                }
                case 48: {
                    codeAssembler.loadFromArray(Float.TYPE);
                    break;
                }
                case 49: {
                    codeAssembler.loadFromArray(Double.TYPE);
                    break;
                }
                case 50: {
                    codeAssembler.loadFromArray(class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object);
                    break;
                }
                case 51: {
                    codeAssembler.loadFromArray(Byte.TYPE);
                    break;
                }
                case 52: {
                    codeAssembler.loadFromArray(Character.TYPE);
                    break;
                }
                case 53: {
                    codeAssembler.loadFromArray(Short.TYPE);
                    break;
                }
                case 79: {
                    codeAssembler.storeToArray(Integer.TYPE);
                    break;
                }
                case 80: {
                    codeAssembler.storeToArray(Long.TYPE);
                    break;
                }
                case 81: {
                    codeAssembler.storeToArray(Float.TYPE);
                    break;
                }
                case 82: {
                    codeAssembler.storeToArray(Double.TYPE);
                    break;
                }
                case 83: {
                    codeAssembler.storeToArray(class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object);
                    break;
                }
                case 84: {
                    codeAssembler.storeToArray(Byte.TYPE);
                    break;
                }
                case 85: {
                    codeAssembler.storeToArray(Character.TYPE);
                    break;
                }
                case 86: {
                    codeAssembler.storeToArray(Short.TYPE);
                    break;
                }
                case -66: {
                    codeAssembler.arrayLength();
                    break;
                }
                case -65: {
                    codeAssembler.throwObject();
                    break;
                }
                case -62: {
                    codeAssembler.monitorEnter();
                    break;
                }
                case -61: {
                    codeAssembler.monitorExit();
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    int n4;
                    switch (by) {
                        case 18: {
                            n4 = this.readUnsignedByte();
                            break;
                        }
                        case 19: 
                        case 20: {
                            n4 = this.readUnsignedShort();
                            break;
                        }
                        default: {
                            n4 = 0;
                        }
                    }
                    ConstantInfo constantInfo = this.mCp.getConstant(n4);
                    if (constantInfo instanceof ConstantStringInfo) {
                        codeAssembler.loadConstant(((ConstantStringInfo)constantInfo).getValue());
                        break;
                    }
                    if (constantInfo instanceof ConstantIntegerInfo) {
                        codeAssembler.loadConstant(((ConstantIntegerInfo)constantInfo).getValue());
                        break;
                    }
                    if (constantInfo instanceof ConstantLongInfo) {
                        codeAssembler.loadConstant(((ConstantLongInfo)constantInfo).getValue());
                        break;
                    }
                    if (constantInfo instanceof ConstantFloatInfo) {
                        codeAssembler.loadConstant(((ConstantFloatInfo)constantInfo).getValue().floatValue());
                        break;
                    }
                    if (!(constantInfo instanceof ConstantDoubleInfo)) break;
                    codeAssembler.loadConstant(((ConstantDoubleInfo)constantInfo).getValue());
                    break;
                }
                case -69: {
                    ConstantInfo constantInfo = this.mCp.getConstant(this.readUnsignedShort());
                    if (!(constantInfo instanceof ConstantClassInfo)) break;
                    codeAssembler.newObject(((ConstantClassInfo)constantInfo).getTypeDescriptor());
                    break;
                }
                case -67: {
                    ConstantInfo constantInfo = this.mCp.getConstant(this.readUnsignedShort());
                    if (!(constantInfo instanceof ConstantClassInfo)) break;
                    TypeDescriptor typeDescriptor = ((ConstantClassInfo)constantInfo).getTypeDescriptor();
                    typeDescriptor = new TypeDescriptor(typeDescriptor, 1);
                    codeAssembler.newObject(typeDescriptor);
                    break;
                }
                case -59: {
                    ConstantInfo constantInfo = this.mCp.getConstant(this.readUnsignedShort());
                    int n5 = this.readUnsignedByte();
                    if (!(constantInfo instanceof ConstantClassInfo)) break;
                    codeAssembler.newObject(((ConstantClassInfo)constantInfo).getTypeDescriptor());
                    break;
                }
                case -64: {
                    ConstantInfo constantInfo = this.mCp.getConstant(this.readUnsignedShort());
                    if (!(constantInfo instanceof ConstantClassInfo)) break;
                    codeAssembler.checkCast(((ConstantClassInfo)constantInfo).getTypeDescriptor());
                    break;
                }
                case -63: {
                    ConstantInfo constantInfo = this.mCp.getConstant(this.readUnsignedShort());
                    if (!(constantInfo instanceof ConstantClassInfo)) break;
                    codeAssembler.instanceOf(((ConstantClassInfo)constantInfo).getTypeDescriptor());
                    break;
                }
                case -78: 
                case -77: 
                case -76: 
                case -75: {
                    ConstantInfo constantInfo = this.mCp.getConstant(this.readUnsignedShort());
                    if (!(constantInfo instanceof ConstantFieldInfo)) break;
                    ConstantFieldInfo constantFieldInfo = (ConstantFieldInfo)constantInfo;
                    String string = constantFieldInfo.getParentClass().getClassName();
                    if (this.mEnclosingClassName.equals(string)) {
                        string = null;
                    }
                    String string2 = constantFieldInfo.getNameAndType().getName();
                    Descriptor descriptor = constantFieldInfo.getNameAndType().getType();
                    if (!(descriptor instanceof TypeDescriptor)) break;
                    switch (by) {
                        case -78: {
                            if (string == null) {
                                codeAssembler.loadStaticField(string2, (TypeDescriptor)descriptor);
                                break;
                            }
                            codeAssembler.loadStaticField(string, string2, (TypeDescriptor)descriptor);
                            break;
                        }
                        case -77: {
                            if (string == null) {
                                codeAssembler.storeStaticField(string2, (TypeDescriptor)descriptor);
                                break;
                            }
                            codeAssembler.storeStaticField(string, string2, (TypeDescriptor)descriptor);
                            break;
                        }
                        case -76: {
                            if (string == null) {
                                codeAssembler.loadField(string2, (TypeDescriptor)descriptor);
                                break;
                            }
                            codeAssembler.loadField(string, string2, (TypeDescriptor)descriptor);
                            break;
                        }
                        case -75: {
                            if (string == null) {
                                codeAssembler.storeField(string2, (TypeDescriptor)descriptor);
                                break;
                            }
                            codeAssembler.storeField(string, string2, (TypeDescriptor)descriptor);
                        }
                    }
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    TypeDescriptor[] typeDescriptorArray;
                    ConstantNameAndTypeInfo constantNameAndTypeInfo;
                    Object object2;
                    String string;
                    ConstantInfo constantInfo = this.mCp.getConstant(this.readUnsignedShort());
                    if (by == -71) {
                        this.readShort();
                        if (!(constantInfo instanceof ConstantInterfaceMethodInfo)) break;
                        object2 = (ConstantInterfaceMethodInfo)constantInfo;
                        string = ((ConstantInterfaceMethodInfo)object2).getParentClass().getClassName();
                        constantNameAndTypeInfo = ((ConstantInterfaceMethodInfo)object2).getNameAndType();
                    } else {
                        if (!(constantInfo instanceof ConstantMethodInfo)) break;
                        object2 = (ConstantMethodInfo)constantInfo;
                        string = ((ConstantMethodInfo)object2).getParentClass().getClassName();
                        if (this.mEnclosingClassName.equals(string)) {
                            string = null;
                        }
                        constantNameAndTypeInfo = ((ConstantMethodInfo)object2).getNameAndType();
                    }
                    object2 = constantNameAndTypeInfo.getName();
                    Descriptor descriptor = constantNameAndTypeInfo.getType();
                    if (!(descriptor instanceof MethodDescriptor)) break;
                    TypeDescriptor typeDescriptor = ((MethodDescriptor)descriptor).getReturnType();
                    if (typeDescriptor.getClassArg() == Void.TYPE) {
                        typeDescriptor = null;
                    }
                    if ((typeDescriptorArray = ((MethodDescriptor)descriptor).getParameterTypes()).length == 0) {
                        typeDescriptorArray = null;
                    }
                    switch (by) {
                        case -74: {
                            if (string == null) {
                                codeAssembler.invokeVirtual((String)object2, typeDescriptor, typeDescriptorArray);
                                break;
                            }
                            codeAssembler.invokeVirtual(string, (String)object2, typeDescriptor, typeDescriptorArray);
                            break;
                        }
                        case -73: {
                            if ("<init>".equals(object2)) {
                                if (string == null) {
                                    codeAssembler.invokeConstructor(typeDescriptorArray);
                                    break;
                                }
                                if (string.equals(this.mSuperClassName)) {
                                    codeAssembler.invokeSuperConstructor(typeDescriptorArray);
                                    break;
                                }
                                codeAssembler.invokeConstructor(string, typeDescriptorArray);
                                break;
                            }
                            if (string == null) {
                                codeAssembler.invokePrivate((String)object2, typeDescriptor, typeDescriptorArray);
                                break;
                            }
                            codeAssembler.invokeSuper(string, (String)object2, typeDescriptor, typeDescriptorArray);
                            break;
                        }
                        case -72: {
                            if (string == null) {
                                codeAssembler.invokeStatic((String)object2, typeDescriptor, typeDescriptorArray);
                                break;
                            }
                            codeAssembler.invokeStatic(string, (String)object2, typeDescriptor, typeDescriptorArray);
                            break;
                        }
                        case -71: {
                            codeAssembler.invokeInterface(string, (String)object2, typeDescriptor, typeDescriptorArray);
                        }
                    }
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    Class clazz;
                    int n4;
                    switch (by) {
                        case 21: 
                        case 54: {
                            n4 = this.readUnsignedByte();
                            clazz = Integer.TYPE;
                            break;
                        }
                        case 22: 
                        case 55: {
                            n4 = this.readUnsignedByte();
                            clazz = Long.TYPE;
                            break;
                        }
                        case 23: 
                        case 56: {
                            n4 = this.readUnsignedByte();
                            clazz = Float.TYPE;
                            break;
                        }
                        case 24: 
                        case 57: {
                            n4 = this.readUnsignedByte();
                            clazz = Double.TYPE;
                            break;
                        }
                        case 25: 
                        case 58: {
                            n4 = this.readUnsignedByte();
                            clazz = class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object;
                            break;
                        }
                        case 26: 
                        case 59: {
                            n4 = 0;
                            clazz = Integer.TYPE;
                            break;
                        }
                        case 27: 
                        case 60: {
                            n4 = 1;
                            clazz = Integer.TYPE;
                            break;
                        }
                        case 28: 
                        case 61: {
                            n4 = 2;
                            clazz = Integer.TYPE;
                            break;
                        }
                        case 29: 
                        case 62: {
                            n4 = 3;
                            clazz = Integer.TYPE;
                            break;
                        }
                        case 30: 
                        case 63: {
                            n4 = 0;
                            clazz = Long.TYPE;
                            break;
                        }
                        case 31: 
                        case 64: {
                            n4 = 1;
                            clazz = Long.TYPE;
                            break;
                        }
                        case 32: 
                        case 65: {
                            n4 = 2;
                            clazz = Long.TYPE;
                            break;
                        }
                        case 33: 
                        case 66: {
                            n4 = 3;
                            clazz = Long.TYPE;
                            break;
                        }
                        case 34: 
                        case 67: {
                            n4 = 0;
                            clazz = Float.TYPE;
                            break;
                        }
                        case 35: 
                        case 68: {
                            n4 = 1;
                            clazz = Float.TYPE;
                            break;
                        }
                        case 36: 
                        case 69: {
                            n4 = 2;
                            clazz = Float.TYPE;
                            break;
                        }
                        case 37: 
                        case 70: {
                            n4 = 3;
                            clazz = Float.TYPE;
                            break;
                        }
                        case 38: 
                        case 71: {
                            n4 = 0;
                            clazz = Double.TYPE;
                            break;
                        }
                        case 39: 
                        case 72: {
                            n4 = 1;
                            clazz = Double.TYPE;
                            break;
                        }
                        case 40: 
                        case 73: {
                            n4 = 2;
                            clazz = Double.TYPE;
                            break;
                        }
                        case 41: 
                        case 74: {
                            n4 = 3;
                            clazz = Double.TYPE;
                            break;
                        }
                        case 42: 
                        case 75: {
                            n4 = 0;
                            clazz = class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object;
                            break;
                        }
                        case 43: 
                        case 76: {
                            n4 = 1;
                            clazz = class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object;
                            break;
                        }
                        case 44: 
                        case 77: {
                            n4 = 2;
                            clazz = class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object;
                            break;
                        }
                        case 45: 
                        case 78: {
                            n4 = 3;
                            clazz = class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object;
                            break;
                        }
                        default: {
                            n4 = 0;
                            clazz = null;
                        }
                    }
                    switch (by) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: {
                            if (n4 == 0 && this.mHasThis) {
                                codeAssembler.loadThis();
                                break;
                            }
                            codeAssembler.loadLocal(this.getLocalVariable(n4, clazz));
                            break;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: {
                            if (n4 == 0 && this.mHasThis) {
                                this.mHasThis = false;
                            }
                            codeAssembler.storeLocal(this.getLocalVariable(n4, clazz));
                        }
                    }
                    break;
                }
                case -87: {
                    LocalVariable localVariable = this.getLocalVariable(this.readUnsignedByte(), class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object);
                    codeAssembler.ret(localVariable);
                    break;
                }
                case -124: {
                    LocalVariable localVariable = this.getLocalVariable(this.readUnsignedByte(), Integer.TYPE);
                    codeAssembler.integerIncrement(localVariable, this.readByte());
                    break;
                }
                case -89: {
                    Label label = this.getLabel(this.mAddress + this.readShort());
                    codeAssembler.branch(label);
                    break;
                }
                case -88: {
                    Label label = this.getLabel(this.mAddress + this.readShort());
                    codeAssembler.jsr(label);
                    break;
                }
                case -56: {
                    Label label = this.getLabel(this.mAddress + this.readInt());
                    codeAssembler.branch(label);
                    break;
                }
                case -55: {
                    Label label = this.getLabel(this.mAddress + this.readInt());
                    codeAssembler.jsr(label);
                    break;
                }
                case -58: {
                    Label label = this.getLabel(this.mAddress + this.readShort());
                    codeAssembler.ifNullBranch(label, true);
                    break;
                }
                case -57: {
                    Label label = this.getLabel(this.mAddress + this.readShort());
                    codeAssembler.ifNullBranch(label, false);
                    break;
                }
                case -91: {
                    Label label = this.getLabel(this.mAddress + this.readShort());
                    codeAssembler.ifEqualBranch(label, true);
                    break;
                }
                case -90: {
                    Label label = this.getLabel(this.mAddress + this.readShort());
                    codeAssembler.ifEqualBranch(label, false);
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: {
                    String string;
                    Label label = this.getLabel(this.mAddress + this.readShort());
                    switch (by) {
                        case -103: {
                            string = "==";
                            break;
                        }
                        case -102: {
                            string = "!=";
                            break;
                        }
                        case -101: {
                            string = "<";
                            break;
                        }
                        case -100: {
                            string = ">=";
                            break;
                        }
                        case -99: {
                            string = ">";
                            break;
                        }
                        case -98: {
                            string = "<=";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    codeAssembler.ifZeroComparisonBranch(label, string);
                    break;
                }
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: {
                    String string;
                    Label label = this.getLabel(this.mAddress + this.readShort());
                    switch (by) {
                        case -97: {
                            string = "==";
                            break;
                        }
                        case -96: {
                            string = "!=";
                            break;
                        }
                        case -95: {
                            string = "<";
                            break;
                        }
                        case -94: {
                            string = ">=";
                            break;
                        }
                        case -93: {
                            string = ">";
                            break;
                        }
                        case -92: {
                            string = "<=";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    codeAssembler.ifComparisonBranch(label, string);
                    break;
                }
                case 16: {
                    codeAssembler.loadConstant(this.readByte());
                    break;
                }
                case 17: {
                    codeAssembler.loadConstant(this.readShort());
                    break;
                }
                case -68: {
                    int n6 = this.readByte();
                    Class clazz = null;
                    switch (n6) {
                        case 4: {
                            clazz = Boolean.TYPE;
                            break;
                        }
                        case 5: {
                            clazz = Character.TYPE;
                            break;
                        }
                        case 6: {
                            clazz = Float.TYPE;
                            break;
                        }
                        case 7: {
                            clazz = Double.TYPE;
                            break;
                        }
                        case 8: {
                            clazz = Byte.TYPE;
                            break;
                        }
                        case 9: {
                            clazz = Short.TYPE;
                            break;
                        }
                        case 10: {
                            clazz = Integer.TYPE;
                            break;
                        }
                        case 11: {
                            clazz = Long.TYPE;
                        }
                    }
                    if (clazz == null) break;
                    codeAssembler.newObject(new TypeDescriptor(new TypeDescriptor(clazz), 1));
                    break;
                }
                case -86: 
                case -85: {
                    Location[] locationArray;
                    int[] nArray;
                    int n7;
                    int n8;
                    int n9 = this.mAddress;
                    while ((this.mAddress + 1 & 3) != 0) {
                        ++this.mAddress;
                    }
                    Label label = this.getLabel(n9 + this.readInt());
                    if (by == -86) {
                        n8 = this.readInt();
                        n7 = this.readInt();
                        int n10 = n7 - n8 + 1;
                        try {
                            nArray = new int[n10];
                        }
                        catch (NegativeArraySizeException negativeArraySizeException) {
                            break;
                        }
                        locationArray = new Location[n10];
                        int n11 = 0;
                        while (n11 < n10) {
                            nArray[n11] = n8 + n11;
                            locationArray[n11] = this.getLabel(n9 + this.readInt());
                            ++n11;
                        }
                    } else {
                        n8 = this.readInt();
                        try {
                            nArray = new int[n8];
                        }
                        catch (NegativeArraySizeException negativeArraySizeException) {
                            break;
                        }
                        locationArray = new Location[n8];
                        n7 = 0;
                        while (n7 < n8) {
                            nArray[n7] = this.readInt();
                            locationArray[n7] = this.getLabel(n9 + this.readInt());
                            ++n7;
                        }
                    }
                    codeAssembler.switchBranch(nArray, locationArray, label);
                    break;
                }
                case -60: {
                    LocalVariable localVariable;
                    Class clazz;
                    int n4;
                    by = this.mByteCodes[++this.mAddress];
                    switch (by) {
                        default: {
                            break block2;
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: {
                            switch (by) {
                                case 21: 
                                case 54: {
                                    clazz = Integer.TYPE;
                                    break;
                                }
                                case 22: 
                                case 55: {
                                    clazz = Long.TYPE;
                                    break;
                                }
                                case 23: 
                                case 56: {
                                    clazz = Float.TYPE;
                                    break;
                                }
                                case 24: 
                                case 57: {
                                    clazz = Double.TYPE;
                                    break;
                                }
                                case 25: 
                                case 58: {
                                    clazz = class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object;
                                    break;
                                }
                                default: {
                                    clazz = null;
                                }
                            }
                            n4 = this.readUnsignedShort();
                            switch (by) {
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 25: {
                                    if (n4 == 0 && this.mHasThis) {
                                        codeAssembler.loadThis();
                                        break;
                                    }
                                    codeAssembler.loadLocal(this.getLocalVariable(n4, clazz));
                                    break;
                                }
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: {
                                    if (n4 == 0 && this.mHasThis) {
                                        this.mHasThis = false;
                                    }
                                    codeAssembler.storeLocal(this.getLocalVariable(n4, clazz));
                                }
                            }
                            break block2;
                        }
                        case -87: {
                            localVariable = this.getLocalVariable(this.readUnsignedShort(), class$java$lang$Object == null ? CodeDisassembler.class$("java.lang.Object") : class$java$lang$Object);
                            codeAssembler.ret(localVariable);
                            break block2;
                        }
                        case -124: 
                    }
                    localVariable = this.getLocalVariable(this.readUnsignedShort(), Integer.TYPE);
                    codeAssembler.integerIncrement(localVariable, this.readShort());
                }
            }
            ++this.mAddress;
        }
    }

    private void gatherLabels() {
        Integer n;
        this.mLabels = new HashMap();
        this.mCatchLocations = new HashMap(this.mExceptionHandlers.length * 2 + 1);
        int n2 = this.mExceptionHandlers.length - 1;
        while (n2 >= 0) {
            ExceptionHandler exceptionHandler = this.mExceptionHandlers[n2];
            n = new Integer(exceptionHandler.getStartLocation().getLocation());
            this.mLabels.put(n, n);
            n = new Integer(exceptionHandler.getEndLocation().getLocation());
            this.mLabels.put(n, n);
            n = new Integer(exceptionHandler.getCatchLocation().getLocation());
            this.mCatchLocations.put(n, exceptionHandler);
            --n2;
        }
        this.mAddress = 0;
        while (this.mAddress < this.mByteCodes.length) {
            byte by = this.mByteCodes[this.mAddress];
            switch (by) {
                default: {
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -88: 
                case -58: 
                case -57: {
                    n = new Integer(this.mAddress + this.readShort());
                    this.mLabels.put(n, n);
                    break;
                }
                case -56: 
                case -55: {
                    n = new Integer(this.mAddress + this.readInt());
                    this.mLabels.put(n, n);
                    break;
                }
                case -86: 
                case -85: {
                    int n3;
                    int n4;
                    int n5 = this.mAddress;
                    while ((this.mAddress + 1 & 3) != 0) {
                        ++this.mAddress;
                    }
                    n = new Integer(n5 + this.readInt());
                    this.mLabels.put(n, n);
                    if (by == -86) {
                        n4 = this.readInt();
                        n3 = this.readInt();
                        int n6 = n3 - n4 + 1;
                        int n7 = 0;
                        while (n7 < n6) {
                            n = new Integer(n5 + this.readInt());
                            this.mLabels.put(n, n);
                            ++n7;
                        }
                    } else {
                        n4 = this.readInt();
                        n3 = 0;
                        while (n3 < n4) {
                            this.mAddress += 4;
                            n = new Integer(n5 + this.readInt());
                            this.mLabels.put(n, n);
                            ++n3;
                        }
                    }
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case -123: 
                case -122: 
                case -121: 
                case -120: 
                case -119: 
                case -118: 
                case -117: 
                case -116: 
                case -115: 
                case -114: 
                case -113: 
                case -112: 
                case -111: 
                case -110: 
                case -109: 
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: 
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: 
                case -66: 
                case -65: 
                case -62: 
                case -61: 
                case -54: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case -124: 
                case -87: 
                case -68: 
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    ++this.mAddress;
                    break;
                }
                case -78: 
                case -77: 
                case -76: 
                case -75: 
                case -74: 
                case -73: 
                case -72: 
                case -69: 
                case -67: 
                case -64: 
                case -63: 
                case 17: 
                case 19: 
                case 20: {
                    this.mAddress += 2;
                    break;
                }
                case -59: {
                    this.mAddress += 3;
                    break;
                }
                case -71: {
                    this.mAddress += 4;
                    break;
                }
                case -60: {
                    by = this.mByteCodes[++this.mAddress];
                    this.mAddress += 2;
                    if (by != -124) break;
                    this.mAddress += 2;
                }
            }
            ++this.mAddress;
        }
    }

    private int readByte() {
        return this.mByteCodes[++this.mAddress];
    }

    private int readUnsignedByte() {
        return this.mByteCodes[++this.mAddress] & 0xFF;
    }

    private int readShort() {
        return this.mByteCodes[++this.mAddress] << 8 | this.mByteCodes[++this.mAddress] & 0xFF;
    }

    private int readUnsignedShort() {
        return (this.mByteCodes[++this.mAddress] & 0xFF) << 8 | (this.mByteCodes[++this.mAddress] & 0xFF) << 0;
    }

    private int readInt() {
        return this.mByteCodes[++this.mAddress] << 24 | (this.mByteCodes[++this.mAddress] & 0xFF) << 16 | (this.mByteCodes[++this.mAddress] & 0xFF) << 8 | (this.mByteCodes[++this.mAddress] & 0xFF) << 0;
    }

    private LocalVariable getLocalVariable(int n, Class clazz) {
        LocalVariable localVariable;
        TypeDescriptor typeDescriptor = new TypeDescriptor(clazz);
        if (n >= this.mLocals.size()) {
            this.mLocals.setSize(n + 1);
            localVariable = null;
        } else {
            localVariable = (LocalVariable)this.mLocals.elementAt(n);
            if (localVariable != null) {
                TypeDescriptor typeDescriptor2 = localVariable.getType();
                Class clazz2 = typeDescriptor.getClassArg();
                Class clazz3 = typeDescriptor2.getClassArg();
                if (clazz2 != null && !clazz2.isPrimitive()) {
                    clazz2 = null;
                }
                if (clazz3 != null && !clazz3.isPrimitive()) {
                    clazz3 = null;
                }
                if (clazz2 == null) {
                    if (clazz3 != null) {
                        localVariable = null;
                    }
                } else if (clazz3 == null) {
                    localVariable = null;
                } else if (clazz2 != clazz3) {
                    localVariable = null;
                }
            }
        }
        if (localVariable == null) {
            localVariable = this.mAssembler.createLocalVariable(null, typeDescriptor);
            this.mLocals.setElementAt(localVariable, n);
        }
        return localVariable;
    }

    private void locateLabel() {
        ExceptionHandler exceptionHandler;
        Integer n = new Integer(this.mAddress);
        Object object = this.mLabels.get(n);
        if (object != null) {
            if (object instanceof Label) {
                ((Label)object).setLocation();
            } else {
                object = this.mAssembler.createLabel().setLocation();
                this.mLabels.put(n, object);
            }
        }
        if ((exceptionHandler = (ExceptionHandler)this.mCatchLocations.get(n)) != null) {
            Label label = this.getLabel(exceptionHandler.getStartLocation().getLocation());
            Label label2 = this.getLabel(exceptionHandler.getEndLocation().getLocation());
            String string = exceptionHandler.getCatchType() == null ? null : exceptionHandler.getCatchType().getClassName();
            this.mAssembler.exceptionHandler(label, label2, string);
        }
    }

    private Label getLabel(int n) {
        Integer n2 = new Integer(n);
        Object object = this.mLabels.get(n2);
        if (!(object instanceof Label)) {
            object = this.mAssembler.createLabel();
            this.mLabels.put(n2, object);
        }
        return (Label)object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

