/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantUTFInfo;
import com.go.trove.classfile.TypeDescriptor;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantClassInfo
extends ConstantInfo {
    private String mClassName;
    private int mDim;
    private TypeDescriptor mType;
    private ConstantUTFInfo mNameConstant;

    static ConstantClassInfo make(ConstantPool constantPool, String string) {
        ConstantClassInfo constantClassInfo = new ConstantClassInfo(constantPool, string);
        return (ConstantClassInfo)constantPool.addConstant(constantClassInfo);
    }

    static ConstantClassInfo make(ConstantPool constantPool, String string, int n) {
        ConstantClassInfo constantClassInfo = new ConstantClassInfo(constantPool, string, n);
        return (ConstantClassInfo)constantPool.addConstant(constantClassInfo);
    }

    static ConstantClassInfo make(ConstantPool constantPool, TypeDescriptor typeDescriptor) {
        ConstantClassInfo constantClassInfo = new ConstantClassInfo(constantPool, typeDescriptor);
        return (ConstantClassInfo)constantPool.addConstant(constantClassInfo);
    }

    ConstantClassInfo(ConstantUTFInfo constantUTFInfo) {
        super(7);
        this.mNameConstant = constantUTFInfo;
        String string = constantUTFInfo.getValue();
        if (!string.endsWith(";")) {
            this.mClassName = string.replace('/', '.');
            this.mDim = 0;
        } else {
            TypeDescriptor typeDescriptor = TypeDescriptor.parseTypeDesc(string);
            this.mClassName = typeDescriptor.getClassName();
            this.mDim = typeDescriptor.getDimensions();
        }
    }

    private ConstantClassInfo(ConstantPool constantPool, String string) {
        super(7);
        this.mClassName = string;
        this.mDim = 0;
        String string2 = string.replace('.', '/');
        this.mNameConstant = ConstantUTFInfo.make(constantPool, string2);
    }

    private ConstantClassInfo(ConstantPool constantPool, String string, int n) {
        super(7);
        this.mClassName = string;
        this.mDim = n;
        String string2 = n > 0 ? TypeDescriptor.generate(string, n) : string.replace('.', '/');
        this.mNameConstant = ConstantUTFInfo.make(constantPool, string2);
    }

    private ConstantClassInfo(ConstantPool constantPool, TypeDescriptor typeDescriptor) {
        super(7);
        this.mClassName = typeDescriptor.getClassName();
        this.mDim = typeDescriptor.getDimensions();
        this.mType = typeDescriptor;
        String string = this.mDim > 0 ? typeDescriptor.toString() : typeDescriptor.getClassName().replace('.', '/');
        this.mNameConstant = ConstantUTFInfo.make(constantPool, string);
    }

    public String getClassName() {
        return this.mClassName;
    }

    public int getDimensions() {
        return this.mDim;
    }

    public TypeDescriptor getTypeDescriptor() {
        if (this.mType == null) {
            this.mType = new TypeDescriptor(this.getClassName());
            int n = this.getDimensions();
            if (n > 0) {
                this.mType = new TypeDescriptor(this.mType, n);
            }
        }
        return this.mType;
    }

    public int hashCode() {
        return this.mClassName.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ConstantClassInfo) {
            ConstantClassInfo constantClassInfo = (ConstantClassInfo)object;
            return this.mClassName.equals(constantClassInfo.mClassName) && this.mDim == constantClassInfo.mDim;
        }
        return false;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        dataOutput.writeShort(this.mNameConstant.getIndex());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CONSTANT_Class_info: ");
        stringBuffer.append(this.getClassName());
        int n = this.getDimensions();
        while (n > 0) {
            stringBuffer.append('[');
            stringBuffer.append(']');
            --n;
        }
        return stringBuffer.toString();
    }
}

