/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantNameAndTypeInfo;
import com.go.trove.classfile.ConstantPool;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantFieldInfo
extends ConstantInfo {
    private ConstantClassInfo mParentClass;
    private ConstantNameAndTypeInfo mNameAndType;

    static ConstantFieldInfo make(ConstantPool constantPool, ConstantClassInfo constantClassInfo, ConstantNameAndTypeInfo constantNameAndTypeInfo) {
        ConstantFieldInfo constantFieldInfo = new ConstantFieldInfo(constantClassInfo, constantNameAndTypeInfo);
        return (ConstantFieldInfo)constantPool.addConstant(constantFieldInfo);
    }

    ConstantFieldInfo(ConstantClassInfo constantClassInfo, ConstantNameAndTypeInfo constantNameAndTypeInfo) {
        super(9);
        this.mParentClass = constantClassInfo;
        this.mNameAndType = constantNameAndTypeInfo;
    }

    public ConstantClassInfo getParentClass() {
        return this.mParentClass;
    }

    public ConstantNameAndTypeInfo getNameAndType() {
        return this.mNameAndType;
    }

    public int hashCode() {
        return this.mNameAndType.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ConstantFieldInfo) {
            ConstantFieldInfo constantFieldInfo = (ConstantFieldInfo)object;
            return this.mParentClass.equals(constantFieldInfo.mParentClass) && this.mNameAndType.equals(constantFieldInfo.mNameAndType);
        }
        return false;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        dataOutput.writeShort(this.mParentClass.getIndex());
        dataOutput.writeShort(this.mNameAndType.getIndex());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CONSTANT_Fieldref_info: ");
        ConstantClassInfo constantClassInfo = this.getParentClass();
        stringBuffer.append(constantClassInfo.getClassName());
        int n = constantClassInfo.getDimensions();
        while (n > 0) {
            stringBuffer.append('[');
            stringBuffer.append(']');
            --n;
        }
        ConstantNameAndTypeInfo constantNameAndTypeInfo = this.getNameAndType();
        stringBuffer.append(' ');
        stringBuffer.append(constantNameAndTypeInfo.getName());
        stringBuffer.append(' ');
        stringBuffer.append(constantNameAndTypeInfo.getType());
        return stringBuffer.toString();
    }
}

