/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantPool;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantFloatInfo
extends ConstantInfo {
    private Float mValue;

    static ConstantFloatInfo make(ConstantPool constantPool, float f) {
        ConstantFloatInfo constantFloatInfo = new ConstantFloatInfo(f);
        return (ConstantFloatInfo)constantPool.addConstant(constantFloatInfo);
    }

    ConstantFloatInfo(float f) {
        super(4);
        this.mValue = new Float(f);
    }

    ConstantFloatInfo(Float f) {
        super(4);
        this.mValue = f;
    }

    public Float getValue() {
        return this.mValue;
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ConstantFloatInfo) {
            ConstantFloatInfo constantFloatInfo = (ConstantFloatInfo)object;
            return this.mValue.equals(constantFloatInfo.mValue);
        }
        return false;
    }

    boolean hasPriority() {
        return true;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        dataOutput.writeFloat(this.mValue.floatValue());
    }

    public String toString() {
        return "CONSTANT_Float_info: " + this.getValue();
    }
}

