/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantNameAndTypeInfo;
import com.go.trove.classfile.ConstantPool;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantInterfaceMethodInfo
extends ConstantInfo {
    private ConstantClassInfo mParentClass;
    private ConstantNameAndTypeInfo mNameAndType;

    static ConstantInterfaceMethodInfo make(ConstantPool constantPool, ConstantClassInfo constantClassInfo, ConstantNameAndTypeInfo constantNameAndTypeInfo) {
        ConstantInterfaceMethodInfo constantInterfaceMethodInfo = new ConstantInterfaceMethodInfo(constantClassInfo, constantNameAndTypeInfo);
        return (ConstantInterfaceMethodInfo)constantPool.addConstant(constantInterfaceMethodInfo);
    }

    ConstantInterfaceMethodInfo(ConstantClassInfo constantClassInfo, ConstantNameAndTypeInfo constantNameAndTypeInfo) {
        super(11);
        this.mParentClass = constantClassInfo;
        this.mNameAndType = constantNameAndTypeInfo;
    }

    public ConstantClassInfo getParentClass() {
        return this.mParentClass;
    }

    public ConstantNameAndTypeInfo getNameAndType() {
        return this.mNameAndType;
    }

    public int hashCode() {
        return this.mNameAndType.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ConstantInterfaceMethodInfo) {
            ConstantInterfaceMethodInfo constantInterfaceMethodInfo = (ConstantInterfaceMethodInfo)object;
            return this.mParentClass.equals(constantInterfaceMethodInfo.mParentClass) && this.mNameAndType.equals(constantInterfaceMethodInfo.mNameAndType);
        }
        return false;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        dataOutput.writeShort(this.mParentClass.getIndex());
        dataOutput.writeShort(this.mNameAndType.getIndex());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CONSTANT_InterfaceMethodref_info: ");
        ConstantClassInfo constantClassInfo = this.getParentClass();
        stringBuffer.append(constantClassInfo.getClassName());
        int n = constantClassInfo.getDimensions();
        while (n > 0) {
            stringBuffer.append('[');
            stringBuffer.append(']');
            --n;
        }
        ConstantNameAndTypeInfo constantNameAndTypeInfo = this.getNameAndType();
        stringBuffer.append(' ');
        stringBuffer.append(constantNameAndTypeInfo.getName());
        stringBuffer.append(' ');
        stringBuffer.append(constantNameAndTypeInfo.getType());
        return stringBuffer.toString();
    }
}

