/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantUTFInfo;
import com.go.trove.classfile.Descriptor;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantNameAndTypeInfo
extends ConstantInfo {
    private String mName;
    private Descriptor mType;
    private ConstantUTFInfo mNameConstant;
    private ConstantUTFInfo mDescriptorConstant;

    static ConstantNameAndTypeInfo make(ConstantPool constantPool, String string, Descriptor descriptor) {
        ConstantNameAndTypeInfo constantNameAndTypeInfo = new ConstantNameAndTypeInfo(constantPool, string, descriptor);
        return (ConstantNameAndTypeInfo)constantPool.addConstant(constantNameAndTypeInfo);
    }

    ConstantNameAndTypeInfo(ConstantUTFInfo constantUTFInfo, ConstantUTFInfo constantUTFInfo2) {
        super(12);
        this.mNameConstant = constantUTFInfo;
        this.mDescriptorConstant = constantUTFInfo2;
        this.mName = constantUTFInfo.getValue();
        this.mType = Descriptor.parse(constantUTFInfo2.getValue());
    }

    private ConstantNameAndTypeInfo(ConstantPool constantPool, String string, Descriptor descriptor) {
        super(12);
        this.mName = string;
        this.mType = descriptor;
        this.mNameConstant = ConstantUTFInfo.make(constantPool, string);
        this.mDescriptorConstant = ConstantUTFInfo.make(constantPool, this.mType.toString());
    }

    public String getName() {
        return this.mName;
    }

    public Descriptor getType() {
        return this.mType;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ConstantNameAndTypeInfo) {
            ConstantNameAndTypeInfo constantNameAndTypeInfo = (ConstantNameAndTypeInfo)object;
            return this.mName.equals(constantNameAndTypeInfo.mName) && this.mType.toString().equals(constantNameAndTypeInfo.mType.toString());
        }
        return false;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        dataOutput.writeShort(this.mNameConstant.getIndex());
        dataOutput.writeShort(this.mDescriptorConstant.getIndex());
    }

    public String toString() {
        return "CONSTANT_NameAndType_info: " + this.getName() + ", " + this.getType();
    }
}

