/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantDoubleInfo;
import com.go.trove.classfile.ConstantFieldInfo;
import com.go.trove.classfile.ConstantFloatInfo;
import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantIntegerInfo;
import com.go.trove.classfile.ConstantInterfaceMethodInfo;
import com.go.trove.classfile.ConstantLongInfo;
import com.go.trove.classfile.ConstantMethodInfo;
import com.go.trove.classfile.ConstantNameAndTypeInfo;
import com.go.trove.classfile.ConstantStringInfo;
import com.go.trove.classfile.ConstantUTFInfo;
import com.go.trove.classfile.Descriptor;
import com.go.trove.classfile.MethodDescriptor;
import com.go.trove.classfile.TypeDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ConstantPool {
    private Map mConstants = new HashMap();
    private Vector mIndexedConstants;
    private int mEntries;
    private boolean mPreserveOrder;

    ConstantPool() {
    }

    private ConstantPool(Vector vector) {
        this.mIndexedConstants = vector;
        int n = vector.size();
        int n2 = 1;
        while (n2 < n) {
            ConstantInfo constantInfo = (ConstantInfo)vector.get(n2);
            if (constantInfo != null) {
                this.mConstants.put(constantInfo, constantInfo);
                this.mEntries += constantInfo.getEntryCount();
            }
            ++n2;
        }
        this.mPreserveOrder = true;
    }

    public ConstantInfo getConstant(int n) {
        if (this.mIndexedConstants == null) {
            throw new ArrayIndexOutOfBoundsException("Constant pool indexes have not been assigned");
        }
        return (ConstantInfo)this.mIndexedConstants.get(n);
    }

    public Set getAllConstants() {
        return Collections.unmodifiableSet(this.mConstants.keySet());
    }

    public int getSize() {
        return this.mEntries;
    }

    public ConstantClassInfo addConstantClass(String string) {
        return ConstantClassInfo.make(this, string);
    }

    public ConstantClassInfo addConstantClass(String string, int n) {
        return ConstantClassInfo.make(this, string, n);
    }

    public ConstantClassInfo addConstantClass(TypeDescriptor typeDescriptor) {
        return ConstantClassInfo.make(this, typeDescriptor);
    }

    public ConstantFieldInfo addConstantField(String string, String string2, TypeDescriptor typeDescriptor) {
        return ConstantFieldInfo.make(this, ConstantClassInfo.make(this, string), ConstantNameAndTypeInfo.make(this, string2, typeDescriptor));
    }

    public ConstantMethodInfo addConstantMethod(String string, String string2, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(typeDescriptor, typeDescriptorArray);
        return ConstantMethodInfo.make(this, ConstantClassInfo.make(this, string), ConstantNameAndTypeInfo.make(this, string2, methodDescriptor));
    }

    public ConstantInterfaceMethodInfo addConstantInterfaceMethod(String string, String string2, TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(typeDescriptor, typeDescriptorArray);
        return ConstantInterfaceMethodInfo.make(this, ConstantClassInfo.make(this, string), ConstantNameAndTypeInfo.make(this, string2, methodDescriptor));
    }

    public ConstantMethodInfo addConstantConstructor(String string, TypeDescriptor[] typeDescriptorArray) {
        return this.addConstantMethod(string, "<init>", null, typeDescriptorArray);
    }

    public ConstantIntegerInfo addConstantInteger(int n) {
        return ConstantIntegerInfo.make(this, n);
    }

    public ConstantLongInfo addConstantLong(long l) {
        return ConstantLongInfo.make(this, l);
    }

    public ConstantFloatInfo addConstantFloat(float f) {
        return ConstantFloatInfo.make(this, f);
    }

    public ConstantDoubleInfo addConstantDouble(double d) {
        return ConstantDoubleInfo.make(this, d);
    }

    public ConstantStringInfo addConstantString(String string) {
        return ConstantStringInfo.make(this, string);
    }

    public ConstantUTFInfo addConstantUTF(String string) {
        return ConstantUTFInfo.make(this, string);
    }

    public ConstantNameAndTypeInfo addConstantNameAndType(String string, Descriptor descriptor) {
        return ConstantNameAndTypeInfo.make(this, string, descriptor);
    }

    public ConstantInfo addConstant(ConstantInfo constantInfo) {
        ConstantInfo constantInfo2 = (ConstantInfo)this.mConstants.get(constantInfo);
        if (constantInfo2 != null) {
            return constantInfo2;
        }
        int n = constantInfo.getEntryCount();
        if (this.mIndexedConstants != null && this.mPreserveOrder) {
            int n2 = this.mIndexedConstants.size();
            this.mIndexedConstants.setSize(n2 + n);
            this.mIndexedConstants.set(n2, constantInfo);
        }
        this.mConstants.put(constantInfo, constantInfo);
        this.mEntries += n;
        return constantInfo;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        Object object;
        int n;
        int n2 = this.getSize() + 1;
        if (n2 >= 65535) {
            throw new RuntimeException("Constant pool entry count cannot exceed 65535: " + n2);
        }
        dataOutput.writeShort(n2);
        if (this.mIndexedConstants == null || !this.mPreserveOrder) {
            ConstantInfo constantInfo;
            this.mIndexedConstants = new Vector(n2);
            this.mIndexedConstants.setSize(n2);
            n = 1;
            object = this.mConstants.keySet().iterator();
            while (object.hasNext()) {
                constantInfo = (ConstantInfo)object.next();
                if (!constantInfo.hasPriority()) continue;
                constantInfo.mIndex = n;
                this.mIndexedConstants.set(n, constantInfo);
                n += constantInfo.getEntryCount();
            }
            object = this.mConstants.keySet().iterator();
            while (object.hasNext()) {
                constantInfo = (ConstantInfo)object.next();
                if (constantInfo.hasPriority()) continue;
                constantInfo.mIndex = n;
                this.mIndexedConstants.set(n, constantInfo);
                n += constantInfo.getEntryCount();
            }
        }
        n = 1;
        while (n < n2) {
            object = this.mIndexedConstants.get(n);
            if (object != null) {
                ((ConstantInfo)object).writeTo(dataOutput);
            }
            ++n;
        }
    }

    public static ConstantPool readFrom(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        Vector<Object> vector = new Vector<Object>(n);
        vector.setSize(n);
        int n2 = 1;
        while (n2 < n) {
            Object object;
            byte by = dataInput.readByte();
            int n3 = 1;
            switch (by) {
                case 1: {
                    object = new ConstantUTFInfo(dataInput.readUTF());
                    break;
                }
                case 3: {
                    object = new ConstantIntegerInfo(dataInput.readInt());
                    break;
                }
                case 4: {
                    object = new ConstantFloatInfo(dataInput.readFloat());
                    break;
                }
                case 5: {
                    object = new ConstantLongInfo(dataInput.readLong());
                    ++n3;
                    break;
                }
                case 6: {
                    object = new ConstantDoubleInfo(dataInput.readDouble());
                    ++n3;
                    break;
                }
                case 7: 
                case 8: {
                    object = new TempEntry(by, dataInput.readUnsignedShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    object = new TempEntry(by, dataInput.readShort() << 16 | dataInput.readUnsignedShort());
                    break;
                }
                default: {
                    throw new IOException("Invalid constant pool tag: " + by);
                }
            }
            if (object instanceof ConstantInfo) {
                ((ConstantInfo)object).mIndex = n2;
            }
            vector.set(n2, object);
            n2 += n3;
        }
        n2 = 1;
        while (n2 < n) {
            ConstantPool.resolve(vector, n2);
            ++n2;
        }
        return new ConstantPool(vector);
    }

    private static ConstantInfo resolve(List list, int n) {
        Object e = list.get(n);
        if (e == null) {
            return null;
        }
        if (e instanceof ConstantInfo) {
            return (ConstantInfo)e;
        }
        TempEntry tempEntry = (TempEntry)e;
        int n2 = tempEntry.mData;
        int n3 = n2 & 0xFFFF;
        Object e2 = list.get(n3);
        ConstantInfo constantInfo = e2 instanceof ConstantInfo ? (ConstantInfo)e2 : ConstantPool.resolve(list, n3);
        ConstantInfo constantInfo2 = null;
        block0 : switch (tempEntry.mTag) {
            case 7: {
                constantInfo2 = new ConstantClassInfo((ConstantUTFInfo)constantInfo);
                break;
            }
            case 8: {
                constantInfo2 = new ConstantStringInfo((ConstantUTFInfo)constantInfo);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                int n4 = n2 >> 16;
                Object e3 = list.get(n4);
                ConstantInfo constantInfo3 = e3 instanceof ConstantInfo ? (ConstantInfo)e3 : ConstantPool.resolve(list, n4);
                switch (tempEntry.mTag) {
                    case 9: {
                        constantInfo2 = new ConstantFieldInfo((ConstantClassInfo)constantInfo3, (ConstantNameAndTypeInfo)constantInfo);
                        break block0;
                    }
                    case 10: {
                        constantInfo2 = new ConstantMethodInfo((ConstantClassInfo)constantInfo3, (ConstantNameAndTypeInfo)constantInfo);
                        break block0;
                    }
                    case 11: {
                        constantInfo2 = new ConstantInterfaceMethodInfo((ConstantClassInfo)constantInfo3, (ConstantNameAndTypeInfo)constantInfo);
                        break block0;
                    }
                    case 12: {
                        constantInfo2 = new ConstantNameAndTypeInfo((ConstantUTFInfo)constantInfo3, (ConstantUTFInfo)constantInfo);
                    }
                }
            }
        }
        constantInfo2.mIndex = n;
        list.set(n, constantInfo2);
        return constantInfo2;
    }

    private static class TempEntry {
        public int mTag;
        public int mData;

        public TempEntry(int n, int n2) {
            this.mTag = n;
            this.mData = n2;
        }
    }
}

