/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantUTFInfo;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantStringInfo
extends ConstantInfo {
    private String mStr;
    private ConstantUTFInfo mStringConstant;

    static ConstantStringInfo make(ConstantPool constantPool, String string) {
        ConstantStringInfo constantStringInfo = new ConstantStringInfo(constantPool, string);
        return (ConstantStringInfo)constantPool.addConstant(constantStringInfo);
    }

    ConstantStringInfo(ConstantUTFInfo constantUTFInfo) {
        super(8);
        this.mStr = constantUTFInfo.getValue();
        this.mStringConstant = constantUTFInfo;
    }

    private ConstantStringInfo(ConstantPool constantPool, String string) {
        super(8);
        this.mStr = string;
        this.mStringConstant = ConstantUTFInfo.make(constantPool, string);
    }

    public String getValue() {
        return this.mStr;
    }

    public int hashCode() {
        return this.mStr.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ConstantStringInfo) {
            ConstantStringInfo constantStringInfo = (ConstantStringInfo)object;
            return this.mStr.equals(constantStringInfo.mStr);
        }
        return false;
    }

    boolean hasPriority() {
        return true;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        dataOutput.writeShort(this.mStringConstant.getIndex());
    }

    public String toString() {
        return "CONSTANT_String_info: " + this.getValue();
    }
}

