/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.FixedLocation;
import com.go.trove.classfile.Location;
import com.go.trove.classfile.LocationRange;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExceptionHandler
implements LocationRange {
    private Location mStart;
    private Location mEnd;
    private Location mCatch;
    private ConstantClassInfo mCatchType;

    public ExceptionHandler(Location location, Location location2, Location location3, ConstantClassInfo constantClassInfo) {
        this.mStart = location;
        this.mEnd = location2;
        this.mCatch = location3;
        this.mCatchType = constantClassInfo;
    }

    public Location getStartLocation() {
        return this.mStart;
    }

    public Location getEndLocation() {
        return this.mEnd;
    }

    public Location getCatchLocation() {
        return this.mCatch;
    }

    public ConstantClassInfo getCatchType() {
        return this.mCatchType;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        LocationRange locationRange = (LocationRange)object;
        int n = this.getStartLocation().compareTo(locationRange.getStartLocation());
        if (n == 0) {
            n = this.getEndLocation().compareTo(locationRange.getEndLocation());
        }
        if (n == 0 && object instanceof ExceptionHandler) {
            n = this.getCatchLocation().compareTo(((ExceptionHandler)locationRange).getCatchLocation());
        }
        return n;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        int n = this.getStartLocation().getLocation();
        int n2 = this.getEndLocation().getLocation();
        int n3 = this.getCatchLocation().getLocation();
        ConstantClassInfo constantClassInfo = this.getCatchType();
        int n4 = constantClassInfo == null ? 0 : constantClassInfo.getIndex();
        this.check("exception start PC", n);
        this.check("exception end PC", n2);
        this.check("exception handler PC", n3);
        dataOutput.writeShort(n);
        dataOutput.writeShort(n2);
        dataOutput.writeShort(n3);
        dataOutput.writeShort(n4);
    }

    private void check(String string, int n) throws RuntimeException {
        if (n < 0 || n > 65535) {
            throw new RuntimeException("Value for " + string + " out of " + "valid range: " + n);
        }
    }

    static ExceptionHandler readFrom(ConstantPool constantPool, DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        int n3 = dataInput.readUnsignedShort();
        int n4 = dataInput.readUnsignedShort();
        ConstantClassInfo constantClassInfo = n4 == 0 ? null : (ConstantClassInfo)constantPool.getConstant(n4);
        return new ExceptionHandler(new FixedLocation(n), new FixedLocation(n2), new FixedLocation(n3), constantClassInfo);
    }
}

