/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ExceptionsAttr
extends Attribute {
    private List mExceptions = new ArrayList(2);

    public ExceptionsAttr(ConstantPool constantPool) {
        super(constantPool, "Exceptions");
    }

    public String[] getExceptions() {
        int n = this.mExceptions.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((ConstantClassInfo)this.mExceptions.get(n2)).getClassName();
            ++n2;
        }
        return stringArray;
    }

    public void addException(ConstantClassInfo constantClassInfo) {
        this.mExceptions.add(constantClassInfo);
    }

    public int getLength() {
        return 2 + 2 * this.mExceptions.size();
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        int n = this.mExceptions.size();
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            ConstantClassInfo constantClassInfo = (ConstantClassInfo)this.mExceptions.get(n2);
            dataOutput.writeShort(constantClassInfo.getIndex());
            ++n2;
        }
    }

    static Attribute define(ConstantPool constantPool, DataInput dataInput, String string, int n) throws IOException {
        ExceptionsAttr exceptionsAttr = new ExceptionsAttr(constantPool);
        int n2 = dataInput.readUnsignedShort();
        n -= 2;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInput.readUnsignedShort();
            n -= 2;
            ConstantClassInfo constantClassInfo = (ConstantClassInfo)constantPool.getConstant(n4);
            exceptionsAttr.addException(constantClassInfo);
            ++n3;
        }
        if (n > 0) {
            dataInput.skipBytes(n);
        }
        return exceptionsAttr;
    }
}

