/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.AccessFlags;
import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.ClassFile;
import com.go.trove.classfile.ConstantDoubleInfo;
import com.go.trove.classfile.ConstantFloatInfo;
import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ConstantIntegerInfo;
import com.go.trove.classfile.ConstantLongInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantStringInfo;
import com.go.trove.classfile.ConstantUTFInfo;
import com.go.trove.classfile.ConstantValueAttr;
import com.go.trove.classfile.DeprecatedAttr;
import com.go.trove.classfile.SyntheticAttr;
import com.go.trove.classfile.TypeDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class FieldInfo {
    private ClassFile mParent;
    private ConstantPool mCp;
    private String mName;
    private TypeDescriptor mType;
    private int mAccessFlags;
    private ConstantUTFInfo mNameConstant;
    private ConstantUTFInfo mDescriptorConstant;
    private List mAttributes = new ArrayList(2);
    private ConstantValueAttr mConstant;

    FieldInfo(ClassFile classFile, AccessFlags accessFlags, String string, TypeDescriptor typeDescriptor) {
        this.mParent = classFile;
        this.mCp = classFile.getConstantPool();
        this.mName = string;
        this.mType = typeDescriptor;
        this.mAccessFlags = accessFlags.getModifier();
        this.mNameConstant = ConstantUTFInfo.make(this.mCp, string);
        this.mDescriptorConstant = ConstantUTFInfo.make(this.mCp, typeDescriptor.toString());
    }

    private FieldInfo(ClassFile classFile, int n, ConstantUTFInfo constantUTFInfo, ConstantUTFInfo constantUTFInfo2) {
        this.mParent = classFile;
        this.mCp = classFile.getConstantPool();
        this.mName = constantUTFInfo.getValue();
        this.mType = TypeDescriptor.parseTypeDesc(constantUTFInfo2.getValue());
        this.mAccessFlags = n;
        this.mNameConstant = constantUTFInfo;
        this.mDescriptorConstant = constantUTFInfo2;
    }

    public ClassFile getClassFile() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public TypeDescriptor getType() {
        return this.mType;
    }

    public AccessFlags getAccessFlags() {
        return new AccessFlags(this.mAccessFlags);
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public ConstantUTFInfo getDescriptorConstant() {
        return this.mDescriptorConstant;
    }

    public ConstantInfo getConstantValue() {
        if (this.mConstant == null) {
            return null;
        }
        return this.mConstant.getConstant();
    }

    public boolean isSynthetic() {
        int n = this.mAttributes.size();
        while (--n >= 0) {
            Object e = this.mAttributes.get(n);
            if (!(e instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int n = this.mAttributes.size();
        while (--n >= 0) {
            Object e = this.mAttributes.get(n);
            if (!(e instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public void setConstantValue(int n) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantIntegerInfo.make(this.mCp, n)));
    }

    public void setConstantValue(float f) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantFloatInfo.make(this.mCp, f)));
    }

    public void setConstantValue(long l) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantLongInfo.make(this.mCp, l)));
    }

    public void setConstantValue(double d) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantDoubleInfo.make(this.mCp, d)));
    }

    public void setConstantValue(String string) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantStringInfo.make(this.mCp, string)));
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attribute) {
        if (attribute instanceof ConstantValueAttr) {
            if (this.mConstant != null) {
                this.mAttributes.remove(this.mConstant);
            }
            this.mConstant = (ConstantValueAttr)attribute;
        }
        this.mAttributes.add(attribute);
    }

    public int getLength() {
        int n = 8;
        int n2 = this.mAttributes.size();
        int n3 = 0;
        while (n3 < n2) {
            n += ((Attribute)this.mAttributes.get(n3)).getLength();
            ++n3;
        }
        return n;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.mAccessFlags);
        dataOutput.writeShort(this.mNameConstant.getIndex());
        dataOutput.writeShort(this.mDescriptorConstant.getIndex());
        int n = this.mAttributes.size();
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = (Attribute)this.mAttributes.get(n2);
            attribute.writeTo(dataOutput);
            ++n2;
        }
    }

    public String toString() {
        String string = Modifier.toString(this.mAccessFlags);
        if (string.length() == 0) {
            return String.valueOf(this.mType) + ' ' + this.getName();
        }
        return string + ' ' + this.mType + ' ' + this.getName();
    }

    static FieldInfo readFrom(ClassFile classFile, DataInput dataInput) throws IOException {
        ConstantPool constantPool = classFile.getConstantPool();
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        ConstantUTFInfo constantUTFInfo = (ConstantUTFInfo)constantPool.getConstant(n2);
        n2 = dataInput.readUnsignedShort();
        ConstantUTFInfo constantUTFInfo2 = (ConstantUTFInfo)constantPool.getConstant(n2);
        FieldInfo fieldInfo = new FieldInfo(classFile, n, constantUTFInfo, constantUTFInfo2);
        int n3 = dataInput.readUnsignedShort();
        int n4 = 0;
        while (n4 < n3) {
            fieldInfo.addAttribute(Attribute.readFrom(constantPool, dataInput));
            ++n4;
        }
        return fieldInfo;
    }
}

