/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.AccessFlags;
import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantUTFInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class InnerClassesAttr
extends Attribute {
    private List mInnerClasses = new ArrayList();

    public InnerClassesAttr(ConstantPool constantPool) {
        super(constantPool, "InnerClasses");
    }

    public void addInnerClass(String string, String string2, String string3, AccessFlags accessFlags) {
        ConstantClassInfo constantClassInfo = ConstantClassInfo.make(this.mCp, string);
        ConstantClassInfo constantClassInfo2 = string2 == null ? null : ConstantClassInfo.make(this.mCp, string2);
        ConstantUTFInfo constantUTFInfo = string3 == null ? null : ConstantUTFInfo.make(this.mCp, string3);
        this.mInnerClasses.add(new Info(constantClassInfo, constantClassInfo2, constantUTFInfo, accessFlags));
    }

    public int getLength() {
        return 2 + 8 * this.mInnerClasses.size();
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        int n = this.mInnerClasses.size();
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            ((Info)this.mInnerClasses.get(n2)).writeTo(dataOutput);
            ++n2;
        }
    }

    static Attribute define(ConstantPool constantPool, DataInput dataInput, String string, int n) throws IOException {
        InnerClassesAttr innerClassesAttr = new InnerClassesAttr(constantPool);
        int n2 = dataInput.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInput.readUnsignedShort();
            int n5 = dataInput.readUnsignedShort();
            int n6 = dataInput.readUnsignedShort();
            AccessFlags accessFlags = new AccessFlags(dataInput.readUnsignedShort());
            ConstantClassInfo constantClassInfo = n4 == 0 ? null : (ConstantClassInfo)constantPool.getConstant(n4);
            ConstantClassInfo constantClassInfo2 = n5 == 0 ? null : (ConstantClassInfo)constantPool.getConstant(n5);
            ConstantUTFInfo constantUTFInfo = n6 == 0 ? null : (ConstantUTFInfo)constantPool.getConstant(n6);
            Info info = new Info(constantClassInfo, constantClassInfo2, constantUTFInfo, accessFlags);
            innerClassesAttr.mInnerClasses.add(info);
            ++n3;
        }
        return innerClassesAttr;
    }

    private static class Info {
        private ConstantClassInfo mInner;
        private ConstantClassInfo mOuter;
        private ConstantUTFInfo mName;
        private AccessFlags mAccessFlags;

        public Info(ConstantClassInfo constantClassInfo, ConstantClassInfo constantClassInfo2, ConstantUTFInfo constantUTFInfo, AccessFlags accessFlags) {
            this.mInner = constantClassInfo;
            this.mOuter = constantClassInfo2;
            this.mName = constantUTFInfo;
            this.mAccessFlags = accessFlags;
        }

        public void writeTo(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.mInner.getIndex());
            if (this.mOuter == null) {
                dataOutput.writeShort(0);
            } else {
                dataOutput.writeShort(this.mOuter.getIndex());
            }
            if (this.mName == null) {
                dataOutput.writeShort(0);
            } else {
                dataOutput.writeShort(this.mName.getIndex());
            }
            dataOutput.writeShort(this.mAccessFlags.getModifier());
        }
    }
}

