/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.CodeBuffer;
import com.go.trove.classfile.ConstantInfo;
import com.go.trove.classfile.ExceptionHandler;
import com.go.trove.classfile.Label;
import com.go.trove.classfile.LocalVariable;
import com.go.trove.classfile.Location;
import com.go.trove.classfile.Opcode;
import com.go.trove.classfile.TypeDescriptor;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;

class InstructionList
implements CodeBuffer {
    private static final boolean DEBUG = false;
    Instruction mFirst;
    Instruction mLast;
    boolean mResolved = false;
    private List mExceptionHandlers = new ArrayList(4);
    private List mLocalVariables = new ArrayList();
    private int mMaxStack;
    private int mMaxLocals;
    private byte[] mByteCodes;
    private int mBufferLength;

    protected InstructionList() {
    }

    public Collection getInstructions() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return new Iterator(this){
                    private Instruction mNext;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.mNext = 1.access$000(this.this$1).mFirst;
                    }

                    public boolean hasNext() {
                        return this.mNext != null;
                    }

                    public Object next() {
                        if (this.mNext == null) {
                            throw new NoSuchElementException();
                        }
                        Instruction instruction = this.mNext;
                        this.mNext = this.mNext.mNext;
                        return instruction;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int size() {
                int n = 0;
                Instruction instruction = InstructionList.this.mFirst;
                while (instruction != null) {
                    ++n;
                    instruction = instruction.mNext;
                }
                return n;
            }

            static /* synthetic */ InstructionList access$000(1 var0) {
                return var0.InstructionList.this;
            }
        };
    }

    public int getMaxStackDepth() {
        this.resolve();
        return this.mMaxStack;
    }

    public int getMaxLocals() {
        this.resolve();
        return this.mMaxLocals;
    }

    public byte[] getByteCodes() {
        this.resolve();
        return this.mByteCodes;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        this.resolve();
        ExceptionHandler[] exceptionHandlerArray = new ExceptionHandler[this.mExceptionHandlers.size()];
        return this.mExceptionHandlers.toArray(exceptionHandlerArray);
    }

    public void addExceptionHandler(ExceptionHandler exceptionHandler) {
        this.mExceptionHandlers.add(exceptionHandler);
    }

    public LocalVariable createLocalVariable(String string, TypeDescriptor typeDescriptor) {
        LocalVariableImpl localVariableImpl = new LocalVariableImpl(string, typeDescriptor, -1);
        this.mLocalVariables.add(localVariableImpl);
        return localVariableImpl;
    }

    public LocalVariable createLocalParameter(String string, TypeDescriptor typeDescriptor, int n) {
        LocalVariableImpl localVariableImpl = new LocalVariableImpl(string, typeDescriptor, n);
        this.mLocalVariables.add(localVariableImpl);
        if (this.mFirst == null) {
            LabelInstruction labelInstruction = new LabelInstruction();
            labelInstruction.setLocation();
            this.mFirst = labelInstruction;
        }
        localVariableImpl.addStoreInstruction(this.mFirst);
        return localVariableImpl;
    }

    private void resolve() {
        if (this.mResolved) {
            return;
        }
        this.resolve0();
    }

    private void resolve0() {
        boolean bl;
        Object object;
        Object object2;
        this.mMaxStack = 0;
        this.mMaxLocals = 0;
        int n = 0;
        Instruction instruction = this.mFirst;
        while (instruction != null) {
            instruction.mStackDepth = -1;
            instruction.mLocation = n++;
            instruction = instruction.mNext;
        }
        int n2 = this.mLocalVariables.size();
        ArrayList arrayList = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            object2 = (LocalVariableImpl)this.mLocalVariables.get(n3);
            if (((LocalVariableImpl)object2).getNumber() < 0) {
                ((LocalVariableImpl)object2).setNumber(this.mMaxLocals);
            }
            if ((n4 = ((LocalVariableImpl)object2).getNumber() + (((LocalVariableImpl)object2).isDoubleWord() ? 2 : 1)) > this.mMaxLocals) {
                this.mMaxLocals = n4;
            }
            ++n3;
        }
        object2 = new HashMap(11);
        this.stackResolve(0, this.mFirst, (Map)object2);
        Iterator iterator = this.mExceptionHandlers.iterator();
        while (iterator.hasNext()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)iterator.next();
            object = (Instruction)exceptionHandler.getCatchLocation();
            this.stackResolve(1, (Instruction)object, (Map)object2);
        }
        do {
            bl = false;
            this.mByteCodes = new byte[16];
            this.mBufferLength = 0;
            instruction = this.mFirst;
            while (instruction != null) {
                if (!instruction.isResolved()) {
                    bl = true;
                }
                if (instruction instanceof Label) {
                    if (instruction.mLocation != this.mBufferLength) {
                        if (instruction.mLocation >= 0) {
                            bl = true;
                        }
                        instruction.mLocation = this.mBufferLength;
                    }
                } else {
                    instruction.mLocation = this.mBufferLength;
                    object = instruction.getBytes();
                    if (object != null) {
                        if (bl) {
                            this.mBufferLength += ((Object)object).length;
                        } else {
                            this.addBytes((byte[])object);
                        }
                    }
                }
                instruction = instruction.mNext;
            }
        } while (bl);
        if (this.mBufferLength != this.mByteCodes.length) {
            object = new byte[this.mBufferLength];
            System.arraycopy(this.mByteCodes, 0, object, 0, this.mBufferLength);
            this.mByteCodes = (byte[])object;
        }
        this.mResolved = true;
    }

    private void addBytes(byte[] byArray) {
        this.growBuffer(byArray.length);
        System.arraycopy(byArray, 0, this.mByteCodes, this.mBufferLength, byArray.length);
        this.mBufferLength += byArray.length;
    }

    private void growBuffer(int n) {
        if (this.mBufferLength + n > this.mByteCodes.length) {
            int n2 = this.mByteCodes.length * 2;
            if (this.mBufferLength + n > n2) {
                n2 = this.mBufferLength + n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.mByteCodes, 0, byArray, 0, this.mBufferLength);
            this.mByteCodes = byArray;
        }
    }

    private int stackResolve(int n, Instruction instruction, Map map) {
        while (instruction != null) {
            if (instruction.mStackDepth >= 0) {
                if (instruction.mStackDepth == n) break;
                throw new RuntimeException("Stack depth different at previously visited instruction: " + instruction.mStackDepth + " != " + n);
            }
            instruction.mStackDepth = n;
            Instruction instruction2 = null;
            if (instruction.isFlowThrough() && (instruction2 = instruction.mNext) == null) {
                throw new RuntimeException("Execution flows through end of method");
            }
            if ((n += instruction.getStackAdjustment()) > this.mMaxStack) {
                this.mMaxStack = n;
            } else if (n < 0) {
                throw new RuntimeException("Stack depth is negative: " + n);
            }
            Location[] locationArray = instruction.getBranchTargets();
            if (locationArray != null) {
                int n2 = 0;
                while (n2 < locationArray.length) {
                    LabelInstruction labelInstruction = (LabelInstruction)locationArray[n2];
                    if (n2 == 0 && instruction2 == null) {
                        instruction2 = labelInstruction;
                    } else if (!instruction.isSubroutineCall()) {
                        this.stackResolve(n, labelInstruction, map);
                    } else {
                        Integer n3 = (Integer)map.get(labelInstruction);
                        if (n3 == null) {
                            int n4 = this.stackResolve(n, labelInstruction, map);
                            n3 = new Integer(n4 - n);
                            map.put(labelInstruction, n3);
                        }
                        n += n3.intValue();
                    }
                    ++n2;
                }
            }
            instruction = instruction2;
        }
        return n;
    }

    public class SwitchInstruction
    extends CodeInstruction {
        private int[] mCases;
        private Location[] mLocations;
        private Location mDefaultLocation;
        private byte mOpcode;
        private int mSmallest;
        private int mLargest;

        public SwitchInstruction(int[] nArray, Location[] locationArray, Location location) {
            super(-1);
            if (nArray.length != locationArray.length) {
                throw new IllegalArgumentException("Switch cases and locations sizes differ: " + nArray.length + ", " + locationArray.length);
            }
            this.mCases = new int[nArray.length];
            System.arraycopy(nArray, 0, this.mCases, 0, nArray.length);
            this.mLocations = new Location[locationArray.length];
            System.arraycopy(locationArray, 0, this.mLocations, 0, locationArray.length);
            this.mDefaultLocation = location;
            this.sort(0, this.mCases.length - 1);
            int n = 0;
            int n2 = 0;
            while (n2 < this.mCases.length) {
                if (n2 > 0 && this.mCases[n2] == n) {
                    throw new RuntimeException("Duplicate switch cases: " + n);
                }
                n = this.mCases[n2];
                ++n2;
            }
            this.mSmallest = this.mCases[0];
            this.mLargest = this.mCases[this.mCases.length - 1];
            int n3 = 12 + 4 * (this.mLargest - this.mSmallest + 1);
            int n4 = 8 + 8 * this.mCases.length;
            this.mOpcode = n3 <= n4 ? (byte)-86 : (byte)-85;
        }

        public Location[] getBranchTargets() {
            Location[] locationArray = new Location[this.mLocations.length + 1];
            System.arraycopy(this.mLocations, 0, locationArray, 0, this.mLocations.length);
            locationArray[locationArray.length - 1] = this.mDefaultLocation;
            return locationArray;
        }

        public boolean isFlowThrough() {
            return false;
        }

        public byte[] getBytes() {
            int n = 1;
            int n2 = 3 - (this.mLocation & 3);
            n += n2;
            n = this.mOpcode == -86 ? (n += 12 + 4 * (this.mLargest - this.mSmallest + 1)) : (n += 8 + 8 * this.mCases.length);
            this.mBytes = new byte[n];
            if (!this.isResolved()) {
                return this.mBytes;
            }
            this.mBytes[0] = this.mOpcode;
            int n3 = n2 + 1;
            int n4 = this.mDefaultLocation.getLocation() - this.mLocation;
            this.mBytes[n3++] = (byte)(n4 >> 24);
            this.mBytes[n3++] = (byte)(n4 >> 16);
            this.mBytes[n3++] = (byte)(n4 >> 8);
            this.mBytes[n3++] = (byte)(n4 >> 0);
            if (this.mOpcode == -86) {
                this.mBytes[n3++] = (byte)(this.mSmallest >> 24);
                this.mBytes[n3++] = (byte)(this.mSmallest >> 16);
                this.mBytes[n3++] = (byte)(this.mSmallest >> 8);
                this.mBytes[n3++] = (byte)(this.mSmallest >> 0);
                this.mBytes[n3++] = (byte)(this.mLargest >> 24);
                this.mBytes[n3++] = (byte)(this.mLargest >> 16);
                this.mBytes[n3++] = (byte)(this.mLargest >> 8);
                this.mBytes[n3++] = (byte)(this.mLargest >> 0);
                int n5 = 0;
                int n6 = this.mSmallest;
                while (n6 <= this.mLargest) {
                    if (n6 == this.mCases[n5]) {
                        int n7 = this.mLocations[n5].getLocation() - this.mLocation;
                        this.mBytes[n3++] = (byte)(n7 >> 24);
                        this.mBytes[n3++] = (byte)(n7 >> 16);
                        this.mBytes[n3++] = (byte)(n7 >> 8);
                        this.mBytes[n3++] = (byte)(n7 >> 0);
                        ++n5;
                    } else {
                        this.mBytes[n3++] = (byte)(n4 >> 24);
                        this.mBytes[n3++] = (byte)(n4 >> 16);
                        this.mBytes[n3++] = (byte)(n4 >> 8);
                        this.mBytes[n3++] = (byte)(n4 >> 0);
                    }
                    ++n6;
                }
            } else {
                this.mBytes[n3++] = (byte)(this.mCases.length >> 24);
                this.mBytes[n3++] = (byte)(this.mCases.length >> 16);
                this.mBytes[n3++] = (byte)(this.mCases.length >> 8);
                this.mBytes[n3++] = (byte)(this.mCases.length >> 0);
                int n8 = 0;
                while (n8 < this.mCases.length) {
                    int n9 = this.mCases[n8];
                    this.mBytes[n3++] = (byte)(n9 >> 24);
                    this.mBytes[n3++] = (byte)(n9 >> 16);
                    this.mBytes[n3++] = (byte)(n9 >> 8);
                    this.mBytes[n3++] = (byte)(n9 >> 0);
                    int n10 = this.mLocations[n8].getLocation() - this.mLocation;
                    this.mBytes[n3++] = (byte)(n10 >> 24);
                    this.mBytes[n3++] = (byte)(n10 >> 16);
                    this.mBytes[n3++] = (byte)(n10 >> 8);
                    this.mBytes[n3++] = (byte)(n10 >> 0);
                    ++n8;
                }
            }
            return this.mBytes;
        }

        public boolean isResolved() {
            if (this.mDefaultLocation.getLocation() >= 0) {
                int n = 0;
                while (n < this.mLocations.length) {
                    if (this.mLocations[n].getLocation() < 0) break;
                    ++n;
                }
                return true;
            }
            return false;
        }

        private void sort(int n, int n2) {
            if (n >= n2) {
                return;
            }
            this.swap(n, (n + n2) / 2);
            int n3 = n;
            int n4 = n + 1;
            while (n4 <= n2) {
                if (this.mCases[n4] < this.mCases[n]) {
                    this.swap(++n3, n4);
                }
                ++n4;
            }
            this.swap(n, n3);
            this.sort(n, n3 - 1);
            this.sort(n3 + 1, n2);
        }

        private void swap(int n, int n2) {
            int n3 = this.mCases[n];
            this.mCases[n] = this.mCases[n2];
            this.mCases[n2] = n3;
            Location location = this.mLocations[n];
            this.mLocations[n] = this.mLocations[n2];
            this.mLocations[n2] = location;
        }
    }

    public class ShortIncrementInstruction
    extends LocalOperandInstruction {
        private short mAmount;

        public ShortIncrementInstruction(LocalVariable localVariable, short s) {
            super(0, localVariable);
            this.mAmount = s;
        }

        public boolean isFlowThrough() {
            return true;
        }

        public byte[] getBytes() {
            int n = this.getVariableNumber();
            this.mBytes = -128 <= this.mAmount && this.mAmount <= 127 && n <= 255 ? new byte[]{-124, (byte)n, (byte)this.mAmount} : new byte[]{-60, -124, (byte)(n >> 8), (byte)n, (byte)(this.mAmount >> 8), (byte)this.mAmount};
            return this.mBytes;
        }
    }

    public class RetInstruction
    extends LocalOperandInstruction {
        public RetInstruction(LocalVariable localVariable) {
            super(0, localVariable);
        }

        public boolean isFlowThrough() {
            return false;
        }

        public byte[] getBytes() {
            int n = this.getVariableNumber();
            this.mBytes = n <= 255 ? new byte[]{-87, (byte)n} : new byte[]{-60, -87, (byte)(n >> 8), (byte)n};
            return this.mBytes;
        }
    }

    public class StoreLocalInstruction
    extends LocalOperandInstruction {
        public StoreLocalInstruction(int n, LocalVariable localVariable) {
            super(n, localVariable);
            ((LocalVariableImpl)localVariable).addStoreInstruction(this);
        }

        public boolean isFlowThrough() {
            return true;
        }

        public byte[] getBytes() {
            byte by;
            int n = this.getVariableNumber();
            boolean bl = false;
            TypeDescriptor typeDescriptor = this.mLocal.getType();
            Class clazz = typeDescriptor.getDimensions() > 0 ? null : typeDescriptor.getClassArg();
            switch (n) {
                case 0: {
                    if (clazz == null || !clazz.isPrimitive()) {
                        by = 75;
                        break;
                    }
                    if (clazz == Long.TYPE) {
                        by = 63;
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        by = 67;
                        break;
                    }
                    if (clazz == Double.TYPE) {
                        by = 71;
                        break;
                    }
                    by = 59;
                    break;
                }
                case 1: {
                    if (clazz == null || !clazz.isPrimitive()) {
                        by = 76;
                        break;
                    }
                    if (clazz == Long.TYPE) {
                        by = 64;
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        by = 68;
                        break;
                    }
                    if (clazz == Double.TYPE) {
                        by = 72;
                        break;
                    }
                    by = 60;
                    break;
                }
                case 2: {
                    if (clazz == null || !clazz.isPrimitive()) {
                        by = 77;
                        break;
                    }
                    if (clazz == Long.TYPE) {
                        by = 65;
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        by = 69;
                        break;
                    }
                    if (clazz == Double.TYPE) {
                        by = 73;
                        break;
                    }
                    by = 61;
                    break;
                }
                case 3: {
                    if (clazz == null || !clazz.isPrimitive()) {
                        by = 78;
                        break;
                    }
                    if (clazz == Long.TYPE) {
                        by = 66;
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        by = 70;
                        break;
                    }
                    if (clazz == Double.TYPE) {
                        by = 74;
                        break;
                    }
                    by = 62;
                    break;
                }
                default: {
                    bl = true;
                    by = clazz == null || !clazz.isPrimitive() ? (byte)58 : (clazz == Long.TYPE ? (byte)55 : (clazz == Float.TYPE ? (byte)56 : (clazz == Double.TYPE ? (byte)57 : 54)));
                }
            }
            this.mBytes = !bl ? new byte[]{by} : (n <= 255 ? new byte[]{by, (byte)n} : new byte[]{-60, by, (byte)(n >> 8), (byte)n});
            return this.mBytes;
        }
    }

    public class LoadLocalInstruction
    extends LocalOperandInstruction {
        public LoadLocalInstruction(int n, LocalVariable localVariable) {
            super(n, localVariable);
        }

        public boolean isFlowThrough() {
            return true;
        }

        public byte[] getBytes() {
            byte by;
            int n = this.getVariableNumber();
            boolean bl = false;
            TypeDescriptor typeDescriptor = this.mLocal.getType();
            Class clazz = typeDescriptor.getDimensions() > 0 ? null : typeDescriptor.getClassArg();
            switch (n) {
                case 0: {
                    if (clazz == null || !clazz.isPrimitive()) {
                        by = 42;
                        break;
                    }
                    if (clazz == Long.TYPE) {
                        by = 30;
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        by = 34;
                        break;
                    }
                    if (clazz == Double.TYPE) {
                        by = 38;
                        break;
                    }
                    by = 26;
                    break;
                }
                case 1: {
                    if (clazz == null || !clazz.isPrimitive()) {
                        by = 43;
                        break;
                    }
                    if (clazz == Long.TYPE) {
                        by = 31;
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        by = 35;
                        break;
                    }
                    if (clazz == Double.TYPE) {
                        by = 39;
                        break;
                    }
                    by = 27;
                    break;
                }
                case 2: {
                    if (clazz == null || !clazz.isPrimitive()) {
                        by = 44;
                        break;
                    }
                    if (clazz == Long.TYPE) {
                        by = 32;
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        by = 36;
                        break;
                    }
                    if (clazz == Double.TYPE) {
                        by = 40;
                        break;
                    }
                    by = 28;
                    break;
                }
                case 3: {
                    if (clazz == null || !clazz.isPrimitive()) {
                        by = 45;
                        break;
                    }
                    if (clazz == Long.TYPE) {
                        by = 33;
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        by = 37;
                        break;
                    }
                    if (clazz == Double.TYPE) {
                        by = 41;
                        break;
                    }
                    by = 29;
                    break;
                }
                default: {
                    bl = true;
                    by = clazz == null || !clazz.isPrimitive() ? (byte)25 : (clazz == Long.TYPE ? (byte)22 : (clazz == Float.TYPE ? (byte)23 : (clazz == Double.TYPE ? (byte)24 : 21)));
                }
            }
            this.mBytes = !bl ? new byte[]{by} : (n <= 255 ? new byte[]{by, (byte)n} : new byte[]{-60, by, (byte)(n >> 8), (byte)n});
            return this.mBytes;
        }
    }

    public class LocalOperandInstruction
    extends CodeInstruction {
        protected LocalVariable mLocal;

        public LocalOperandInstruction(int n, LocalVariable localVariable) {
            super(n);
            this.mLocal = localVariable;
        }

        public boolean isResolved() {
            return this.mLocal.getNumber() >= 0;
        }

        public LocalVariable getLocalVariable() {
            return this.mLocal;
        }

        public int getVariableNumber() {
            int n = this.mLocal.getNumber();
            if (n < 0) {
                throw new RuntimeException("Local variable number not resolved");
            }
            return n;
        }
    }

    public class LoadConstantInstruction
    extends CodeInstruction {
        private ConstantInfo mInfo;
        private boolean mWideOnly;

        public LoadConstantInstruction(int n, ConstantInfo constantInfo) {
            this(n, constantInfo, false);
        }

        public LoadConstantInstruction(int n, ConstantInfo constantInfo, boolean bl) {
            super(n);
            this.mInfo = constantInfo;
            this.mWideOnly = bl;
        }

        public boolean isFlowThrough() {
            return true;
        }

        public byte[] getBytes() {
            int n = this.mInfo.getIndex();
            if (n < 0) {
                throw new RuntimeException("Constant pool index not resolved");
            }
            if (this.mWideOnly) {
                byte[] byArray = new byte[]{20, (byte)(n >> 8), (byte)n};
                return byArray;
            }
            if (n <= 255) {
                byte[] byArray = new byte[]{18, (byte)n};
                return byArray;
            }
            byte[] byArray = new byte[]{19, (byte)(n >> 8), (byte)n};
            return byArray;
        }

        public boolean isResolved() {
            return this.mInfo.getIndex() >= 0;
        }
    }

    public class ConstantOperandInstruction
    extends CodeInstruction {
        private ConstantInfo mInfo;

        public ConstantOperandInstruction(int n, byte[] byArray, ConstantInfo constantInfo) {
            super(n, byArray);
            this.mInfo = constantInfo;
        }

        public byte[] getBytes() {
            int n = this.mInfo.getIndex();
            if (n < 0) {
                throw new RuntimeException("Constant pool index not resolved");
            }
            this.mBytes[1] = (byte)(n >> 8);
            this.mBytes[2] = (byte)n;
            return this.mBytes;
        }

        public boolean isResolved() {
            return this.mInfo.getIndex() >= 0;
        }
    }

    public class BranchInstruction
    extends CodeInstruction {
        private Location mTarget;
        private boolean mHasShortHop = false;
        private boolean mIsSub = false;

        public BranchInstruction(int n, byte by, Location location) {
            this(n, true, by, location);
        }

        private BranchInstruction(int n, boolean bl, byte by, Location location) {
            super(n, bl);
            this.mTarget = location;
            switch (by) {
                case -56: 
                case -55: {
                    this.mIsSub = true;
                    this.mBytes = new byte[5];
                    this.mBytes[0] = by;
                    break;
                }
                case -88: {
                    this.mIsSub = true;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -58: 
                case -57: {
                    this.mBytes = new byte[3];
                    this.mBytes[0] = by;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Opcode not a branch instruction: " + Opcode.getMnemonic(by));
                }
            }
        }

        public Location[] getBranchTargets() {
            return new Location[]{this.mTarget};
        }

        public boolean isSubroutineCall() {
            return this.mIsSub;
        }

        public byte[] getBytes() {
            if (!this.isResolved() || this.mHasShortHop) {
                return this.mBytes;
            }
            int n = this.mTarget.getLocation() - this.mLocation;
            byte by = this.mBytes[0];
            if (by == -56 || by == -55) {
                this.mBytes[1] = (byte)(n >> 24);
                this.mBytes[2] = (byte)(n >> 16);
                this.mBytes[3] = (byte)(n >> 8);
                this.mBytes[4] = (byte)(n >> 0);
            } else if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
                this.mBytes[1] = (byte)(n >> 8);
                this.mBytes[2] = (byte)(n >> 0);
            } else if (by == -89 || by == -88) {
                this.mBytes = new byte[5];
                this.mBytes[0] = by == -89 ? -56 : -55;
                this.mBytes[1] = (byte)(n >> 24);
                this.mBytes[2] = (byte)(n >> 16);
                this.mBytes[3] = (byte)(n >> 8);
                this.mBytes[4] = (byte)(n >> 0);
            } else {
                this.mHasShortHop = true;
                this.mBytes[0] = by = Opcode.reverseIfOpcode(by);
                this.mBytes[1] = 0;
                this.mBytes[2] = 8;
                this.insert(new BranchInstruction(0, false, -56, this.mTarget));
            }
            return this.mBytes;
        }

        public boolean isResolved() {
            return this.mTarget.getLocation() >= 0;
        }
    }

    public class CodeInstruction
    extends Instruction {
        protected byte[] mBytes;

        public CodeInstruction(int n) {
            super(n);
        }

        protected CodeInstruction(int n, boolean bl) {
            super(n, bl);
        }

        public CodeInstruction(int n, byte by) {
            super(n);
            this.mBytes = new byte[]{by};
        }

        public CodeInstruction(int n, byte[] byArray) {
            super(n);
            this.mBytes = byArray;
        }

        public boolean isFlowThrough() {
            if (this.mBytes != null && this.mBytes.length > 0) {
                switch (this.mBytes[0]) {
                    case -89: 
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: 
                    case -65: 
                    case -56: {
                        return false;
                    }
                }
            }
            return true;
        }

        public byte[] getBytes() {
            return this.mBytes;
        }

        public boolean isResolved() {
            return true;
        }
    }

    public class LabelInstruction
    extends Instruction
    implements Label {
        public LabelInstruction() {
            super(0, false);
        }

        public Label setLocation() {
            this.add();
            return this;
        }

        public int getLocation() throws IllegalStateException {
            int n = this.mLocation;
            if (n < 0 && this.mPrev == null && this.mNext == null) {
                throw new IllegalStateException("Label location is not set");
            }
            return n;
        }

        public byte[] getBytes() {
            return null;
        }

        public boolean isResolved() {
            return this.getLocation() >= 0;
        }
    }

    public abstract class Instruction
    implements Location {
        private int mStackAdjust;
        Instruction mPrev;
        Instruction mNext;
        int mStackDepth = -1;
        int mLocation = -1;

        public Instruction(int n) {
            this.mStackAdjust = n;
            this.add();
        }

        protected Instruction(int n, boolean bl) {
            this.mStackAdjust = n;
            if (bl) {
                this.add();
            }
        }

        protected void add() {
            InstructionList.this.mResolved = false;
            if (this.mPrev != null) {
                this.mPrev.mNext = this.mNext;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = this.mPrev;
            }
            this.mNext = null;
            if (InstructionList.this.mFirst == null) {
                this.mPrev = null;
                InstructionList.this.mFirst = this;
            } else {
                this.mPrev = InstructionList.this.mLast;
                InstructionList.this.mLast.mNext = this;
            }
            InstructionList.this.mLast = this;
        }

        public void insert(Instruction instruction) {
            InstructionList.this.mResolved = false;
            instruction.mPrev = this;
            instruction.mNext = this.mNext;
            this.mNext = instruction;
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = instruction;
            }
        }

        public void remove() {
            InstructionList.this.mResolved = false;
            if (this.mPrev != null) {
                this.mPrev.mNext = this.mNext;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = this.mPrev;
            }
            if (this == InstructionList.this.mFirst) {
                InstructionList.this.mFirst = this.mNext;
            }
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = this.mPrev;
            }
            this.mPrev = null;
            this.mNext = null;
        }

        public void replace(Instruction instruction) {
            if (instruction == null) {
                this.remove();
                return;
            }
            InstructionList.this.mResolved = false;
            instruction.mPrev = this.mPrev;
            instruction.mNext = this.mNext;
            if (this.mPrev != null) {
                this.mPrev.mNext = instruction;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = instruction;
            }
            if (this == InstructionList.this.mFirst) {
                InstructionList.this.mFirst = instruction;
            }
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = instruction;
            }
        }

        public int getStackAdjustment() {
            return this.mStackAdjust;
        }

        public int getStackDepth() {
            return this.mStackDepth;
        }

        public int getLocation() {
            return this.mLocation;
        }

        public Location[] getBranchTargets() {
            return null;
        }

        public boolean isFlowThrough() {
            return true;
        }

        public boolean isSubroutineCall() {
            return false;
        }

        public abstract byte[] getBytes();

        public abstract boolean isResolved();

        public int compareTo(Object object) {
            int n;
            if (this == object) {
                return 0;
            }
            Location location = (Location)object;
            int n2 = this.getLocation();
            if (n2 < (n = location.getLocation())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            String string = this.getClass().getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf(36)) >= 0) {
                string = string.substring(n + 1);
            }
            StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
            int n2 = this.getStackAdjustment();
            int n3 = this.getStackDepth();
            if (n3 >= 0) {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append('*');
            }
            stringBuffer.append('[');
            stringBuffer.append(this.mLocation);
            stringBuffer.append("] ");
            stringBuffer.append(string);
            stringBuffer.append(" (");
            if (n3 >= 0) {
                stringBuffer.append(n3);
                stringBuffer.append(" + ");
                stringBuffer.append(n2);
                stringBuffer.append(" = ");
                stringBuffer.append(n3 + n2);
            } else {
                stringBuffer.append(n2);
            }
            stringBuffer.append(") ");
            try {
                byte[] byArray = this.getBytes();
                boolean bl = false;
                if (byArray != null) {
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        if (n4 > 0) {
                            stringBuffer.append(',');
                        }
                        byte by = byArray[n4];
                        if (n4 == 0 || bl) {
                            stringBuffer.append(Opcode.getMnemonic(by));
                            bl = by == -60;
                        } else {
                            stringBuffer.append(by & 0xFF);
                        }
                        ++n4;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stringBuffer.toString();
        }
    }

    private class LocalVariableImpl
    implements LocalVariable {
        private String mName;
        private TypeDescriptor mType;
        private boolean mIsDoubleWord;
        private int mNumber;
        private boolean mFixed;
        private List mStoreInstructions;
        private SortedSet mLocationRangeSet;

        public LocalVariableImpl(String string, TypeDescriptor typeDescriptor, int n) {
            this.mName = string;
            this.mType = typeDescriptor;
            Class clazz = typeDescriptor.getClassArg();
            this.mIsDoubleWord = clazz == Long.TYPE || clazz == Double.TYPE;
            this.mNumber = n;
            if (n >= 0) {
                this.mFixed = true;
            }
            this.mStoreInstructions = new ArrayList();
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String string) {
            this.mName = string;
        }

        public TypeDescriptor getType() {
            return this.mType;
        }

        public boolean isDoubleWord() {
            return this.mIsDoubleWord;
        }

        public int getNumber() {
            return this.mNumber;
        }

        public void setNumber(int n) {
            this.mNumber = n;
        }

        public SortedSet getLocationRangeSet() {
            return this.mLocationRangeSet;
        }

        public void setLocations(Set set) {
        }

        public boolean isFixedNumber() {
            return this.mFixed;
        }

        public void addStoreInstruction(Instruction instruction) {
            this.mStoreInstructions.add(instruction);
        }

        public Iterator iterateStoreInstructions() {
            return this.mStoreInstructions.iterator();
        }

        public String toString() {
            if (this.getName() != null) {
                return String.valueOf(this.getType()) + ' ' + this.getName();
            }
            return String.valueOf(this.getType());
        }
    }
}

