/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.FixedLocation;
import com.go.trove.classfile.Location;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

class LineNumberTableAttr
extends Attribute {
    private List mEntries = new ArrayList();
    private boolean mClean = false;

    public LineNumberTableAttr(ConstantPool constantPool) {
        super(constantPool, "LineNumberTable");
    }

    public int getLineNumber(Location location) {
        this.clean();
        int n = Collections.binarySearch(this.mEntries, new Entry(location, 0));
        if (n < 0 && (n = -n - 2) < 0) {
            return -1;
        }
        return ((Entry)this.mEntries.get((int)n)).mLineNumber;
    }

    public void addEntry(Location location, int n) {
        this.check("line number", n);
        this.mEntries.add(new Entry(location, n));
        this.mClean = false;
    }

    public int getLength() {
        this.clean();
        return 2 + 4 * this.mEntries.size();
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        this.clean();
        super.writeTo(dataOutput);
        int n = this.mEntries.size();
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            Entry entry = (Entry)this.mEntries.get(n2);
            int n3 = entry.mStart.getLocation();
            this.check("line number table entry start PC", n3);
            dataOutput.writeShort(n3);
            dataOutput.writeShort(entry.mLineNumber);
            ++n2;
        }
    }

    private void check(String string, int n) throws RuntimeException {
        if (n < 0 || n > 65535) {
            throw new RuntimeException("Value for " + string + " out of " + "valid range: " + n);
        }
    }

    private void clean() {
        if (!this.mClean) {
            this.mClean = true;
            TreeSet treeSet = new TreeSet();
            int n = this.mEntries.size();
            while (--n >= 0) {
                treeSet.add(this.mEntries.get(n));
            }
            this.mEntries = new ArrayList(treeSet);
        }
    }

    static Attribute define(ConstantPool constantPool, DataInput dataInput, String string, int n) throws IOException {
        LineNumberTableAttr lineNumberTableAttr = new LineNumberTableAttr(constantPool);
        int n2 = dataInput.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInput.readUnsignedShort();
            int n5 = dataInput.readUnsignedShort();
            lineNumberTableAttr.addEntry(new FixedLocation(n4), n5);
            ++n3;
        }
        return lineNumberTableAttr;
    }

    private static class Entry
    implements Comparable {
        public final Location mStart;
        public final int mLineNumber;

        public Entry(Location location, int n) {
            this.mStart = location;
            this.mLineNumber = n;
        }

        public int compareTo(Object object) {
            int n;
            int n2 = this.mStart.getLocation();
            if (n2 < (n = ((Entry)object).mStart.getLocation())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                return this.mStart.getLocation() == ((Entry)object).mStart.getLocation();
            }
            return false;
        }

        public String toString() {
            return "start_pc=" + this.mStart.getLocation() + " => " + "line_number=" + this.mLineNumber;
        }
    }
}

