/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantUTFInfo;
import com.go.trove.classfile.FixedLocation;
import com.go.trove.classfile.LocalVariable;
import com.go.trove.classfile.Location;
import com.go.trove.classfile.LocationRange;
import com.go.trove.classfile.LocationRangeImpl;
import com.go.trove.classfile.TypeDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

class LocalVariableTableAttr
extends Attribute {
    private List mEntries = new ArrayList(10);
    private List mCleanEntries;
    private int mRangeCount;

    public LocalVariableTableAttr(ConstantPool constantPool) {
        super(constantPool, "LocalVariableTable");
    }

    public void addEntry(LocalVariable localVariable) {
        String string = localVariable.getName();
        if (string != null) {
            ConstantUTFInfo constantUTFInfo = ConstantUTFInfo.make(this.mCp, string);
            ConstantUTFInfo constantUTFInfo2 = ConstantUTFInfo.make(this.mCp, localVariable.getType().toString());
            this.mEntries.add(new Entry(localVariable, constantUTFInfo, constantUTFInfo2));
        }
        this.mCleanEntries = null;
    }

    public int getLength() {
        this.clean();
        return 2 + 10 * this.mRangeCount;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        this.clean();
        super.writeTo(dataOutput);
        dataOutput.writeShort(this.mRangeCount);
        int n = this.mCleanEntries.size();
        int n2 = 0;
        while (n2 < n) {
            Entry entry = (Entry)this.mEntries.get(n2);
            LocalVariable localVariable = entry.mLocalVar;
            SortedSet sortedSet = localVariable.getLocationRangeSet();
            int n3 = entry.mName.getIndex();
            int n4 = entry.mDescriptor.getIndex();
            int n5 = localVariable.getNumber();
            this.check("local variable table entry name index", n3);
            this.check("local variable table entry descriptor index", n4);
            this.check("local variable table entry index", n5);
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                LocationRange locationRange = (LocationRange)iterator.next();
                Location location = locationRange.getStartLocation();
                Location location2 = locationRange.getEndLocation();
                int n6 = location.getLocation();
                int n7 = location2.getLocation() - n6 - 1;
                this.check("local variable table entry start PC", n6);
                dataOutput.writeShort(n6);
                dataOutput.writeShort(n7);
                dataOutput.writeShort(n3);
                dataOutput.writeShort(n4);
                dataOutput.writeShort(n5);
            }
            ++n2;
        }
    }

    private void check(String string, int n) throws RuntimeException {
        if (n < 0 || n > 65535) {
            throw new RuntimeException("Value for " + string + " out of " + "valid range: " + n);
        }
    }

    private void clean() {
        if (this.mCleanEntries != null) {
            return;
        }
        int n = this.mEntries.size();
        this.mCleanEntries = new ArrayList(n);
        this.mRangeCount = 0;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Entry entry = (Entry)this.mEntries.get(n2);
                LocalVariable localVariable = entry.mLocalVar;
                SortedSet sortedSet = localVariable.getLocationRangeSet();
                if (sortedSet != null && sortedSet.size() != 0) {
                    Iterator iterator = sortedSet.iterator();
                    while (iterator.hasNext()) {
                        LocationRange locationRange = (LocationRange)iterator.next();
                        Location location = locationRange.getStartLocation();
                        Location location2 = locationRange.getEndLocation();
                        if (location != null && location2 != null) {
                            int n3 = location.getLocation();
                            int n4 = location2.getLocation() - n3 - 1;
                            if (n4 >= 0) {
                                continue;
                            }
                        }
                        break block6;
                    }
                    this.mCleanEntries.add(entry);
                    this.mRangeCount += entry.getRangeCount();
                }
            }
            ++n2;
        }
    }

    static Attribute define(ConstantPool constantPool, DataInput dataInput, String string, int n) throws IOException {
        LocalVariableTableAttr localVariableTableAttr = new LocalVariableTableAttr(constantPool);
        int n2 = dataInput.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInput.readUnsignedShort();
            int n5 = n4 + dataInput.readUnsignedShort() + 1;
            int n6 = dataInput.readUnsignedShort();
            int n7 = dataInput.readUnsignedShort();
            final int n8 = dataInput.readUnsignedShort();
            final ConstantUTFInfo constantUTFInfo = (ConstantUTFInfo)constantPool.getConstant(n6);
            final ConstantUTFInfo constantUTFInfo2 = (ConstantUTFInfo)constantPool.getConstant(n7);
            FixedLocation fixedLocation = new FixedLocation(n4);
            FixedLocation fixedLocation2 = new FixedLocation(n5);
            TreeSet<LocationRangeImpl> treeSet = new TreeSet<LocationRangeImpl>();
            treeSet.add(new LocationRangeImpl(fixedLocation, fixedLocation2));
            final SortedSet sortedSet = Collections.unmodifiableSortedSet(treeSet);
            LocalVariable localVariable = new LocalVariable(){
                private String mName;
                private TypeDescriptor mType;
                {
                    this.mName = constantUTFInfo.getValue();
                    this.mType = TypeDescriptor.parseTypeDesc(constantUTFInfo2.getValue());
                }

                public String getName() {
                    return this.mName;
                }

                public void setName(String string) {
                    this.mName = string;
                }

                public TypeDescriptor getType() {
                    return this.mType;
                }

                public boolean isDoubleWord() {
                    Class clazz = this.mType.getClassArg();
                    return clazz == Double.TYPE || clazz == Long.TYPE;
                }

                public int getNumber() {
                    return n8;
                }

                public SortedSet getLocationRangeSet() {
                    return sortedSet;
                }
            };
            Entry entry = new Entry(localVariable, constantUTFInfo, constantUTFInfo2);
            localVariableTableAttr.mEntries.add(entry);
            ++n3;
        }
        return localVariableTableAttr;
    }

    private static class Entry {
        public LocalVariable mLocalVar;
        public ConstantUTFInfo mName;
        public ConstantUTFInfo mDescriptor;

        public Entry(LocalVariable localVariable, ConstantUTFInfo constantUTFInfo, ConstantUTFInfo constantUTFInfo2) {
            this.mLocalVar = localVariable;
            this.mName = constantUTFInfo;
            this.mDescriptor = constantUTFInfo2;
        }

        public int getRangeCount() {
            return this.mLocalVar.getLocationRangeSet().size();
        }
    }
}

