/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.Descriptor;
import com.go.trove.classfile.TypeDescriptor;
import java.util.ArrayList;

public class MethodDescriptor
extends Descriptor {
    private static TypeDescriptor[] cEmptyParams = new TypeDescriptor[0];
    private String mStr;
    private TypeDescriptor mRetType;
    private TypeDescriptor[] mParams;

    public MethodDescriptor() {
        this(null, null);
    }

    public MethodDescriptor(TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        if (typeDescriptorArray == null) {
            typeDescriptorArray = cEmptyParams;
        }
        this.mStr = MethodDescriptor.generate(typeDescriptor, typeDescriptorArray);
        this.mRetType = typeDescriptor;
        this.mParams = typeDescriptorArray;
    }

    public TypeDescriptor getReturnType() {
        return this.mRetType;
    }

    public int getParameterCount() {
        return this.mParams.length;
    }

    public TypeDescriptor[] getParameterTypes() {
        return this.mParams;
    }

    public String toString() {
        return this.mStr;
    }

    public static String generate() {
        return MethodDescriptor.generate(null, null);
    }

    public static String generate(TypeDescriptor typeDescriptor, TypeDescriptor[] typeDescriptorArray) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append('(');
        if (typeDescriptorArray != null) {
            int n = 0;
            while (n < typeDescriptorArray.length) {
                stringBuffer.append(typeDescriptorArray[n]);
                ++n;
            }
        }
        stringBuffer.append(')');
        if (typeDescriptor == null) {
            typeDescriptor = new TypeDescriptor(Void.TYPE);
        }
        stringBuffer.append(typeDescriptor);
        return stringBuffer.toString();
    }

    public static MethodDescriptor parseMethodDesc(String string) throws IllegalArgumentException {
        MethodDescriptor methodDescriptor;
        int n = 0;
        try {
            char c = string.charAt(n++);
            if (c != '(') {
                throw new IllegalArgumentException("Invalid descriptor: " + string);
            }
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>();
            block8: while ((c = string.charAt(n++)) != ')') {
                block1 : switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'V': 
                    case 'Z': {
                        stringBuffer.append(c);
                        break;
                    }
                    case '[': {
                        stringBuffer.append(c);
                        continue block8;
                    }
                    case 'L': {
                        while (true) {
                            stringBuffer.append(c);
                            if (c == ';') break block1;
                            c = string.charAt(n++);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid descriptor: " + string);
                    }
                }
                arrayList.add(TypeDescriptor.parseTypeDesc(stringBuffer.toString()));
                stringBuffer.setLength(0);
            }
            TypeDescriptor typeDescriptor = TypeDescriptor.parseTypeDesc(string.substring(n));
            TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[arrayList.size()];
            typeDescriptorArray = arrayList.toArray(typeDescriptorArray);
            methodDescriptor = new MethodDescriptor(typeDescriptor, typeDescriptorArray);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
        return methodDescriptor;
    }
}

