/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.AccessFlags;
import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.ClassFile;
import com.go.trove.classfile.CodeAttr;
import com.go.trove.classfile.ConstantClassInfo;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantUTFInfo;
import com.go.trove.classfile.DeprecatedAttr;
import com.go.trove.classfile.ExceptionsAttr;
import com.go.trove.classfile.MethodDescriptor;
import com.go.trove.classfile.SyntheticAttr;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class MethodInfo {
    private ClassFile mParent;
    private ConstantPool mCp;
    private String mName;
    private MethodDescriptor mDesc;
    private int mAccessFlags;
    private ConstantUTFInfo mNameConstant;
    private ConstantUTFInfo mDescriptorConstant;
    private List mAttributes = new ArrayList(2);
    private CodeAttr mCode;
    private ExceptionsAttr mExceptions;

    MethodInfo(ClassFile classFile, AccessFlags accessFlags, String string, MethodDescriptor methodDescriptor) {
        this.mParent = classFile;
        this.mCp = classFile.getConstantPool();
        this.mName = string;
        this.mDesc = methodDescriptor;
        this.mAccessFlags = accessFlags.getModifier();
        this.mNameConstant = ConstantUTFInfo.make(this.mCp, string);
        this.mDescriptorConstant = ConstantUTFInfo.make(this.mCp, methodDescriptor.toString());
        if (!accessFlags.isAbstract()) {
            this.addAttribute(new CodeAttr(this.mCp));
        }
    }

    private MethodInfo(ClassFile classFile, int n, ConstantUTFInfo constantUTFInfo, ConstantUTFInfo constantUTFInfo2) {
        this.mParent = classFile;
        this.mCp = classFile.getConstantPool();
        this.mName = constantUTFInfo.getValue();
        this.mDesc = MethodDescriptor.parseMethodDesc(constantUTFInfo2.getValue());
        this.mAccessFlags = n;
        this.mNameConstant = constantUTFInfo;
        this.mDescriptorConstant = constantUTFInfo2;
    }

    public ClassFile getClassFile() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.mDesc;
    }

    public AccessFlags getAccessFlags() {
        return new AccessFlags(this.mAccessFlags);
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public ConstantUTFInfo getDescriptorConstant() {
        return this.mDescriptorConstant;
    }

    public String[] getExceptions() {
        if (this.mExceptions == null) {
            return new String[0];
        }
        return this.mExceptions.getExceptions();
    }

    public CodeAttr getCodeAttr() {
        return this.mCode;
    }

    public boolean isSynthetic() {
        int n = this.mAttributes.size();
        while (--n >= 0) {
            Object e = this.mAttributes.get(n);
            if (!(e instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int n = this.mAttributes.size();
        while (--n >= 0) {
            Object e = this.mAttributes.get(n);
            if (!(e instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public void addException(String string) {
        if (this.mExceptions == null) {
            this.addAttribute(new ExceptionsAttr(this.mCp));
        }
        ConstantClassInfo constantClassInfo = ConstantClassInfo.make(this.mCp, string);
        this.mExceptions.addException(constantClassInfo);
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attribute) {
        if (attribute instanceof CodeAttr) {
            if (this.mCode != null) {
                this.mAttributes.remove(this.mCode);
            }
            this.mCode = (CodeAttr)attribute;
        } else if (attribute instanceof ExceptionsAttr) {
            if (this.mExceptions != null) {
                this.mAttributes.remove(this.mExceptions);
            }
            this.mExceptions = (ExceptionsAttr)attribute;
        }
        this.mAttributes.add(attribute);
    }

    public int getLength() {
        int n = 8;
        int n2 = this.mAttributes.size();
        int n3 = 0;
        while (n3 < n2) {
            n += ((Attribute)this.mAttributes.get(n3)).getLength();
            ++n3;
        }
        return n;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.mAccessFlags);
        dataOutput.writeShort(this.mNameConstant.getIndex());
        dataOutput.writeShort(this.mDescriptorConstant.getIndex());
        int n = this.mAttributes.size();
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = (Attribute)this.mAttributes.get(n2);
            attribute.writeTo(dataOutput);
            ++n2;
        }
    }

    public String toString() {
        String string = Modifier.toString(this.mAccessFlags);
        if (string.length() == 0) {
            return String.valueOf(this.mDesc) + ' ' + this.getName();
        }
        return string + ' ' + this.mDesc + ' ' + this.getName();
    }

    static MethodInfo readFrom(ClassFile classFile, DataInput dataInput) throws IOException {
        ConstantPool constantPool = classFile.getConstantPool();
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        ConstantUTFInfo constantUTFInfo = (ConstantUTFInfo)constantPool.getConstant(n2);
        n2 = dataInput.readUnsignedShort();
        ConstantUTFInfo constantUTFInfo2 = (ConstantUTFInfo)constantPool.getConstant(n2);
        MethodInfo methodInfo = new MethodInfo(classFile, n, constantUTFInfo, constantUTFInfo2);
        int n3 = dataInput.readUnsignedShort();
        int n4 = 0;
        while (n4 < n3) {
            methodInfo.addAttribute(Attribute.readFrom(constantPool, dataInput));
            ++n4;
        }
        return methodInfo;
    }
}

