/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.Attribute;
import com.go.trove.classfile.ConstantPool;
import com.go.trove.classfile.ConstantUTFInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class SourceFileAttr
extends Attribute {
    private String mFileName;
    private ConstantUTFInfo mSourcefile;

    public SourceFileAttr(ConstantPool constantPool, String string) {
        super(constantPool, "SourceFile");
        this.mFileName = string;
        this.mSourcefile = ConstantUTFInfo.make(constantPool, string);
    }

    public String getFileName() {
        return this.mFileName;
    }

    public ConstantUTFInfo getFileNameConstant() {
        return this.mSourcefile;
    }

    public int getLength() {
        return 2;
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        super.writeTo(dataOutput);
        dataOutput.writeShort(this.mSourcefile.getIndex());
    }

    public String toString() {
        return this.mFileName;
    }

    static Attribute define(ConstantPool constantPool, DataInput dataInput, String string, int n) throws IOException {
        int n2 = dataInput.readUnsignedShort();
        if ((n -= 2) > 0) {
            dataInput.skipBytes(n);
        }
        String string2 = ((ConstantUTFInfo)constantPool.getConstant(n2)).getValue();
        return new SourceFileAttr(constantPool, string2);
    }
}

