/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.classfile;

import com.go.trove.classfile.Descriptor;

public class TypeDescriptor
extends Descriptor {
    private String mStr;
    private String mClassName;
    private Class mClass;
    private int mDim;
    private TypeDescriptor mComponentType;
    private int mSpecifiedDim;

    public TypeDescriptor(String string) {
        this.mClassName = string;
        this.mStr = TypeDescriptor.generate(string);
    }

    public TypeDescriptor(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        this.mClassName = clazz.getName();
        this.mClass = clazz;
        this.mDim = n;
        this.mStr = TypeDescriptor.generate(clazz, n);
    }

    public TypeDescriptor(TypeDescriptor typeDescriptor, int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Array dimensions must be greater than zero: " + n);
        }
        this.mClassName = typeDescriptor.getClassName();
        this.mClass = typeDescriptor.getClassArg();
        this.mDim = typeDescriptor.getDimensions() + n;
        this.mStr = this.mClass != null ? TypeDescriptor.generate(this.mClass, this.mDim) : TypeDescriptor.generate(this.mClassName, this.mDim);
        this.mComponentType = typeDescriptor;
        this.mSpecifiedDim = n;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public Class getClassArg() {
        return this.mClass;
    }

    public TypeDescriptor getComponentType() {
        if (this.mComponentType == null && this.mDim > 0) {
            this.mComponentType = this.mClass != null ? new TypeDescriptor(this.mClass) : new TypeDescriptor(this.mClassName);
        }
        return this.mComponentType;
    }

    public int getDimensions() {
        return this.mDim;
    }

    public int getSpecifiedDimensions() {
        return this.mSpecifiedDim != 0 ? this.mSpecifiedDim : this.mDim;
    }

    public int hashCode() {
        return this.mStr.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof TypeDescriptor) {
            return ((TypeDescriptor)object).mStr.equals(this.mStr);
        }
        return false;
    }

    public String toString() {
        return this.mStr;
    }

    static String generate(String string) {
        return TypeDescriptor.generate(string, 0);
    }

    static String generate(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + n + 2);
        while (n-- > 0) {
            stringBuffer.append('[');
        }
        stringBuffer.append('L');
        stringBuffer.append(string.replace('.', '/'));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    static String generate(Class clazz) {
        return TypeDescriptor.generate(clazz, 0);
    }

    static String generate(Class clazz, int n) {
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        if (!clazz.isPrimitive()) {
            return TypeDescriptor.generate(clazz.getName(), n);
        }
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        while (n-- > 0) {
            stringBuffer.append('[');
        }
        int n2 = 86;
        if (clazz == Integer.TYPE) {
            n2 = 73;
        } else if (clazz == Character.TYPE) {
            n2 = 67;
        } else if (clazz == Boolean.TYPE) {
            n2 = 90;
        } else if (clazz == Double.TYPE) {
            n2 = 68;
        } else if (clazz == Float.TYPE) {
            n2 = 70;
        } else if (clazz == Long.TYPE) {
            n2 = 74;
        } else if (clazz == Byte.TYPE) {
            n2 = 66;
        } else if (clazz == Short.TYPE) {
            n2 = 83;
        }
        stringBuffer.append((char)n2);
        return stringBuffer.toString();
    }

    public static TypeDescriptor parseTypeDesc(String string) throws IllegalArgumentException {
        TypeDescriptor typeDescriptor = null;
        int n = 0;
        try {
            char c;
            int n2 = 0;
            while ((c = string.charAt(n++)) == '[') {
                ++n2;
            }
            Class<Object> clazz = null;
            switch (c) {
                case 'V': {
                    clazz = Void.TYPE;
                    break;
                }
                case 'I': {
                    clazz = Integer.TYPE;
                    break;
                }
                case 'C': {
                    clazz = Character.TYPE;
                    break;
                }
                case 'Z': {
                    clazz = Boolean.TYPE;
                    break;
                }
                case 'D': {
                    clazz = Double.TYPE;
                    break;
                }
                case 'F': {
                    clazz = Float.TYPE;
                    break;
                }
                case 'J': {
                    clazz = Long.TYPE;
                    break;
                }
                case 'B': {
                    clazz = Byte.TYPE;
                    break;
                }
                case 'S': {
                    clazz = Short.TYPE;
                    break;
                }
                case 'L': {
                    StringBuffer stringBuffer = new StringBuffer(string.length());
                    while ((c = string.charAt(n++)) != ';') {
                        if (c == '/') {
                            c = '.';
                        }
                        stringBuffer.append(c);
                    }
                    typeDescriptor = new TypeDescriptor(stringBuffer.toString());
                    if (n2 <= 0) break;
                    typeDescriptor = new TypeDescriptor(typeDescriptor, n2);
                }
            }
            if (clazz != null) {
                typeDescriptor = new TypeDescriptor(clazz);
                if (n2 > 0) {
                    typeDescriptor = new TypeDescriptor(typeDescriptor, n2);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
        if (typeDescriptor == null || n != string.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
        return typeDescriptor;
    }
}

