/*
 * Decompiled with CFR 0.152.
 */
package com.go.trove.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class ClassInjector
extends ClassLoader {
    private ClassLoader mSuperLoader;
    private File[] mRootClassDirs;
    private String mRootPackage;
    private Hashtable mDefined;

    public ClassInjector() {
        this(null, (File[])null, null);
    }

    public ClassInjector(ClassLoader classLoader) {
        this(classLoader, (File[])null, null);
    }

    public ClassInjector(File file, String string) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this(null, fileArray, string);
    }

    public ClassInjector(ClassLoader classLoader, File file, String string) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this(classLoader, fileArray, string);
    }

    public ClassInjector(File[] fileArray, String string) {
        this(null, fileArray, string);
    }

    public ClassInjector(ClassLoader classLoader, File[] fileArray, String string) {
        this.mDefined = new Hashtable();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.mSuperLoader = classLoader;
        if (fileArray != null) {
            this.mRootClassDirs = (File[])fileArray.clone();
        }
        if (string != null && !string.endsWith(".")) {
            string = string + '.';
        }
        this.mRootPackage = string;
    }

    public OutputStream getStream(String string) {
        return new Stream(string);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            ClassInjector classInjector = this;
            synchronized (classInjector) {
                clazz = this.findLoadedClass(string);
                if (clazz == null && (clazz = this.loadFromFile(string)) == null && (clazz = this.mSuperLoader != null ? this.mSuperLoader.loadClass(string) : this.findSystemClass(string)) == null) {
                    throw new ClassNotFoundException(string);
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected void define(String string, byte[] byArray) {
        this.defineClass(string, byArray, 0, byArray.length);
    }

    private Class loadFromFile(String string) throws ClassNotFoundException {
        if (this.mRootClassDirs == null) {
            return null;
        }
        String string2 = string;
        if (this.mRootPackage != null) {
            if (string2.startsWith(this.mRootPackage)) {
                string2 = string2.substring(this.mRootPackage.length());
            } else {
                return null;
            }
        }
        string2 = string2.replace('.', File.separatorChar);
        ClassNotFoundException classNotFoundException = null;
        int n = 0;
        while (n < this.mRootClassDirs.length) {
            block10: {
                File file = new File(this.mRootClassDirs[n], string2 + ".class");
                if (file.exists()) {
                    try {
                        byte[] byArray = new byte[(int)file.length()];
                        int n2 = byArray.length;
                        int n3 = 0;
                        FileInputStream fileInputStream = new FileInputStream(file);
                        int n4 = -1;
                        while ((n4 = ((InputStream)fileInputStream).read(byArray, n3, n2)) > 0) {
                            n3 += n4;
                            if ((n2 -= n4) > 0) continue;
                            n2 = byArray.length;
                            byte[] byArray2 = new byte[n2 * 2];
                            System.arraycopy(byArray, 0, byArray2, 0, n2);
                            byArray = byArray2;
                        }
                        ((InputStream)fileInputStream).close();
                        return this.defineClass(string, byArray, 0, n3);
                    }
                    catch (IOException iOException) {
                        if (classNotFoundException != null) break block10;
                        classNotFoundException = new ClassNotFoundException(string2 + ": " + iOException.toString());
                    }
                }
            }
            ++n;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        return null;
    }

    private class Stream
    extends ByteArrayOutputStream {
        private String mName;

        public Stream(String string) {
            super(1024);
            this.mName = string;
        }

        public void close() {
            Hashtable hashtable = ClassInjector.this.mDefined;
            synchronized (hashtable) {
                if (ClassInjector.this.mDefined.get(this.mName) == null) {
                    ClassInjector.this.define(this.mName, this.toByteArray());
                    ClassInjector.this.mDefined.put(this.mName, this.mName);
                }
            }
        }
    }
}

