/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.codegen;

import com.go.trove.classfile.AccessFlags;
import com.go.trove.classfile.ClassFile;
import com.go.trove.classfile.CodeBuilder;
import com.go.trove.classfile.Label;
import com.go.trove.classfile.LocalVariable;
import com.go.trove.classfile.Location;
import com.go.trove.classfile.MethodInfo;
import com.go.trove.classfile.TypeDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import uchicago.src.codegen.RSClassLoader;
import uchicago.src.nqpy.compiler.NQPyClassFactory;

public class ByteCodeGenerator {
    public static final String INT = "int";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String LONG = "long";
    public static final String BOOLEAN = "boolean";
    public static final String STRING = "java.lang.String";
    public static final String SHORT_STRING = "String";
    protected ArrayList classFiles = new ArrayList();
    protected Hashtable classes = new Hashtable();
    protected Hashtable localVars = new Hashtable();
    protected Hashtable fields = new Hashtable();
    private Hashtable details = new Hashtable();
    protected ClassFile cf;
    protected CodeBuilder builder;
    protected CodeBuilder ctorBuilder;
    protected RSClassLoader loader;
    protected static Set allowableInitFields = new HashSet();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$uchicago$src$sim$engine$SimModel;
    static /* synthetic */ Class class$uchicago$src$sim$engine$BasicAction;
    static /* synthetic */ Class class$uchicago$src$sim$util$ByteCodeBuilder;
    static /* synthetic */ Class class$java$io$PrintStream;
    static /* synthetic */ Class array$Ljava$lang$String;

    public ByteCodeGenerator() {
        this.reInit();
    }

    public void reInit() {
        Class clazz = class$uchicago$src$sim$engine$SimModel == null ? (class$uchicago$src$sim$engine$SimModel = ByteCodeGenerator.class$("uchicago.src.sim.engine.SimModel")) : class$uchicago$src$sim$engine$SimModel;
        Class clazz2 = class$uchicago$src$sim$engine$BasicAction == null ? (class$uchicago$src$sim$engine$BasicAction = ByteCodeGenerator.class$("uchicago.src.sim.engine.BasicAction")) : class$uchicago$src$sim$engine$BasicAction;
        Class clazz3 = class$uchicago$src$sim$util$ByteCodeBuilder == null ? (class$uchicago$src$sim$util$ByteCodeBuilder = ByteCodeGenerator.class$("uchicago.src.sim.util.ByteCodeBuilder")) : class$uchicago$src$sim$util$ByteCodeBuilder;
        this.loader = new RSClassLoader(this.getClass().getClassLoader());
        NQPyClassFactory.setClassLoader(this.loader);
    }

    public void addClassPath(String string) {
        try {
            this.loader.addPath(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public RSClassLoader getLoader() {
        return this.loader;
    }

    protected TypeDescriptor[] makeTypeDescriptors(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            typeDescriptorArray[i] = new TypeDescriptor(classArray[i]);
        }
        return typeDescriptorArray;
    }

    protected TypeDescriptor[] makeTypeDescriptors(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            typeDescriptorArray[i] = new TypeDescriptor(stringArray[i]);
        }
        return typeDescriptorArray;
    }

    protected Class classFromString(String string) throws ClassNotFoundException {
        if (string.equals(INT)) {
            return Integer.TYPE;
        }
        if (string.equals(DOUBLE)) {
            return Double.TYPE;
        }
        if (string.equals(STRING) || string.equals(SHORT_STRING)) {
            return class$java$lang$String == null ? (class$java$lang$String = ByteCodeGenerator.class$(STRING)) : class$java$lang$String;
        }
        if (string.equals(FLOAT)) {
            return Float.TYPE;
        }
        if (string.equals(LONG)) {
            return Long.TYPE;
        }
        if (string.equals(BOOLEAN)) {
            return Boolean.TYPE;
        }
        return Class.forName(string);
    }

    public ClassFile getClassFile() {
        return this.cf;
    }

    public void setWorkingClass(String string) {
        this.builder = null;
        this.ctorBuilder = null;
        this.cf = (ClassFile)this.classes.get(string);
    }

    public void createClass(String string) {
        if (this.cf != null) {
            this.classFiles.add(this.cf);
        }
        this.fields = new Hashtable();
        this.cf = new ClassFile(string);
        this.classes.put(string, this.cf);
    }

    public void createClass(String string, String string2) {
        if (this.cf != null) {
            this.classFiles.add(this.cf);
        }
        this.fields = new Hashtable();
        this.cf = new ClassFile(string, string2);
        this.classes.put(string, this.cf);
    }

    public void createClass(String string, Class clazz) {
        if (this.cf != null) {
            this.classFiles.add(this.cf);
        }
        this.fields = new Hashtable();
        this.cf = new ClassFile(string, clazz);
        this.classes.put(string, this.cf);
    }

    public void addInterface(String string) {
        this.cf.addInterface(string);
    }

    public void createMethod(Method method) {
        this.localVars = new Hashtable();
        MethodInfo methodInfo = this.cf.addMethod(method);
        this.builder = new CodeBuilder(methodInfo);
    }

    public void finishClass() {
        if (this.cf != null) {
            this.classFiles.add(this.cf);
        }
        this.fields = new Hashtable();
        this.cf = null;
        this.builder = null;
        this.ctorBuilder = null;
    }

    public void createPublicSetMethod(String string, Class clazz, String string2, String string3) {
        this.localVars = new Hashtable();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPublic(true);
        TypeDescriptor typeDescriptor = null;
        if (clazz != null) {
            typeDescriptor = new TypeDescriptor(clazz);
        }
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{new TypeDescriptor(string2)};
        MethodInfo methodInfo = this.cf.addMethod(accessFlags, string, typeDescriptor, typeDescriptorArray);
        this.builder = new CodeBuilder(methodInfo);
        this.builder.loadThis();
        this.builder.loadLocal(this.builder.getParameters()[0]);
        this.builder.storeField(string3, new TypeDescriptor(string2));
        this.builder.returnVoid();
    }

    public void createPublicMethod(String string, Class clazz, Class[] classArray) {
        this.localVars = new Hashtable();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPublic(true);
        TypeDescriptor typeDescriptor = null;
        if (clazz != null) {
            typeDescriptor = new TypeDescriptor(clazz);
        }
        MethodInfo methodInfo = this.cf.addMethod(accessFlags, string, typeDescriptor, this.makeTypeDescriptors(classArray));
        this.builder = new CodeBuilder(methodInfo);
    }

    public void createStringArrayField(String string, String[] stringArray) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(stringArray.getClass());
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        this.fields.put(string, typeDescriptor);
        this.cf.addField(accessFlags, string, typeDescriptor);
        this.ctorBuilder.loadThis();
        this.ctorBuilder.loadConstant(stringArray.length);
        this.ctorBuilder.newObject(typeDescriptor);
        this.ctorBuilder.storeField(string, typeDescriptor);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.ctorBuilder.loadThis();
            this.ctorBuilder.loadField(string, typeDescriptor);
            this.ctorBuilder.loadConstant(i);
            this.ctorBuilder.loadConstant(stringArray[i]);
            this.ctorBuilder.storeToArray(class$java$lang$String == null ? ByteCodeGenerator.class$(STRING) : class$java$lang$String);
        }
    }

    public void createDefaultConstructor(Class[] classArray) {
        this.localVars = new Hashtable();
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPublic(true);
        MethodInfo methodInfo = this.cf.addConstructor(accessFlags, this.makeTypeDescriptors(classArray));
        this.ctorBuilder = new CodeBuilder(methodInfo);
        this.ctorBuilder.loadThis();
        this.ctorBuilder.invokeSuperConstructor(null);
    }

    public void createConstructorWithSuper(Class[] classArray) {
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPublic(true);
        TypeDescriptor[] typeDescriptorArray = this.makeTypeDescriptors(classArray);
        MethodInfo methodInfo = this.cf.addConstructor(accessFlags, typeDescriptorArray);
        this.ctorBuilder = new CodeBuilder(methodInfo);
        this.ctorBuilder.loadThis();
        LocalVariable[] localVariableArray = this.ctorBuilder.getParameters();
        for (int i = 0; i < localVariableArray.length; ++i) {
            this.ctorBuilder.loadLocal(localVariableArray[i]);
        }
        this.ctorBuilder.invokeSuperConstructor(typeDescriptorArray);
    }

    public void createFieldsConstructor(ArrayList arrayList, String[] stringArray) {
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        this.localVars = new Hashtable();
        AccessFlags accessFlags2 = new AccessFlags();
        accessFlags2.setPublic(true);
        MethodInfo methodInfo = this.cf.addConstructor(accessFlags2, this.makeTypeDescriptors(stringArray));
        this.ctorBuilder = new CodeBuilder(methodInfo);
        this.ctorBuilder.loadThis();
        this.ctorBuilder.invokeConstructor(null);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = (String)arrayList.get(i);
            String string2 = stringArray[i];
            TypeDescriptor typeDescriptor = (TypeDescriptor)this.fields.get(string);
            if (typeDescriptor == null) {
                typeDescriptor = new TypeDescriptor(string2);
                this.fields.put(string, typeDescriptor);
                this.cf.addField(accessFlags, string, typeDescriptor);
            }
            this.ctorBuilder.loadThis();
            LocalVariable[] localVariableArray = this.ctorBuilder.getParameters();
            this.ctorBuilder.loadLocal(localVariableArray[i]);
            this.ctorBuilder.storeField(string, typeDescriptor);
        }
        this.finishCtor();
        this.createDefaultConstructor(new Class[0]);
    }

    public void finishCtor() {
        this.ctorBuilder.returnVoid();
        this.ctorBuilder = null;
    }

    public void emitConstString(String string) {
        this.builder.loadConstant(string);
    }

    public void emitNew(Class clazz) {
        this.builder.newObject(new TypeDescriptor(clazz));
    }

    public void emitNew(String string) {
        this.builder.newObject(new TypeDescriptor(string));
    }

    public void emitDup() {
        this.builder.dup();
    }

    public void emitPop() {
        this.builder.pop();
    }

    public void createAccessor(String string, Class clazz, String string2) {
        this.createAccessor(string, clazz);
        this.setInitialFieldValue(string, clazz, string2);
    }

    public void setInitialFieldValue(String string, String string2, String string3) {
        try {
            if (!this.fields.containsKey(string)) {
                this.createPrivateField(string, string2);
            }
            this.setInitialFieldValue(string, this.classFromString(string2), string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Error setting field value: class " + string2 + " not found");
        }
    }

    public void setInitialFieldValue(String string, Class clazz, String string2) {
        if (allowableInitFields.contains(clazz)) {
            this.ctorBuilder.loadThis();
            if (clazz.equals(Integer.TYPE)) {
                this.ctorBuilder.loadConstant(Integer.parseInt(string2));
            } else if (clazz.equals(Float.TYPE)) {
                this.ctorBuilder.loadConstant(Float.parseFloat(string2));
            } else if (clazz.equals(Double.TYPE)) {
                this.ctorBuilder.loadConstant(Double.parseDouble(string2));
            } else if (clazz.equals(Long.TYPE)) {
                this.ctorBuilder.loadConstant(Long.parseLong(string2));
            } else if (clazz.equals(Boolean.TYPE)) {
                this.ctorBuilder.loadConstant(Boolean.getBoolean(string2));
            } else if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = ByteCodeGenerator.class$(STRING)) : class$java$lang$String)) {
                this.ctorBuilder.loadConstant(string2);
            }
        } else {
            System.out.println("Type: " + clazz.getName() + " not supported as default value");
            return;
        }
        this.ctorBuilder.storeField(string, (TypeDescriptor)this.fields.get(string));
    }

    public void createAccessor(String string, String string2, String string3) {
        try {
            this.createAccessor(string, this.classFromString(string2), string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Error creating accessor: class " + string2 + " not found");
        }
    }

    public void createGetMethodRetField(String string, String string2, Class clazz) {
        this.createPublicMethod(string, clazz, new Class[0]);
        this.builder.loadThis();
        this.builder.loadField(string2, new TypeDescriptor(clazz));
        this.builder.returnValue(clazz);
        this.builder = null;
    }

    public void createAccessor(String string, Class clazz) {
        this.createPrivateField(string, clazz);
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        this.createPublicMethod("set" + string2, null, new Class[]{clazz});
        this.builder.loadThis();
        this.builder.loadLocal(this.builder.getParameters()[0]);
        this.builder.storeField(string, new TypeDescriptor(clazz));
        this.builder.returnVoid();
        this.createPublicMethod("get" + string2, clazz, null);
        this.builder.loadThis();
        this.builder.loadField(string, new TypeDescriptor(clazz));
        this.builder.returnValue(clazz);
        this.builder = null;
    }

    public void createAccessor(String string, String string2) {
        try {
            this.createAccessor(string, this.classFromString(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Error creating accessor: class " + string2 + " not found");
        }
    }

    public void createPrivateField(String string, Class clazz) {
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(clazz);
        this.fields.put(string, typeDescriptor);
        this.cf.addField(accessFlags, string, typeDescriptor);
    }

    public void createPrivateField(String string, String string2) {
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        try {
            TypeDescriptor typeDescriptor = new TypeDescriptor(this.classFromString(string2));
            this.fields.put(string, typeDescriptor);
            this.cf.addField(accessFlags, string, typeDescriptor);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Error creating private field: Unable to find class for '" + string2 + "'");
        }
    }

    public void initStringField(String string, String string2, boolean bl) {
        this.ctorBuilder.loadThis();
        this.ctorBuilder.loadConstant(string2);
        TypeDescriptor typeDescriptor = new TypeDescriptor(class$java$lang$String == null ? (class$java$lang$String = ByteCodeGenerator.class$(STRING)) : class$java$lang$String);
        if (bl) {
            this.ctorBuilder.storeField(this.cf.getSuperClassName(), string, typeDescriptor);
        } else {
            this.ctorBuilder.storeField(string, typeDescriptor);
        }
    }

    public void createProtectedField(String string, Class clazz) {
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setProtected(true);
        TypeDescriptor typeDescriptor = new TypeDescriptor(clazz);
        this.fields.put(string, typeDescriptor);
        this.cf.addField(accessFlags, string, typeDescriptor);
    }

    public void emitInvokeConstructor(Class clazz, Class[] classArray) {
        TypeDescriptor[] typeDescriptorArray = this.makeTypeDescriptors(classArray);
        this.builder.invokeConstructor(clazz.getName(), typeDescriptorArray);
    }

    public void emitInvokeConstructor(String string, Class[] classArray) {
        TypeDescriptor[] typeDescriptorArray = this.makeTypeDescriptors(classArray);
        this.builder.invokeConstructor(string, typeDescriptorArray);
    }

    public void emitInvokeConstructor(String string, String[] stringArray) {
        TypeDescriptor[] typeDescriptorArray = this.makeTypeDescriptors(stringArray);
        this.builder.invokeConstructor(string, typeDescriptorArray);
    }

    public void emitThis() {
        this.builder.loadThis();
    }

    public void emitInvokeSuper(Method method) {
        this.builder.loadThis();
        this.builder.invokeSuper(method);
    }

    public void emitStoreValInField(String string, String string2) {
        Class clazz = ((TypeDescriptor)this.fields.get(string)).getClassArg();
        this.builder.loadThis();
        if (clazz.equals(Integer.TYPE)) {
            this.builder.loadConstant(Integer.parseInt(string2));
        } else if (clazz.equals(Float.TYPE)) {
            this.builder.loadConstant(Float.parseFloat(string2));
        } else if (clazz.equals(Double.TYPE)) {
            this.builder.loadConstant(Double.parseDouble(string2));
        } else if (clazz.equals(Long.TYPE)) {
            this.builder.loadConstant(Long.parseLong(string2));
        } else if (clazz.equals(Boolean.TYPE)) {
            this.builder.loadConstant(Boolean.getBoolean(string2));
        } else if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = ByteCodeGenerator.class$(STRING)) : class$java$lang$String)) {
            this.builder.loadConstant(string2);
        } else {
            System.out.println("Type: " + clazz.getName() + " not supported as default value");
            this.builder.pop();
            return;
        }
        this.builder.storeField(string, (TypeDescriptor)this.fields.get(string));
    }

    public void emitInvokeVirtual(String string, Class clazz, Class[] classArray) {
        TypeDescriptor[] typeDescriptorArray = this.makeTypeDescriptors(classArray);
        this.builder.invokeVirtual(string, new TypeDescriptor(clazz), typeDescriptorArray);
    }

    public void emitInvokeVirtual(Class clazz, String string, Class clazz2, Class[] classArray) {
        TypeDescriptor[] typeDescriptorArray = this.makeTypeDescriptors(classArray);
        if (clazz2 == null) {
            this.builder.invokeVirtual(clazz.getName(), string, null, typeDescriptorArray);
        } else {
            this.builder.invokeVirtual(clazz.getName(), string, new TypeDescriptor(clazz2), typeDescriptorArray);
        }
    }

    public void emitInvokeStatic(Class clazz, String string, Class clazz2, Class[] classArray) {
        TypeDescriptor[] typeDescriptorArray = this.makeTypeDescriptors(classArray);
        this.builder.invokeStatic(clazz.getName(), string, new TypeDescriptor(clazz2), typeDescriptorArray);
    }

    public void emitLoadFieldFromVar(String string, String string2, Class clazz) {
        LocalVariable localVariable = (LocalVariable)this.localVars.get(string);
        this.builder.loadLocal(localVariable);
        this.builder.loadField(localVariable.getType().getClassName(), string2, new TypeDescriptor(clazz));
    }

    public void emitStoreFieldFromVar(String string, String string2, Class clazz) throws NoSuchFieldException {
        LocalVariable localVariable = (LocalVariable)this.localVars.get(string);
        this.builder.storeField(localVariable.getType().getClassName(), string2, new TypeDescriptor(clazz));
    }

    public void emitLoadStaticField(Class clazz, String string, Class clazz2) {
        this.builder.loadStaticField(clazz.getName(), string, new TypeDescriptor(clazz2));
    }

    public void emitPrintStart() {
        this.builder.loadStaticField("java.lang.System", "out", new TypeDescriptor(class$java$io$PrintStream == null ? (class$java$io$PrintStream = ByteCodeGenerator.class$("java.io.PrintStream")) : class$java$io$PrintStream));
    }

    public void emitPrintEnd(Class clazz) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(clazz);
        this.builder.invokeVirtual("java.io.PrintStream", "print", null, new TypeDescriptor[]{typeDescriptor});
    }

    public void emitPrintlnEnd(Class clazz) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(clazz);
        this.builder.invokeVirtual("java.io.PrintStream", "println", null, new TypeDescriptor[]{typeDescriptor});
    }

    public void emitLocalVar(String string, Class clazz) {
        if (!this.localVars.containsKey(string)) {
            LocalVariable localVariable = this.builder.createLocalVariable(string, new TypeDescriptor(clazz));
            this.localVars.put(string, localVariable);
        }
    }

    public void emitStoreLocal(String string) {
        LocalVariable localVariable = (LocalVariable)this.localVars.get(string);
        this.builder.storeLocal(localVariable);
    }

    public void emitLoadLocal(String string) {
        LocalVariable localVariable = (LocalVariable)this.localVars.get(string);
        this.builder.loadLocal(localVariable);
    }

    public void emitIntToDouble() {
        this.builder.convert(Integer.TYPE, Double.TYPE);
    }

    public void emitConstInt(int n) {
        this.builder.loadConstant(n);
    }

    public void emitConstDouble(double d) {
        this.builder.loadConstant(d);
    }

    public Label createLabel() {
        return this.builder.createLabel();
    }

    public void emitGoto(Label label) {
        this.builder.branch((Location)label);
    }

    public void emitIfIntNotEqZero(Label label) {
        this.builder.ifZeroComparisonBranch((Location)label, "!=");
    }

    public void emitIfDoubleNotEqZero(Label label) {
        this.builder.loadConstant(0.0);
        this.builder.math((byte)-104);
        this.builder.ifZeroComparisonBranch((Location)label, "!=");
    }

    public void emitDoubleLessThan() {
        this.builder.math((byte)-105);
    }

    public void emitIfNotNull(Label label) {
        this.builder.ifNullBranch((Location)label, false);
    }

    public void emitIfIntEquals(Label label) {
        this.builder.ifComparisonBranch((Location)label, "==");
    }

    public void emitAdd(String string) {
        if (string.equals(INT)) {
            this.builder.math((byte)96);
        } else {
            this.builder.math((byte)99);
        }
    }

    public void emitLoadField(String string, Class clazz, boolean bl) {
        this.builder.loadThis();
        if (bl) {
            this.builder.loadField(this.cf.getSuperClassName(), string, new TypeDescriptor(clazz));
        } else {
            this.builder.loadField(string, new TypeDescriptor(clazz));
        }
    }

    public void emitIntInc(String string, int n) {
        this.builder.integerIncrement((LocalVariable)this.localVars.get(string), n);
    }

    public void emitIfIntLt(Label label) {
        this.builder.ifComparisonBranch((Location)label, "<");
    }

    public void emitInitStringtArrayInCtor(int n, String string) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(array$Ljava$lang$String == null ? (array$Ljava$lang$String = ByteCodeGenerator.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        this.ctorBuilder.loadThis();
        this.ctorBuilder.loadConstant(n);
        this.ctorBuilder.newObject(typeDescriptor);
        this.ctorBuilder.storeField(this.cf.getSuperClassName(), string, typeDescriptor);
    }

    public void emitAddStringToCtorArray(String string, int n, String string2) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(array$Ljava$lang$String == null ? (array$Ljava$lang$String = ByteCodeGenerator.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        this.ctorBuilder.loadThis();
        this.ctorBuilder.loadField(this.cf.getSuperClassName(), string2, typeDescriptor);
        this.ctorBuilder.loadConstant(n);
        this.ctorBuilder.loadConstant(string);
        this.ctorBuilder.storeToArray(class$java$lang$String == null ? (class$java$lang$String = ByteCodeGenerator.class$(STRING)) : class$java$lang$String);
    }

    public void emitReturn(Class clazz) {
        if (clazz != null) {
            this.builder.returnValue(clazz);
        } else {
            this.builder.returnVoid();
        }
    }

    public void emitReturnField(String string) {
        TypeDescriptor typeDescriptor = (TypeDescriptor)this.fields.get(string);
        this.builder.loadThis();
        this.builder.loadField(string, typeDescriptor);
        this.builder.returnValue(typeDescriptor.getClassArg());
    }

    public void addClasses() {
        for (int i = 0; i < this.classFiles.size(); ++i) {
            ClassFile classFile = (ClassFile)this.classFiles.get(i);
            this.loader.addClass(classFile.getClassName(), classFile);
        }
    }

    public void writeToFile(String string, String string2) {
        this.addClasses();
        this.loader.writeClass(string, string2);
    }

    public Class loadClass(String string, String string2) throws ClassNotFoundException {
        Object object;
        Object object2;
        String string3 = System.getProperty("java.class.path");
        String string4 = System.getProperty("path.separator");
        String string5 = File.separator;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string4);
        URL[] uRLArray = new URL[stringTokenizer.countTokens() + 1];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            if (!((String)object2).endsWith("jar") && !((String)object2).endsWith(string5)) {
                object2 = (String)object2 + string5;
            }
            object = null;
            try {
                uRLArray[n] = object = new URL("file://" + (String)object2);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            ++n;
        }
        object2 = null;
        try {
            uRLArray[n] = object2 = new URL("file://" + string2 + string5);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        object = new URLClassLoader(uRLArray, (ClassLoader)this.loader);
        Class<?> clazz = null;
        try {
            clazz = ((ClassLoader)object).loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
        return clazz;
    }

    public Object getDetail(Object object) {
        return this.details.get(object);
    }

    public void putDetail(Object object, Object object2) {
        this.details.put(object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        allowableInitFields.add(Integer.TYPE);
        allowableInitFields.add(Double.TYPE);
        allowableInitFields.add(Float.TYPE);
        allowableInitFields.add(Long.TYPE);
        allowableInitFields.add(Boolean.TYPE);
        allowableInitFields.add(class$java$lang$String == null ? (class$java$lang$String = ByteCodeGenerator.class$(STRING)) : class$java$lang$String);
    }
}

