/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.collection;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import uchicago.src.collection.BaseMatrix;

public class DoubleMatrix
implements BaseMatrix {
    private double[] matrix;
    private int sizeX;
    private int sizeY;

    public DoubleMatrix(int n, int n2) {
        this.matrix = new double[n * n2];
        this.sizeX = n;
        this.sizeY = n2;
    }

    public DoubleMatrix(int n, int n2, double[] dArray) {
        this.sizeX = n;
        this.sizeY = n2;
        if (dArray.length != n * n2) {
            throw new IllegalArgumentException("Matrix size is not equal to sizeX * sizeY");
        }
        this.matrix = new double[dArray.length];
        System.arraycopy(dArray, 0, this.matrix, 0, dArray.length);
    }

    public double getDoubleAt(int n, int n2) {
        return this.matrix[n2 * this.sizeX + n];
    }

    public void putDoubleAt(int n, int n2, double d) {
        this.matrix[n2 * this.sizeX + n] = d;
    }

    public DoubleMatrix copyMatrix() {
        return new DoubleMatrix(this.sizeX, this.sizeY, this.matrix);
    }

    public void copyMatrixTo(DoubleMatrix doubleMatrix) {
        if (this.matrix.length != doubleMatrix.matrix.length) {
            double[] dArray = new double[this.sizeY * this.sizeX];
            System.arraycopy(this.matrix, 0, dArray, 0, this.sizeY * this.sizeX);
            doubleMatrix.matrix = dArray;
        } else {
            System.arraycopy(this.matrix, 0, doubleMatrix.matrix, 0, this.sizeY * this.sizeX);
        }
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void initialize(double d) {
        int n = this.sizeX * this.sizeY;
        for (int i = 0; i < n; ++i) {
            this.matrix[i] = d;
        }
    }

    public Object get(int n) {
        return new Double(this.matrix[n]);
    }

    public Object get(int n, int n2) {
        return new Double(this.getDoubleAt(n, n2));
    }

    public void put(int n, Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("object must be a Number");
        }
        this.matrix[n] = ((Number)object).doubleValue();
    }

    public void put(int n, int n2, Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("object must be a Number");
        }
        this.putDoubleAt(n, n2, ((Number)object).doubleValue());
    }

    public Object remove(int n, int n2) {
        Double d = new Double(this.getDoubleAt(n, n2));
        this.putDoubleAt(n, n2, 0.0);
        return d;
    }

    public Object remove(int n) {
        Double d = new Double(this.matrix[n]);
        this.matrix[n] = 0.0;
        return d;
    }

    public double removeDouble(int n, int n2) {
        double d = this.getDoubleAt(n, n2);
        this.putDoubleAt(n, n2, 0.0);
        return d;
    }

    public int size() {
        return this.sizeX * this.sizeY;
    }

    public int getNumRows() {
        return this.sizeY;
    }

    public int getNumCols() {
        return this.sizeX;
    }

    public double[] getData() {
        return this.matrix;
    }

    public void trim() {
    }

    public void printToFile(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            String string2 = "";
            for (int i = 0; i < this.sizeX; ++i) {
                for (int j = 0; j < this.sizeY; ++j) {
                    bufferedWriter.write(this.getDoubleAt(i, j) + " ");
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

