/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.compiler;

import com.go.trove.classfile.Label;
import uchicago.src.nqpy.compiler.Emitter;
import uchicago.src.nqpy.compiler.ErrorFactory;
import uchicago.src.nqpy.compiler.NQPyBlockCompiler;
import uchicago.src.nqpy.compiler.NQPyClass;
import uchicago.src.nqpy.parser.SimpleNode;

public abstract class AbstractEmitter
implements Emitter {
    protected NQPyClass nqPyClass;

    public AbstractEmitter(NQPyClass nQPyClass) {
        this.nqPyClass = nQPyClass;
    }

    public NQPyClass getArithResType(NQPyClass nQPyClass) {
        String string = "Arithmetic operations not supported between " + this.nqPyClass.getJClassName() + " and " + nQPyClass.getJClassName();
        throw ErrorFactory.createCompilerException(string);
    }

    public NQPyClass getArithResType() {
        String string = "Arithmetic operation not supported on " + this.nqPyClass.getJClassName();
        throw ErrorFactory.createCompilerException(string);
    }

    public void branchOnTrue(SimpleNode simpleNode, NQPyBlockCompiler nQPyBlockCompiler, Label label) {
        String string = "branchOnTrue not supported on " + this;
        throw ErrorFactory.createCompilerException(string);
    }

    private void throwArithError(String string) {
        String string2 = "Arithmetic operations not supported between " + this.nqPyClass.getJClassName() + " and " + string;
        throw ErrorFactory.createCompilerException(string2);
    }

    private void throwArithError() {
        String string = "Arithmetic operation not supported on " + this.nqPyClass.getJClassName();
        throw ErrorFactory.createCompilerException(string);
    }

    public void branchOnFalse(SimpleNode simpleNode, NQPyBlockCompiler nQPyBlockCompiler, Label label) {
        String string = "branchOnFalse not supported on " + this;
        throw ErrorFactory.createCompilerException(string);
    }

    public void eq(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.eqCmpInt(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.eqCmpDouble(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.eqCmpLong(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.eqCmpFloat(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 5: {
                this.eqCmpString(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 4: {
                this.eqCmpBoolean(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 6: {
                this.eqCmpJava(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 9: {
                this.eqCmpJava(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            default: {
                String string = "Cannot compare " + this + " and " + nQPyClass;
                throw ErrorFactory.createCompilerException(string);
            }
        }
    }

    public void eqCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("int");
    }

    public void eqCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("double");
    }

    public void eqCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("long");
    }

    public void eqCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("float");
    }

    public void eqCmpBoolean(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("boolean");
    }

    public void eqCmpString(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("java.lang.String");
    }

    public void eqCmpJava(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError(simpleNode2.getNQPyClass(nQPyBlockCompiler).getJClassName());
    }

    public void notEq(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.notEqCmpInt(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.notEqCmpDouble(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.notEqCmpLong(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.notEqCmpFloat(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 5: {
                this.notEqCmpString(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 4: {
                this.notEqCmpBoolean(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 6: {
                System.out.println("here " + this);
                this.notEqCmpJava(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 9: {
                this.notEqCmpJava(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            default: {
                String string = "Cannot compare " + this + " and " + nQPyClass;
                throw ErrorFactory.createCompilerException(string);
            }
        }
    }

    public void notEqCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("int");
    }

    public void notEqCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("double");
    }

    public void notEqCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("long");
    }

    public void notEqCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("float");
    }

    public void notEqCmpBoolean(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("boolean");
    }

    public void notEqCmpString(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("java.lang.String");
    }

    public void notEqCmpJava(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError(simpleNode2.getNQPyClass(nQPyBlockCompiler).getJClassName());
    }

    private void throwCmpError(String string) {
        String string2 = "Cannot compare " + this.nqPyClass.getJClassName() + " and " + string;
        throw ErrorFactory.createCompilerException(string2);
    }

    public void gt(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.gtCmpInt(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.gtCmpDouble(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.gtCmpLong(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.gtCmpFloat(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 5: {
                this.gtCmpString(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 4: {
                this.gtCmpBoolean(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 6: {
                this.gtCmpJava(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            default: {
                String string = "Cannot compare " + this + " and " + nQPyClass;
                throw ErrorFactory.createCompilerException(string);
            }
        }
    }

    public void gtCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("int");
    }

    public void gtCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("double");
    }

    public void gtCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("long");
    }

    public void gtCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("float");
    }

    public void gtCmpBoolean(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("boolean");
    }

    public void gtCmpString(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("java.lang.String");
    }

    public void gtCmpJava(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError(simpleNode2.getNQPyClass(nQPyBlockCompiler).getJClassName());
    }

    public void lt(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.ltCmpInt(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.ltCmpDouble(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.ltCmpLong(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.ltCmpFloat(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 5: {
                this.ltCmpString(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 4: {
                this.ltCmpBoolean(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 6: {
                System.out.println("here " + this);
                this.ltCmpJava(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            default: {
                String string = "Cannot compare " + this + " and " + nQPyClass;
                throw ErrorFactory.createCompilerException(string);
            }
        }
    }

    public void ltCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("int");
    }

    public void ltCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("double");
    }

    public void ltCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("long");
    }

    public void ltCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("float");
    }

    public void ltCmpBoolean(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("boolean");
    }

    public void ltCmpString(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("java.lang.String");
    }

    public void ltCmpJava(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError(simpleNode2.getNQPyClass(nQPyBlockCompiler).getJClassName());
    }

    public void gtEq(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.gtEqCmpInt(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.gtEqCmpDouble(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.gtEqCmpLong(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.gtEqCmpFloat(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 5: {
                this.gtEqCmpString(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 4: {
                this.gtEqCmpBoolean(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 6: {
                System.out.println("here " + this);
                this.gtEqCmpJava(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            default: {
                String string = "Cannot compare " + this + " and " + nQPyClass;
                throw ErrorFactory.createCompilerException(string);
            }
        }
    }

    public void gtEqCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("int");
    }

    public void gtEqCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("double");
    }

    public void gtEqCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("long");
    }

    public void gtEqCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("float");
    }

    public void gtEqCmpBoolean(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("boolean");
    }

    public void gtEqCmpString(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("java.lang.String");
    }

    public void gtEqCmpJava(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError(simpleNode2.getNQPyClass(nQPyBlockCompiler).getJClassName());
    }

    public void ltEq(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.ltEqCmpInt(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.ltEqCmpDouble(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.ltEqCmpLong(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.ltEqCmpFloat(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 5: {
                this.ltEqCmpString(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 4: {
                this.ltEqCmpBoolean(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            case 6: {
                this.ltEqCmpJava(simpleNode, simpleNode2, label, nQPyBlockCompiler);
                break;
            }
            default: {
                String string = "Cannot compare " + this + " and " + nQPyClass;
                throw ErrorFactory.createCompilerException(string);
            }
        }
    }

    public void ltEqCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("int");
    }

    public void ltEqCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("double");
    }

    public void ltEqCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("long");
    }

    public void ltEqCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("float");
    }

    public void ltEqCmpBoolean(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("boolean");
    }

    public void ltEqCmpString(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError("java.lang.String");
    }

    public void ltEqCmpJava(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwCmpError(simpleNode2.getNQPyClass(nQPyBlockCompiler).getJClassName());
    }

    public void add(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.addInt(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.addDouble(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.addLong(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.addFloat(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 5: {
                this.addString(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 4: {
                this.addBoolean(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            default: {
                this.throwArithError(nQPyClass.getJClassName());
            }
        }
    }

    public void addBoolean(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("boolean");
    }

    public void addInt(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("int");
    }

    public void addDouble(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("double");
    }

    public void addLong(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("long");
    }

    public void addFloat(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("float");
    }

    public void addString(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("java.lang.String");
    }

    public void sub(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.subInt(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.subDouble(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.subLong(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.subFloat(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            default: {
                this.throwArithError(nQPyClass.getJClassName());
            }
        }
    }

    public void subInt(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("int");
    }

    public void subDouble(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("double");
    }

    public void subLong(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("long");
    }

    public void subFloat(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("float");
    }

    public void mult(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.multInt(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.multDouble(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.multLong(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.multFloat(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 5: {
                this.multString(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            default: {
                this.throwArithError(nQPyClass.getJClassName());
            }
        }
    }

    public void multInt(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("int");
    }

    public void multDouble(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("double");
    }

    public void multLong(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("long");
    }

    public void multFloat(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("float");
    }

    public void multString(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("java.lang.String");
    }

    public void div(NQPyClass nQPyClass, SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        switch (nQPyClass.id()) {
            case 1: {
                this.divInt(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 2: {
                this.divDouble(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 0: {
                this.divLong(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            case 3: {
                this.divFloat(simpleNode, simpleNode2, nQPyBlockCompiler);
                break;
            }
            default: {
                this.throwArithError(nQPyClass.getJClassName());
            }
        }
    }

    public void divInt(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("int");
    }

    public void divDouble(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("double");
    }

    public void divLong(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("long");
    }

    public void divFloat(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("float");
    }

    public void divString(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError("java.lang.String");
    }

    public void neg(SimpleNode simpleNode, NQPyBlockCompiler nQPyBlockCompiler) {
        this.throwArithError();
    }
}

