/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.compiler;

import java.io.PrintStream;
import java.io.PrintWriter;
import uchicago.src.nqpy.compiler.AbstractCompilerException;

public class CompilerException
extends AbstractCompilerException {
    private Exception ex;
    private String message;

    public CompilerException(String string, Exception exception) {
        this.ex = exception;
        this.message = string;
    }

    public CompilerException(String string) {
        this.message = string;
    }

    public void resetMessage(String string) {
        this.message = string;
    }

    private String formatMessage() {
        StringBuffer stringBuffer = new StringBuffer("Block: ");
        stringBuffer.append(this.blockName);
        stringBuffer.append(", line: ");
        stringBuffer.append(this.lineNum);
        stringBuffer.append("\nCompiler Error: ");
        stringBuffer.append(this.message);
        stringBuffer.append("\n  ");
        stringBuffer.append(this.line);
        return stringBuffer.toString();
    }

    public void printSuperStackTrace() {
        super.printStackTrace(System.err);
    }

    public void printStackTrace() {
        System.out.println(this.formatMessage());
        if (this.ex != null) {
            this.ex.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(this.formatMessage());
        if (this.ex != null) {
            this.ex.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(this.formatMessage());
        if (this.ex != null) {
            this.ex.printStackTrace(printWriter);
        }
    }

    public String getMessage() {
        if (this.ex != null) {
            return this.formatMessage() + "\n" + this.ex.getMessage();
        }
        return this.formatMessage();
    }
}

