/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.compiler;

import com.go.trove.classfile.Label;
import uchicago.src.nqpy.compiler.AbstractEmitter;
import uchicago.src.nqpy.compiler.ErrorFactory;
import uchicago.src.nqpy.compiler.NQPyBlockCompiler;
import uchicago.src.nqpy.compiler.NQPyClass;
import uchicago.src.nqpy.compiler.NQPyClassFactory;
import uchicago.src.nqpy.parser.SimpleNode;

public class IntEmitter
extends AbstractEmitter {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$StringBuffer;

    public IntEmitter(NQPyClass nQPyClass) {
        super(nQPyClass);
    }

    public NQPyClass getArithResType() {
        return this.nqPyClass;
    }

    public NQPyClass getArithResType(NQPyClass nQPyClass) {
        switch (nQPyClass.id()) {
            case 1: {
                return NQPyClassFactory.makeIntegerClass();
            }
            case 2: {
                return NQPyClassFactory.makeDoubleClass();
            }
            case 0: {
                return NQPyClassFactory.makeLongClass();
            }
            case 3: {
                return NQPyClassFactory.makeFloatClass();
            }
            case 5: {
                return NQPyClassFactory.makeStringClass();
            }
        }
        String string = "Arithmetic operations not supported between " + this.nqPyClass.getJClassName() + " and " + nQPyClass.getJClassName();
        throw ErrorFactory.createCompilerException(string);
    }

    public void branchOnTrue(SimpleNode simpleNode, NQPyBlockCompiler nQPyBlockCompiler, Label label) {
        simpleNode.compile(nQPyBlockCompiler);
        nQPyBlockCompiler.emitNotEqZero(label);
    }

    public void branchOnFalse(SimpleNode simpleNode, NQPyBlockCompiler nQPyBlockCompiler, Label label) {
        simpleNode.compile(nQPyBlockCompiler);
        nQPyBlockCompiler.emitEqZero(label);
    }

    private void intOp(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        simpleNode.compile(nQPyBlockCompiler);
        simpleNode2.compile(nQPyBlockCompiler);
    }

    private void doubleOp(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        simpleNode.compile(nQPyBlockCompiler);
        nQPyBlockCompiler.emitPrimitiveConversion(Integer.TYPE, Double.TYPE);
        simpleNode2.compile(nQPyBlockCompiler);
    }

    private void floatOp(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        simpleNode.compile(nQPyBlockCompiler);
        nQPyBlockCompiler.emitPrimitiveConversion(Integer.TYPE, Float.TYPE);
        simpleNode2.compile(nQPyBlockCompiler);
    }

    private void longOp(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        simpleNode.compile(nQPyBlockCompiler);
        nQPyBlockCompiler.emitPrimitiveConversion(Integer.TYPE, Long.TYPE);
        simpleNode2.compile(nQPyBlockCompiler);
    }

    public void eqCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitIntComp(label, "==");
    }

    public void eqCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitDCMPL();
        nQPyBlockCompiler.emitEqZero(label);
    }

    public void eqCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitLCMP();
        nQPyBlockCompiler.emitEqZero(label);
    }

    public void eqCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitFCMPL();
        nQPyBlockCompiler.emitEqZero(label);
    }

    public void notEqCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitIntComp(label, "!=");
    }

    public void notEqCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitDCMPL();
        nQPyBlockCompiler.emitNotEqZero(label);
    }

    public void notEqCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitLCMP();
        nQPyBlockCompiler.emitNotEqZero(label);
    }

    public void notEqCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitFCMPL();
        nQPyBlockCompiler.emitNotEqZero(label);
    }

    public void gtCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitIntComp(label, ">");
    }

    public void gtCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitDCMPL();
        nQPyBlockCompiler.emitGtZero(label);
    }

    public void gtCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitLCMP();
        nQPyBlockCompiler.emitGtZero(label);
    }

    public void gtCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitFCMPL();
        nQPyBlockCompiler.emitGtZero(label);
    }

    public void gtEqCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitIntComp(label, ">=");
    }

    public void gtEqCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitDCMPL();
        nQPyBlockCompiler.emitGtEqZero(label);
    }

    public void gtEqCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitLCMP();
        nQPyBlockCompiler.emitGtEqZero(label);
    }

    public void gtEqCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitFCMPL();
        nQPyBlockCompiler.emitGtEqZero(label);
    }

    public void ltCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitIntComp(label, "<");
    }

    public void ltCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitDCMPL();
        nQPyBlockCompiler.emitLtZero(label);
    }

    public void ltCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitLCMP();
        nQPyBlockCompiler.emitLtZero(label);
    }

    public void ltCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitFCMPL();
        nQPyBlockCompiler.emitLtZero(label);
    }

    public void ltEqCmpInt(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitIntComp(label, "<=");
    }

    public void ltEqCmpDouble(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitDCMPL();
        nQPyBlockCompiler.emitLtEqZero(label);
    }

    public void ltEqCmpLong(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitLCMP();
        nQPyBlockCompiler.emitLtEqZero(label);
    }

    public void ltEqCmpFloat(SimpleNode simpleNode, SimpleNode simpleNode2, Label label, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.emitFCMPL();
        nQPyBlockCompiler.emitLtEqZero(label);
    }

    public void addInt(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.intAdd();
    }

    public void addDouble(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.doubleAdd();
    }

    public void addLong(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.longAdd();
    }

    public void addFloat(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.floatAdd();
    }

    public void addString(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        simpleNode.compile(nQPyBlockCompiler);
        nQPyBlockCompiler.emitInvokeStatic("java.lang.String", "valueOf", class$java$lang$String == null ? (class$java$lang$String = IntEmitter.class$("java.lang.String")) : class$java$lang$String, new Class[]{Integer.TYPE});
        simpleNode2.compile(nQPyBlockCompiler);
        nQPyBlockCompiler.emitInvokeVirtual("java.lang.String", "concat", class$java$lang$String == null ? (class$java$lang$String = IntEmitter.class$("java.lang.String")) : class$java$lang$String, new Class[]{class$java$lang$String == null ? (class$java$lang$String = IntEmitter.class$("java.lang.String")) : class$java$lang$String});
    }

    public void subInt(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.intSub();
    }

    public void subDouble(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.doubleSub();
    }

    public void subLong(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.longSub();
    }

    public void subFloat(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.floatSub();
    }

    public void multInt(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.intMult();
    }

    public void multDouble(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.doubleMult();
    }

    public void multLong(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.longMult();
    }

    public void multFloat(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.floatMult();
    }

    public void multString(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        nQPyBlockCompiler.emitInt(0);
        String string = nQPyBlockCompiler.createTmp(Integer.TYPE);
        nQPyBlockCompiler.emitStoreTmp(string);
        simpleNode.compile(nQPyBlockCompiler);
        String string2 = nQPyBlockCompiler.createTmp(Integer.TYPE);
        nQPyBlockCompiler.emitStoreTmp(string2);
        simpleNode2.compile(nQPyBlockCompiler);
        String string3 = nQPyBlockCompiler.createTmp(class$java$lang$String == null ? (class$java$lang$String = IntEmitter.class$("java.lang.String")) : class$java$lang$String);
        nQPyBlockCompiler.emitStoreTmp(string3);
        nQPyBlockCompiler.emitNew(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = IntEmitter.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        nQPyBlockCompiler.emitDup();
        nQPyBlockCompiler.emitConstructor("java.lang.StringBuffer", new Class[0]);
        String string4 = nQPyBlockCompiler.createTmp(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = IntEmitter.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        nQPyBlockCompiler.emitStoreTmp(string4);
        Label label = nQPyBlockCompiler.createLabel();
        Label label2 = nQPyBlockCompiler.createLabel();
        Label label3 = nQPyBlockCompiler.createLabel();
        nQPyBlockCompiler.emitGoto(label);
        label3.setLocation();
        nQPyBlockCompiler.emitLoadTmp(string4);
        nQPyBlockCompiler.emitLoadTmp(string3);
        nQPyBlockCompiler.emitInvokeVirtual("java.lang.StringBuffer", "append", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = IntEmitter.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer, new Class[]{class$java$lang$String == null ? (class$java$lang$String = IntEmitter.class$("java.lang.String")) : class$java$lang$String});
        nQPyBlockCompiler.emitPop();
        nQPyBlockCompiler.emitIncTmp(string, 1);
        label.setLocation();
        nQPyBlockCompiler.emitLoadTmp(string);
        nQPyBlockCompiler.emitLoadTmp(string2);
        nQPyBlockCompiler.emitIntComp(label3, "<");
        label2.setLocation();
        nQPyBlockCompiler.emitLoadTmp(string4);
        nQPyBlockCompiler.emitInvokeVirtual("java.lang.StringBuffer", "toString", class$java$lang$String == null ? (class$java$lang$String = IntEmitter.class$("java.lang.String")) : class$java$lang$String, new Class[0]);
    }

    public void divInt(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.intOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.intDiv();
    }

    public void divDouble(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.doubleOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.doubleDiv();
    }

    public void divLong(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.longOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.longDiv();
    }

    public void divFloat(SimpleNode simpleNode, SimpleNode simpleNode2, NQPyBlockCompiler nQPyBlockCompiler) {
        this.floatOp(simpleNode, simpleNode2, nQPyBlockCompiler);
        nQPyBlockCompiler.floatDiv();
    }

    public void neg(SimpleNode simpleNode, NQPyBlockCompiler nQPyBlockCompiler) {
        simpleNode.compile(nQPyBlockCompiler);
        nQPyBlockCompiler.intNeg();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

