/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.compiler;

import uchicago.src.nqpy.compiler.ErrorMethodCall;
import uchicago.src.nqpy.compiler.MethodCall;
import uchicago.src.nqpy.compiler.NQPyClass;
import uchicago.src.nqpy.compiler.NQPyClassFactory;

class JavaArgs {
    NQPyClass[] args;
    Class decClass;
    int mods;
    String decClassName;

    public JavaArgs(Class[] classArray, int n) {
        int n2 = classArray.length;
        this.args = new NQPyClass[n2];
        for (int i = 0; i < n2; ++i) {
            Class clazz = classArray[i];
            this.args[i] = NQPyClassFactory.makeNQPyClass(clazz);
        }
        this.mods = n;
    }

    public JavaArgs(String[] stringArray, int n) {
        int n2 = stringArray.length;
        this.args = new NQPyClass[n2];
        for (int i = 0; i < n2; ++i) {
            this.args[i] = NQPyClassFactory.makeNQPyClass(stringArray[i]);
        }
        this.mods = n;
    }

    public void setDeclaringClass(Class clazz) {
        this.decClass = clazz;
    }

    public void setDeclaringClass(String string) {
        this.decClassName = string;
    }

    public int size() {
        return this.args.length;
    }

    public MethodCall methodCall(NQPyClass[] nQPyClassArray, Class clazz) {
        MethodCall methodCall = new MethodCall();
        methodCall.setRetType(clazz);
        return this.searchForMethod(nQPyClassArray, methodCall);
    }

    public MethodCall methodCall(NQPyClass[] nQPyClassArray, String string) {
        MethodCall methodCall = new MethodCall();
        methodCall.setRetType(string);
        return this.searchForMethod(nQPyClassArray, methodCall);
    }

    private MethodCall searchForMethod(NQPyClass[] nQPyClassArray, MethodCall methodCall) {
        for (int i = 0; i < nQPyClassArray.length; ++i) {
            NQPyClass nQPyClass = nQPyClassArray[i].match(this.args[i]);
            if (nQPyClass == null) {
                return new ErrorMethodCall();
            }
            if (nQPyClass.equals(nQPyClassArray[i])) continue;
            methodCall.addArgConversion(i, nQPyClass);
        }
        methodCall.setValid(true);
        methodCall.setArgs(this.args);
        methodCall.setModifiers(this.mods);
        if (this.decClass == null) {
            methodCall.setDeclaringClass(NQPyClassFactory.makeNQPyClass(this.decClassName));
        } else {
            methodCall.setDeclaringClass(NQPyClassFactory.makeNQPyClass(this.decClass));
        }
        return methodCall;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < this.args.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.args[i].getJClassName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

