/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.compiler;

import ViolinStrings.Strings;
import com.go.trove.classfile.AccessFlags;
import com.go.trove.classfile.ClassFile;
import com.go.trove.classfile.CodeBuilder;
import com.go.trove.classfile.Label;
import com.go.trove.classfile.LocalVariable;
import com.go.trove.classfile.Location;
import com.go.trove.classfile.MethodInfo;
import com.go.trove.classfile.TypeDescriptor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import uchicago.src.nqpy.compiler.CompilerException;
import uchicago.src.nqpy.compiler.CompilerUtil;
import uchicago.src.nqpy.compiler.ErrorFactory;
import uchicago.src.nqpy.compiler.FieldCall;
import uchicago.src.nqpy.compiler.MethodCall;
import uchicago.src.nqpy.compiler.NQPyClass;
import uchicago.src.nqpy.compiler.NQPyClassFactory;
import uchicago.src.nqpy.compiler.NQPyDynamicClass;
import uchicago.src.nqpy.compiler.NullNQPyClass;
import uchicago.src.nqpy.compiler.ParserException;
import uchicago.src.nqpy.parser.NQPyParser;
import uchicago.src.nqpy.parser.ParseException;
import uchicago.src.nqpy.parser.SimpleNode;
import uchicago.src.nqpy.util.NQPyClassLoader;
import uchicago.src.sim.engine.BasicAction;

public class NQPyBlockCompiler {
    public static final NQPyClass NULL_NQPyClass = new NullNQPyClass();
    private int tmpCount = 0;
    private ClassFile cf;
    private CodeBuilder builder;
    private HashMap localVars = new HashMap();
    private HashMap tmps = new HashMap();
    private HashSet classLookup = new HashSet();
    private boolean classMethMade = false;
    private Stack loopData = new Stack();
    private NQPyClass returnType = NQPyClassFactory.makeVoidClass();
    private boolean returnNotFound = true;
    static /* synthetic */ Class class$uchicago$src$sim$engine$BasicAction;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$NoClassDefFoundError;
    static /* synthetic */ Class class$java$io$PrintStream;
    static /* synthetic */ Class class$java$lang$Object;

    public NQPyBlockCompiler(String string) throws NoSuchMethodException {
        this.cf = new ClassFile(string, class$uchicago$src$sim$engine$BasicAction == null ? (class$uchicago$src$sim$engine$BasicAction = NQPyBlockCompiler.class$("uchicago.src.sim.engine.BasicAction")) : class$uchicago$src$sim$engine$BasicAction);
        this.makeConstructor();
        this.initExecuteBuilder();
    }

    public NQPyBlockCompiler(Method method, ClassFile classFile) {
        this.cf = classFile;
        MethodInfo methodInfo = classFile.addMethod(method);
        this.builder = new CodeBuilder(methodInfo);
    }

    public NQPyBlockCompiler(String string, ClassFile classFile) {
        this.cf = classFile;
        this.createPublicMethod(string, null, null);
    }

    public NQPyBlockCompiler(String string, Class clazz, ClassFile classFile) {
        this.cf = classFile;
        this.createPublicMethod(string, clazz, null);
    }

    private void createPublicMethod(String string, Class clazz, Class[] classArray) {
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPublic(true);
        TypeDescriptor typeDescriptor = null;
        if (clazz != null) {
            typeDescriptor = new TypeDescriptor(clazz);
            this.returnType = NQPyClassFactory.makeNQPyClass(clazz);
        }
        MethodInfo methodInfo = this.cf.addMethod(accessFlags, string, typeDescriptor, CompilerUtil.makeTypeDescriptors(classArray));
        this.builder = new CodeBuilder(methodInfo);
    }

    private void makeConstructor() {
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPublic(true);
        MethodInfo methodInfo = this.cf.addConstructor(accessFlags, null);
        this.builder = new CodeBuilder(methodInfo);
        this.builder.loadThis();
        this.builder.invokeSuperConstructor(null);
        this.builder.returnVoid();
    }

    private void initExecuteBuilder() throws NoSuchMethodException {
        Method method = (class$uchicago$src$sim$engine$BasicAction == null ? (class$uchicago$src$sim$engine$BasicAction = NQPyBlockCompiler.class$("uchicago.src.sim.engine.BasicAction")) : class$uchicago$src$sim$engine$BasicAction).getMethod("execute", new Class[0]);
        MethodInfo methodInfo = this.cf.addMethod(method);
        this.builder = new CodeBuilder(methodInfo);
    }

    public void setBlockName(String string) {
        ErrorFactory.setBlockName(string);
    }

    public void addImport(String string) {
        NQPyClassFactory.addImport(string);
    }

    public void setSelf(NQPyDynamicClass nQPyDynamicClass) {
        this.localVars.put("self", new VarClass(null, nQPyDynamicClass));
    }

    public void setReturnType(Class clazz) {
        this.returnType = NQPyClassFactory.makeNQPyClass(clazz);
    }

    public NQPyClass getReturnType() {
        return this.returnType;
    }

    public void setReturnNotFound(boolean bl) {
        this.returnNotFound = bl;
    }

    public NQPyClass getNQPyClassForVar(String string) {
        VarClass varClass = (VarClass)this.localVars.get(string);
        if (varClass == null || varClass.nqclass == null) {
            return NULL_NQPyClass;
        }
        return varClass.nqclass;
    }

    public boolean isLocalVar(String string) {
        return this.localVars.containsKey(string);
    }

    public void pushLoopData(Label label, Label label2, Label label3) {
        this.loopData.push(new LoopData(label, label2, label3));
    }

    public void popLoopData() {
        this.loopData.pop();
    }

    public int getLoopDataSize() {
        return this.loopData.size();
    }

    private void addClassLookup(NQPyClass nQPyClass) {
        String string = Strings.change(nQPyClass.getJClassName(), ".", "$");
        if (!this.classLookup.contains("class$L" + string)) {
            AccessFlags accessFlags = new AccessFlags();
            accessFlags.setPrivate(true);
            accessFlags.setStatic(true);
            this.cf.addField(accessFlags, "class$L" + string, new TypeDescriptor(class$java$lang$Class == null ? (class$java$lang$Class = NQPyBlockCompiler.class$("java.lang.Class")) : class$java$lang$Class));
            if (!this.classMethMade) {
                this.makeClassLookupMethod();
            }
            this.classLookup.add("class$L" + string);
        }
    }

    private void makeClassLookupMethod() {
        AccessFlags accessFlags = new AccessFlags();
        accessFlags.setPrivate(true);
        accessFlags.setStatic(true);
        MethodInfo methodInfo = this.cf.addMethod(accessFlags, "class$", new TypeDescriptor(class$java$lang$Class == null ? (class$java$lang$Class = NQPyBlockCompiler.class$("java.lang.Class")) : class$java$lang$Class), new TypeDescriptor[]{new TypeDescriptor(class$java$lang$String == null ? (class$java$lang$String = NQPyBlockCompiler.class$("java.lang.String")) : class$java$lang$String)});
        methodInfo.markSynthetic();
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        Label label = codeBuilder.createLabel();
        Label label2 = codeBuilder.createLabel();
        label.setLocation();
        codeBuilder.loadLocal(codeBuilder.getParameters()[0]);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{new TypeDescriptor(class$java$lang$String == null ? (class$java$lang$String = NQPyBlockCompiler.class$("java.lang.String")) : class$java$lang$String)};
        codeBuilder.invokeStatic("java.lang.Class", "forName", new TypeDescriptor(class$java$lang$Class == null ? (class$java$lang$Class = NQPyBlockCompiler.class$("java.lang.Class")) : class$java$lang$Class), typeDescriptorArray);
        codeBuilder.returnValue(class$java$lang$Class == null ? (class$java$lang$Class = NQPyBlockCompiler.class$("java.lang.Class")) : class$java$lang$Class);
        label2.setLocation();
        codeBuilder.exceptionHandler((Location)label, (Location)label2, "java.lang.ClassNotFoundException");
        TypeDescriptor typeDescriptor = new TypeDescriptor("java.lang.ClassNotFoundException");
        LocalVariable localVariable = codeBuilder.createLocalVariable("ex", typeDescriptor);
        codeBuilder.storeLocal(localVariable);
        codeBuilder.newObject(new TypeDescriptor(class$java$lang$NoClassDefFoundError == null ? (class$java$lang$NoClassDefFoundError = NQPyBlockCompiler.class$("java.lang.NoClassDefFoundError")) : class$java$lang$NoClassDefFoundError));
        codeBuilder.dup();
        codeBuilder.loadLocal(localVariable);
        codeBuilder.invokeVirtual("java.lang.Throwable", "getMessage", new TypeDescriptor(class$java$lang$String == null ? (class$java$lang$String = NQPyBlockCompiler.class$("java.lang.String")) : class$java$lang$String), null);
        codeBuilder.invokeConstructor("java.lang.NoClassDefFoundError", CompilerUtil.makeTypeDescriptors(class$java$lang$String == null ? (class$java$lang$String = NQPyBlockCompiler.class$("java.lang.String")) : class$java$lang$String));
        codeBuilder.throwObject();
        this.classMethMade = true;
    }

    public void emitClassLookup(NQPyClass nQPyClass) {
        this.addClassLookup(nQPyClass);
        TypeDescriptor typeDescriptor = new TypeDescriptor(class$java$lang$Class == null ? (class$java$lang$Class = NQPyBlockCompiler.class$("java.lang.Class")) : class$java$lang$Class);
        String string = "class$L" + Strings.change(nQPyClass.getJClassName(), ".", "$");
        this.builder.loadStaticField(string, typeDescriptor);
        Label label = this.builder.createLabel();
        Label label2 = this.builder.createLabel();
        this.builder.ifNullBranch((Location)label, true);
        this.builder.loadStaticField(string, typeDescriptor);
        this.builder.branch((Location)label2);
        label.setLocation();
        this.builder.loadConstant(nQPyClass.getJClassName());
        this.builder.invokeStatic("class$", typeDescriptor, CompilerUtil.makeTypeDescriptors(class$java$lang$String == null ? (class$java$lang$String = NQPyBlockCompiler.class$("java.lang.String")) : class$java$lang$String));
        this.builder.dup();
        this.builder.storeStaticField(string, typeDescriptor);
        label2.setLocation();
    }

    public void emitCast(NQPyClass nQPyClass) {
        this.builder.checkCast(nQPyClass.makeTypeDescriptor());
    }

    public void emitBreak() {
        LoopData loopData = (LoopData)this.loopData.peek();
        this.builder.branch((Location)loopData.end);
    }

    public void emitContinue() {
        LoopData loopData = (LoopData)this.loopData.peek();
        this.builder.branch((Location)loopData.start);
    }

    public void emitReturn(NQPyClass nQPyClass) {
        if (nQPyClass.id() == 8) {
            this.builder.returnVoid();
        } else {
            this.builder.returnValue(nQPyClass.getJClass());
        }
    }

    public void createMethodParams(ArrayList arrayList) {
        LocalVariable[] localVariableArray = this.builder.getParameters();
        if (arrayList.size() != localVariableArray.length) {
            String string = "Internal compiler error; invalid number of names passed to createMethodParams";
            throw ErrorFactory.createCompilerException(string);
        }
        for (int i = 0; i < localVariableArray.length; ++i) {
            String string = (String)arrayList.get(i);
            LocalVariable localVariable = localVariableArray[i];
            NQPyClass nQPyClass = NQPyClassFactory.makeNQPyClass(localVariable.getType().getClassName());
            this.localVars.put(string, new VarClass(localVariable, nQPyClass));
            localVariable.setName(string);
        }
    }

    public NQPyClass emitLocalVar(String string, NQPyClass nQPyClass) {
        VarClass varClass = (VarClass)this.localVars.get(string);
        if (varClass == null) {
            LocalVariable localVariable = this.builder.createLocalVariable(string, nQPyClass.makeTypeDescriptor());
            this.localVars.put(string, new VarClass(localVariable, nQPyClass));
            return nQPyClass;
        }
        if (varClass.nqclass.isAssignableFrom(nQPyClass)) {
            return varClass.nqclass;
        }
        return NULL_NQPyClass;
    }

    public void emitLocalVarNoCheck(String string, NQPyClass nQPyClass) {
        LocalVariable localVariable = this.builder.createLocalVariable(string, nQPyClass.makeTypeDescriptor());
        this.localVars.put(string, new VarClass(localVariable, nQPyClass));
    }

    public void emitStoreLocal(String string) {
        LocalVariable localVariable = ((VarClass)this.localVars.get((Object)string)).variable;
        this.builder.storeLocal(localVariable);
    }

    public void emitLoadLocalVar(String string) {
        if (string.equals("self")) {
            this.builder.loadThis();
        } else {
            LocalVariable localVariable = ((VarClass)this.localVars.get((Object)string)).variable;
            this.builder.loadLocal(localVariable);
        }
    }

    public synchronized String createTmp(Class clazz) {
        String string = "__tmp__" + this.tmpCount++;
        LocalVariable localVariable = this.builder.createLocalVariable(string, new TypeDescriptor(clazz));
        this.tmps.put(string, localVariable);
        return string;
    }

    public void emitStoreTmp(String string) {
        LocalVariable localVariable = (LocalVariable)this.tmps.get(string);
        if (localVariable == null) {
            String string2 = "Internal compiler error, undefined tmp variable " + string;
            throw ErrorFactory.createCompilerException(string2);
        }
        this.builder.storeLocal(localVariable);
    }

    public void emitLoadTmp(String string) {
        LocalVariable localVariable = (LocalVariable)this.tmps.get(string);
        if (localVariable == null) {
            String string2 = "Internal compiler error, undefined tmp variable " + string;
            throw ErrorFactory.createCompilerException(string2);
        }
        this.builder.loadLocal(localVariable);
    }

    public void emitIncTmp(String string, int n) {
        LocalVariable localVariable = (LocalVariable)this.tmps.get(string);
        if (localVariable == null) {
            String string2 = "Internal compiler error, undefined tmp variable " + string;
            throw ErrorFactory.createCompilerException(string2);
        }
        this.builder.integerIncrement(localVariable, n);
    }

    public void emitInvokeStatic(String string, String string2, NQPyClass nQPyClass, Class[] classArray) {
        TypeDescriptor typeDescriptor = nQPyClass.makeTypeDescriptor();
        TypeDescriptor[] typeDescriptorArray = CompilerUtil.makeTypeDescriptors(classArray);
        this.builder.invokeStatic(string, string2, typeDescriptor, typeDescriptorArray);
    }

    public void emitInvokeStatic(String string, String string2, Class clazz, Class[] classArray) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(clazz);
        TypeDescriptor[] typeDescriptorArray = CompilerUtil.makeTypeDescriptors(classArray);
        this.builder.invokeStatic(string, string2, typeDescriptor, typeDescriptorArray);
    }

    public void emitInvokeStatic(MethodCall methodCall) {
        String string = methodCall.getDeclaringClass().getJClassName();
        String string2 = methodCall.getMethodName();
        TypeDescriptor typeDescriptor = methodCall.getRetType().makeTypeDescriptor();
        TypeDescriptor[] typeDescriptorArray = CompilerUtil.makeTypeDescriptors(methodCall.getArgs());
        this.builder.invokeStatic(string, string2, typeDescriptor, typeDescriptorArray);
    }

    public void emitInvokeVQuickNoRet(String string, String string2, TypeDescriptor[] typeDescriptorArray) {
        this.builder.invokeVirtual(string, string2, null, typeDescriptorArray);
    }

    public void emitInvokeVirtual(String string, String string2, Class clazz, Class[] classArray) {
        TypeDescriptor typeDescriptor = new TypeDescriptor(clazz);
        TypeDescriptor[] typeDescriptorArray = CompilerUtil.makeTypeDescriptors(classArray);
        this.builder.invokeVirtual(string, string2, typeDescriptor, typeDescriptorArray);
    }

    public void emitInvokeMethod(MethodCall methodCall) {
        Class clazz = methodCall.getDeclaringClass().getJClass();
        if (clazz == null) {
            this.emitInvokeVirtual(methodCall);
        } else if (methodCall.isStatic()) {
            this.emitInvokeStatic(methodCall);
        } else if (clazz.isInterface()) {
            this.emitInvokeInterface(methodCall);
        } else {
            this.emitInvokeVirtual(methodCall);
        }
    }

    public void emitInvokeVirtual(MethodCall methodCall) {
        String string = methodCall.getDeclaringClass().getJClassName();
        String string2 = methodCall.getMethodName();
        TypeDescriptor typeDescriptor = methodCall.getRetType().makeTypeDescriptor();
        TypeDescriptor[] typeDescriptorArray = CompilerUtil.makeTypeDescriptors(methodCall.getArgs());
        this.builder.invokeVirtual(string, string2, typeDescriptor, typeDescriptorArray);
    }

    public void emitInvokeInterface(MethodCall methodCall) {
        String string = methodCall.getDeclaringClass().getJClassName();
        String string2 = methodCall.getMethodName();
        TypeDescriptor typeDescriptor = methodCall.getRetType().makeTypeDescriptor();
        TypeDescriptor[] typeDescriptorArray = CompilerUtil.makeTypeDescriptors(methodCall.getArgs());
        this.builder.invokeInterface(string, string2, typeDescriptor, typeDescriptorArray);
    }

    public void emitConstructor(MethodCall methodCall) {
        String string = methodCall.getDeclaringClass().getJClassName();
        TypeDescriptor[] typeDescriptorArray = CompilerUtil.makeTypeDescriptors(methodCall.getArgs());
        this.builder.invokeConstructor(string, typeDescriptorArray);
    }

    public void emitConstructor(String string, Class[] classArray) {
        TypeDescriptor[] typeDescriptorArray = CompilerUtil.makeTypeDescriptors(classArray);
        this.builder.invokeConstructor(string, typeDescriptorArray);
    }

    public void emitLoadField(FieldCall fieldCall) {
        if (fieldCall.isStatic()) {
            this.builder.loadStaticField(fieldCall.getDeclaringClassName(), fieldCall.getFieldName(), fieldCall.getFieldType().makeTypeDescriptor());
        } else {
            this.builder.loadField(fieldCall.getDeclaringClassName(), fieldCall.getFieldName(), fieldCall.getFieldType().makeTypeDescriptor());
        }
    }

    public void emitStoreField(FieldCall fieldCall) {
        if (fieldCall.isStatic()) {
            this.builder.storeStaticField(fieldCall.getDeclaringClassName(), fieldCall.getFieldName(), fieldCall.getFieldType().makeTypeDescriptor());
        } else {
            this.builder.storeField(fieldCall.getDeclaringClassName(), fieldCall.getFieldName(), fieldCall.getFieldType().makeTypeDescriptor());
        }
    }

    public void intAdd() {
        this.builder.math((byte)96);
    }

    public void intSub() {
        this.builder.math((byte)100);
    }

    public void intMult() {
        this.builder.math((byte)104);
    }

    public void intDiv() {
        this.builder.math((byte)108);
    }

    public void intNeg() {
        this.builder.math((byte)116);
    }

    public void doubleAdd() {
        this.builder.math((byte)99);
    }

    public void doubleSub() {
        this.builder.math((byte)103);
    }

    public void doubleMult() {
        this.builder.math((byte)107);
    }

    public void doubleDiv() {
        this.builder.math((byte)111);
    }

    public void doubleNeg() {
        this.builder.math((byte)119);
    }

    public void floatAdd() {
        this.builder.math((byte)98);
    }

    public void floatSub() {
        this.builder.math((byte)102);
    }

    public void floatMult() {
        this.builder.math((byte)106);
    }

    public void floatDiv() {
        this.builder.math((byte)110);
    }

    public void floatNeg() {
        this.builder.math((byte)118);
    }

    public void longAdd() {
        this.builder.math((byte)97);
    }

    public void longSub() {
        this.builder.math((byte)101);
    }

    public void longMult() {
        this.builder.math((byte)105);
    }

    public void longDiv() {
        this.builder.math((byte)109);
    }

    public void longNeg() {
        this.builder.math((byte)117);
    }

    public void emitNew(NQPyClass nQPyClass) {
        this.builder.newObject(nQPyClass.makeTypeDescriptor());
    }

    public void emitNew(Class clazz) {
        this.builder.newObject(new TypeDescriptor(clazz));
    }

    public void emitDup() {
        this.builder.dup();
    }

    public void emitPop() {
        this.builder.pop();
    }

    public void emitPrimitiveConversion(Class clazz, Class clazz2) {
        this.builder.convert(clazz, clazz2);
    }

    public Label createLabel() {
        return this.builder.createLabel();
    }

    public void emitDCMPL() {
        this.builder.math((byte)-105);
    }

    public void emitFCMPL() {
        this.builder.math((byte)-107);
    }

    public void emitLCMP() {
        this.builder.math((byte)-108);
    }

    public void emitIfNotNull(Label label) {
        this.builder.ifNullBranch((Location)label, false);
    }

    public void emitIfNull(Label label) {
        this.builder.ifNullBranch((Location)label, true);
    }

    public void emitEqZero(Label label) {
        this.builder.ifZeroComparisonBranch((Location)label, "==");
    }

    public void emitNotEqZero(Label label) {
        this.builder.ifZeroComparisonBranch((Location)label, "!=");
    }

    public void emitGtZero(Label label) {
        this.builder.ifZeroComparisonBranch((Location)label, ">");
    }

    public void emitGtEqZero(Label label) {
        this.builder.ifZeroComparisonBranch((Location)label, ">=");
    }

    public void emitLtZero(Label label) {
        this.builder.ifZeroComparisonBranch((Location)label, "<");
    }

    public void emitLtEqZero(Label label) {
        this.builder.ifZeroComparisonBranch((Location)label, "<=");
    }

    public void emitIntComp(Label label, String string) {
        this.builder.ifComparisonBranch((Location)label, string);
    }

    public void emitGoto(Label label) {
        this.builder.branch((Location)label);
    }

    public void emitIntToBoolean() {
        Label label = this.builder.createLabel();
        Label label2 = this.builder.createLabel();
        this.builder.ifZeroComparisonBranch((Location)label, "!=");
        this.builder.loadConstant(0);
        this.builder.branch((Location)label2);
        label.setLocation();
        this.builder.loadConstant(1);
        label2.setLocation();
    }

    public void emitDoubleToBoolean() {
        this.builder.convert(Double.TYPE, Integer.TYPE);
        this.emitIntToBoolean();
    }

    public void emitFloatToBoolean() {
        this.builder.convert(Float.TYPE, Integer.TYPE);
        this.emitIntToBoolean();
    }

    public void emitLongToBoolean() {
        this.builder.convert(Long.TYPE, Integer.TYPE);
        this.emitIntToBoolean();
    }

    public void emitString(String string) {
        this.builder.loadConstant(string);
    }

    public void emitInt(int n) {
        this.builder.loadConstant(n);
    }

    public void emitDouble(double d) {
        this.builder.loadConstant(d);
    }

    public void emitLong(long l) {
        this.builder.loadConstant(l);
    }

    public void emitFloat(float f) {
        this.builder.loadConstant(f);
    }

    public void emitPrintStart() {
        this.builder.loadStaticField("java.lang.System", "out", new TypeDescriptor(class$java$io$PrintStream == null ? (class$java$io$PrintStream = NQPyBlockCompiler.class$("java.io.PrintStream")) : class$java$io$PrintStream));
    }

    public void emitPrintEnd(NQPyClass nQPyClass) {
        TypeDescriptor[] typeDescriptorArray = nQPyClass.id() == 6 ? CompilerUtil.makeTypeDescriptors(class$java$lang$Object == null ? (class$java$lang$Object = NQPyBlockCompiler.class$("java.lang.Object")) : class$java$lang$Object) : CompilerUtil.makeTypeDescriptors(nQPyClass);
        this.emitInvokeVQuickNoRet("java.io.PrintStream", "print", typeDescriptorArray);
    }

    public void emitPrintlnEnd(NQPyClass nQPyClass) {
        TypeDescriptor[] typeDescriptorArray = nQPyClass.id() == 6 ? CompilerUtil.makeTypeDescriptors(class$java$lang$Object == null ? (class$java$lang$Object = NQPyBlockCompiler.class$("java.lang.Object")) : class$java$lang$Object) : CompilerUtil.makeTypeDescriptors(nQPyClass);
        this.emitInvokeVQuickNoRet("java.io.PrintStream", "println", typeDescriptorArray);
    }

    public void compile(String string) {
        StringReader stringReader = new StringReader(string);
        NQPyParser nQPyParser = new NQPyParser(stringReader);
        ErrorFactory.setCurNode(null);
        ErrorFactory.setCode(string);
        try {
            SimpleNode simpleNode = nQPyParser.file_input();
            simpleNode.compile(this);
            if (this.returnType != NQPyClassFactory.makeVoidClass() && this.returnNotFound) {
                ErrorFactory.setCurNode(simpleNode);
                String string2 = "Method must return " + this.returnType.getJClassName();
                throw ErrorFactory.createCompilerException(string2);
            }
            if (this.returnType == NQPyClassFactory.makeVoidClass()) {
                this.builder.returnVoid();
            }
        }
        catch (ParseException parseException) {
            throw ErrorFactory.createParserException(parseException);
        }
    }

    public void execute() {
        NQPyClassLoader nQPyClassLoader = new NQPyClassLoader(this.getClass().getClassLoader());
        nQPyClassLoader.addClass("BCTest", this.cf);
        nQPyClassLoader.writeClass("BCTest", "/home/nick/tmp");
        try {
            Class<?> clazz = nQPyClassLoader.loadClass(this.cf.getClassName());
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            BasicAction basicAction = (BasicAction)constructor.newInstance(new Object[0]);
            basicAction.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            NQPyBlockCompiler nQPyBlockCompiler = new NQPyBlockCompiler("BCTest");
            ErrorFactory.setBlockName(stringArray[0]);
            nQPyBlockCompiler.compile(stringBuffer.toString());
            nQPyBlockCompiler.execute();
        }
        catch (CompilerException compilerException) {
            compilerException.printStackTrace();
        }
        catch (ParserException parserException) {
            System.out.println(parserException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LoopData {
        Label start;
        Label end;
        Label check;

        public LoopData(Label label, Label label2, Label label3) {
            this.start = label;
            this.end = label2;
            this.check = label3;
        }
    }

    class VarClass {
        LocalVariable variable;
        NQPyClass nqclass;

        public VarClass(LocalVariable localVariable, NQPyClass nQPyClass) {
            this.variable = localVariable;
            this.nqclass = nQPyClass;
        }
    }
}

