/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import uchicago.src.nqpy.compiler.NQPyBooleanClass;
import uchicago.src.nqpy.compiler.NQPyClass;
import uchicago.src.nqpy.compiler.NQPyDoubleClass;
import uchicago.src.nqpy.compiler.NQPyDynamicClass;
import uchicago.src.nqpy.compiler.NQPyFloatClass;
import uchicago.src.nqpy.compiler.NQPyIntClass;
import uchicago.src.nqpy.compiler.NQPyJavaClass;
import uchicago.src.nqpy.compiler.NQPyLongClass;
import uchicago.src.nqpy.compiler.NQPyStringClass;
import uchicago.src.nqpy.compiler.NQPyVoid;

public class NQPyClassFactory {
    private static final String STRING = "java.lang.String";
    private static final String LONG = "long";
    private static final String DOUBLE = "double";
    private static final String INT = "int";
    private static final String FLOAT = "float";
    private static final String BOOLEAN = "boolean";
    private static final String VOID = "void";
    private static HashMap cache = new HashMap();
    private static NQPyClass voidClass = new NQPyVoid();
    private static ArrayList imports = new ArrayList();
    private static ClassLoader clazzLoader = (class$uchicago$src$nqpy$compiler$NQPyClassFactory == null ? (class$uchicago$src$nqpy$compiler$NQPyClassFactory = NQPyClassFactory.class$("uchicago.src.nqpy.compiler.NQPyClassFactory")) : class$uchicago$src$nqpy$compiler$NQPyClassFactory).getClassLoader();
    static /* synthetic */ Class class$uchicago$src$nqpy$compiler$NQPyClassFactory;

    private NQPyClassFactory() {
    }

    public static void setClassLoader(ClassLoader classLoader) {
        clazzLoader = classLoader;
    }

    public static void addDynamicType(String string, NQPyDynamicClass nQPyDynamicClass) {
        cache.put(string, nQPyDynamicClass);
    }

    public static void removeDynamicType(String string) {
        cache.remove(string);
        if (string.lastIndexOf(".") != -1) {
            cache.remove(string.substring(string.lastIndexOf(".") + 1, string.length()));
        }
    }

    public static void addImport(String string) {
        if (string.endsWith("*")) {
            imports.add(string.substring(0, string.length() - 1));
        } else {
            NQPyClassFactory.makeJavaClass(string);
            if (string.indexOf(".") != -1) {
                imports.add(string.substring(0, string.lastIndexOf(".") + 1));
            } else {
                imports.add(string);
            }
        }
    }

    public static NQPyClass makeStringClass() {
        NQPyClass nQPyClass = (NQPyClass)cache.get(STRING);
        if (nQPyClass == null) {
            nQPyClass = new NQPyStringClass();
            cache.put(STRING, nQPyClass);
        }
        return nQPyClass;
    }

    public static NQPyClass makeBooleanClass() {
        NQPyClass nQPyClass = (NQPyClass)cache.get(BOOLEAN);
        if (nQPyClass == null) {
            nQPyClass = new NQPyBooleanClass();
            cache.put(BOOLEAN, nQPyClass);
        }
        return nQPyClass;
    }

    public static NQPyClass makeDoubleClass() {
        NQPyClass nQPyClass = (NQPyClass)cache.get(DOUBLE);
        if (nQPyClass == null) {
            nQPyClass = new NQPyDoubleClass();
            cache.put(DOUBLE, nQPyClass);
        }
        return nQPyClass;
    }

    public static NQPyClass makeFloatClass() {
        NQPyClass nQPyClass = (NQPyClass)cache.get(FLOAT);
        if (nQPyClass == null) {
            nQPyClass = new NQPyFloatClass();
            cache.put(FLOAT, nQPyClass);
        }
        return nQPyClass;
    }

    public static NQPyClass makeLongClass() {
        NQPyClass nQPyClass = (NQPyClass)cache.get(LONG);
        if (nQPyClass == null) {
            nQPyClass = new NQPyLongClass();
            cache.put(LONG, nQPyClass);
        }
        return nQPyClass;
    }

    public static NQPyClass makeIntegerClass() {
        NQPyClass nQPyClass = (NQPyClass)cache.get(INT);
        if (nQPyClass == null) {
            nQPyClass = new NQPyIntClass();
            cache.put(INT, nQPyClass);
        }
        return nQPyClass;
    }

    public static NQPyClass makeVoidClass() {
        return voidClass;
    }

    public static NQPyClass makeNQPyClass(Class clazz) {
        String string = clazz.getName();
        if (string.equals(STRING)) {
            return NQPyClassFactory.makeStringClass();
        }
        if (string.equals(LONG)) {
            return NQPyClassFactory.makeLongClass();
        }
        if (string.equals(DOUBLE)) {
            return NQPyClassFactory.makeDoubleClass();
        }
        if (string.equals(FLOAT)) {
            return NQPyClassFactory.makeFloatClass();
        }
        if (string.equals(INT)) {
            return NQPyClassFactory.makeIntegerClass();
        }
        if (string.equals(BOOLEAN)) {
            return NQPyClassFactory.makeBooleanClass();
        }
        if (string.equals(VOID)) {
            return voidClass;
        }
        NQPyClass nQPyClass = (NQPyClass)cache.get(string);
        if (nQPyClass == null) {
            NQPyJavaClass nQPyJavaClass = new NQPyJavaClass(clazz);
            cache.put(string, nQPyJavaClass);
            nQPyClass = nQPyJavaClass;
        }
        return nQPyClass;
    }

    public static NQPyClass makeNQPyClass(String string) {
        if (string.equals(STRING)) {
            return NQPyClassFactory.makeStringClass();
        }
        if (string.equals(LONG)) {
            return NQPyClassFactory.makeLongClass();
        }
        if (string.equals(DOUBLE)) {
            return NQPyClassFactory.makeDoubleClass();
        }
        if (string.equals(FLOAT)) {
            return NQPyClassFactory.makeFloatClass();
        }
        if (string.equals(INT)) {
            return NQPyClassFactory.makeIntegerClass();
        }
        if (string.equals(BOOLEAN)) {
            return NQPyClassFactory.makeBooleanClass();
        }
        if (string.equals(VOID)) {
            return voidClass;
        }
        NQPyClass nQPyClass = (NQPyClass)cache.get(string);
        if (nQPyClass == null) {
            nQPyClass = NQPyClassFactory.makeJavaClass(string);
        }
        return nQPyClass;
    }

    public static NQPyClass makeJavaClass(String string) {
        NQPyClass nQPyClass = NQPyClassFactory.searchCacheForName(string);
        if (nQPyClass == null) {
            if (string.indexOf(".") != -1) {
                try {
                    Class<?> clazz = Class.forName(string, true, clazzLoader);
                    NQPyJavaClass nQPyJavaClass = new NQPyJavaClass(clazz);
                    cache.put(string, nQPyJavaClass);
                    nQPyClass = nQPyJavaClass;
                    return nQPyClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            for (int i = 0; i < imports.size(); ++i) {
                String string2 = (String)imports.get(i) + string;
                try {
                    Class<?> clazz = Class.forName(string2, true, clazzLoader);
                    NQPyJavaClass nQPyJavaClass = new NQPyJavaClass(clazz);
                    cache.put(string2, nQPyJavaClass);
                    nQPyClass = nQPyJavaClass;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
        }
        return nQPyClass;
    }

    private static NQPyClass searchCacheForName(String string) {
        NQPyClass nQPyClass;
        if (string.indexOf(".") != -1 && (nQPyClass = (NQPyClass)cache.get(string)) != null) {
            return nQPyClass;
        }
        int n = imports.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)imports.get(i) + string;
            NQPyClass nQPyClass2 = (NQPyClass)cache.get(string2);
            if (nQPyClass2 == null) continue;
            return nQPyClass2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        imports.add("uchicago.src.nqpy.compiler.");
        imports.add("uchicago.src.sim.util.");
        imports.add("uchicago.src.sim.engine.");
        imports.add("uchicago.src.sim.network.");
        imports.add("uchicago.src.sim.analysis.");
        imports.add("uchicago.src.sim.games.");
        imports.add("uchicago.src.sim.gui.");
        imports.add("uchicago.src.simbuilder.beans.");
        imports.add("uchicago.src.sim.space.");
        imports.add("java.lang.");
        imports.add("java.util.");
        imports.add("");
    }
}

