/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.compiler;

import com.go.trove.classfile.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import uchicago.src.nqpy.compiler.AbstractNQPyClass;
import uchicago.src.nqpy.compiler.Emitter;
import uchicago.src.nqpy.compiler.ErrorFactory;
import uchicago.src.nqpy.compiler.ErrorMethodCall;
import uchicago.src.nqpy.compiler.FieldCall;
import uchicago.src.nqpy.compiler.JavaEmitter;
import uchicago.src.nqpy.compiler.JavaField;
import uchicago.src.nqpy.compiler.JavaMethod;
import uchicago.src.nqpy.compiler.MethodCall;
import uchicago.src.nqpy.compiler.NQPyClass;

public class NQPyDynamicClass
extends AbstractNQPyClass {
    protected ArrayList dynMethods = new ArrayList();
    protected HashMap methods = new HashMap();
    protected HashMap dynFields = new HashMap();
    protected HashMap fields = new HashMap();
    protected Class superClass = null;
    protected boolean initialized = false;
    protected String pkg = "";
    protected String uqJClassName;

    public NQPyDynamicClass(String string, Class clazz) {
        this.superClass = clazz;
        this.jclass = null;
        this.jclassName = string;
        this.id = 9;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            this.pkg = string.substring(0, n);
            this.uqJClassName = string.substring(n + 1, string.length());
        } else {
            this.uqJClassName = this.jclassName;
        }
    }

    public String getPackage() {
        return this.pkg;
    }

    public void init() {
        if (!this.initialized) {
            this.initMethodsFields();
            this.initialized = true;
        }
    }

    private void initMethodsFields() {
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2 = 0;
        try {
            object3 = this.superClass.getMethod("toString", null);
            n2 = ((Method)object3).getModifiers();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "Internal compiler error - toString() not found";
            throw ErrorFactory.createCompilerException(string, noSuchMethodException);
        }
        object3 = new ArrayList();
        for (Class clazz = this.superClass; clazz != null; clazz = clazz.getSuperclass()) {
            ((ArrayList)object3).add(clazz);
        }
        for (n = ((ArrayList)object3).size() - 1; n > -1; --n) {
            object2 = (Class)((ArrayList)object3).get(n);
            object = ((Class)object2).getDeclaredMethods();
            for (int i = 0; i < ((Method[])object).length; ++i) {
                Method method = object[i];
                int n3 = method.getModifiers();
                if (!Modifier.isPublic(n3) && !Modifier.isProtected(n3)) continue;
                String string = method.getName();
                JavaMethod javaMethod = (JavaMethod)this.methods.get(string);
                if (javaMethod == null) {
                    javaMethod = new JavaMethod(string);
                    this.methods.put(string, javaMethod);
                    javaMethod.setRetType(method.getReturnType());
                }
                javaMethod.addArgs(method.getParameterTypes(), method.getDeclaringClass(), n3);
            }
            Field[] fieldArray = ((Class)object2).getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int n4 = field.getModifiers();
                this.fields.put(field.getName(), new JavaField(field.getName(), field.getType(), n4, field.getDeclaringClass().getName()));
            }
        }
        for (n = 0; n < this.dynMethods.size(); ++n) {
            object2 = (DynMethod)this.dynMethods.get(n);
            object = (JavaMethod)this.methods.get(((DynMethod)object2).name);
            if (object == null) {
                object = new JavaMethod(((DynMethod)object2).name);
                ((JavaMethod)object).setRetType(((DynMethod)object2).retType);
                this.methods.put(((DynMethod)object2).name, object);
            }
            ((JavaMethod)object).addArgs(((DynMethod)object2).args, this.jclassName, n2);
        }
        Iterator iterator = this.dynFields.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (String)this.dynFields.get(object2);
            this.fields.put(object2, new JavaField((String)object2, (String)object, n2, this.jclassName));
        }
    }

    public void addMethod(String string, String string2, String[] stringArray) {
        DynMethod dynMethod = new DynMethod(string, string2, stringArray);
        this.dynMethods.add(dynMethod);
    }

    public void addMethod(String string, Class clazz, Class[] classArray) {
        DynMethod dynMethod = new DynMethod(string, clazz.getName(), this.classToStrings(classArray));
        this.dynMethods.add(dynMethod);
    }

    private String[] classToStrings(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public void addField(String string, String string2) {
        this.dynFields.put(string, string2);
    }

    public void addField(String string, Class clazz) {
        this.dynFields.put(string, clazz.getName());
    }

    public TypeDescriptor makeTypeDescriptor() {
        return new TypeDescriptor(this.jclassName);
    }

    public boolean isAssignableFrom(NQPyClass nQPyClass) {
        if (this.equals(nQPyClass)) {
            return true;
        }
        return this.superClass.isAssignableFrom(nQPyClass.getJClass());
    }

    public boolean inObjHeirarchy(NQPyClass nQPyClass) {
        if (this.equals(nQPyClass)) {
            return true;
        }
        if (nQPyClass.id() == 9) {
            return false;
        }
        return nQPyClass.getJClass().isAssignableFrom(this.superClass);
    }

    public MethodCall getConstructorCall(NQPyClass[] nQPyClassArray) {
        this.init();
        JavaMethod javaMethod = (JavaMethod)this.methods.get(this.uqJClassName);
        if (javaMethod == null) {
            return new ErrorMethodCall();
        }
        javaMethod.setRetType(this.jclassName);
        return javaMethod.getMethodCall(nQPyClassArray);
    }

    public MethodCall getMethodCall(String string, NQPyClass[] nQPyClassArray) {
        this.init();
        JavaMethod javaMethod = (JavaMethod)this.methods.get(string);
        if (javaMethod == null) {
            return new ErrorMethodCall();
        }
        return javaMethod.getMethodCall(nQPyClassArray);
    }

    public FieldCall getFieldCall(String string) {
        this.init();
        JavaField javaField = (JavaField)this.fields.get(string);
        if (javaField == null) {
            return null;
        }
        return javaField.getFieldCall();
    }

    public boolean equals(Object object) {
        if (object instanceof NQPyDynamicClass) {
            NQPyDynamicClass nQPyDynamicClass = (NQPyDynamicClass)object;
            return nQPyDynamicClass.jclassName.equals(this.jclassName);
        }
        return false;
    }

    public Emitter getEmitter() {
        return new JavaEmitter(this);
    }

    class DynMethod {
        String name;
        String retType;
        String[] args;

        public DynMethod(String string, String string2, String[] stringArray) {
            this.name = string;
            this.retType = string2;
            this.args = stringArray;
        }
    }
}

