/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import uchicago.src.nqpy.compiler.AbstractNQPyClass;
import uchicago.src.nqpy.compiler.Emitter;
import uchicago.src.nqpy.compiler.ErrorMethodCall;
import uchicago.src.nqpy.compiler.FieldCall;
import uchicago.src.nqpy.compiler.JavaEmitter;
import uchicago.src.nqpy.compiler.JavaField;
import uchicago.src.nqpy.compiler.JavaMethod;
import uchicago.src.nqpy.compiler.MethodCall;
import uchicago.src.nqpy.compiler.NQPyClass;

public class NQPyJavaClass
extends AbstractNQPyClass {
    protected HashMap methods = new HashMap();
    protected HashMap fields = new HashMap();
    protected boolean initialized = false;

    public NQPyJavaClass(Class clazz) {
        this.jclass = clazz;
        this.jclassName = clazz.getName();
        this.id = 6;
        this.canBeBool = true;
    }

    public void init() {
        if (!this.initialized) {
            this.initMethods();
            this.initFields();
            this.initialized = true;
        }
    }

    private void initMethods() {
        Object object;
        Method[] methodArray = this.jclass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            object = method.getName();
            JavaMethod javaMethod = (JavaMethod)this.methods.get(object);
            int n = method.getModifiers();
            if (javaMethod == null) {
                javaMethod = new JavaMethod((String)object);
                this.methods.put(object, javaMethod);
                javaMethod.setRetType(method.getReturnType());
            }
            javaMethod.addArgs(method.getParameterTypes(), method.getDeclaringClass(), n);
        }
        Constructor<?>[] constructorArray = this.jclass.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            object = constructorArray[i];
            int n = ((Constructor)object).getModifiers();
            String string = ((Constructor)object).getName();
            JavaMethod javaMethod = (JavaMethod)this.methods.get(string);
            if (javaMethod == null) {
                javaMethod = new JavaMethod(string);
                this.methods.put(string, javaMethod);
            }
            javaMethod.addArgs(((Constructor)object).getParameterTypes(), this.jclass, n);
        }
    }

    private void initFields() {
        Field[] fieldArray = this.jclass.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            this.fields.put(field.getName(), new JavaField(field.getName(), field.getType(), field.getModifiers(), field.getDeclaringClass().getName()));
        }
    }

    public MethodCall getConstructorCall(NQPyClass[] nQPyClassArray) {
        this.init();
        JavaMethod javaMethod = (JavaMethod)this.methods.get(this.jclass.getName());
        if (javaMethod == null) {
            return new ErrorMethodCall();
        }
        javaMethod.setRetType(this.jclass);
        return javaMethod.getMethodCall(nQPyClassArray);
    }

    public MethodCall getMethodCall(String string, NQPyClass[] nQPyClassArray) {
        this.init();
        JavaMethod javaMethod = (JavaMethod)this.methods.get(string);
        if (javaMethod == null) {
            return new ErrorMethodCall();
        }
        return javaMethod.getMethodCall(nQPyClassArray);
    }

    public FieldCall getFieldCall(String string) {
        this.init();
        JavaField javaField = (JavaField)this.fields.get(string);
        if (javaField == null) {
            return null;
        }
        return javaField.getFieldCall();
    }

    public boolean equals(Object object) {
        if (object instanceof NQPyJavaClass) {
            NQPyJavaClass nQPyJavaClass = (NQPyJavaClass)object;
            return nQPyJavaClass.jclass == this.jclass;
        }
        return false;
    }

    public Emitter getEmitter() {
        return new JavaEmitter(this);
    }
}

