/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.nqpy.parser;

import ViolinStrings.Strings;
import uchicago.src.nqpy.compiler.ErrorFactory;
import uchicago.src.nqpy.compiler.NQPyBlockCompiler;
import uchicago.src.nqpy.compiler.NQPyClass;
import uchicago.src.nqpy.parser.ASTarglist;
import uchicago.src.nqpy.parser.NQPyParser;
import uchicago.src.nqpy.parser.NQPyParserTreeConstants;
import uchicago.src.nqpy.parser.Node;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected NQPyParser parser;
    public int endLine;
    public int endColumn;
    public int beginLine;
    public int beginColumn;
    Object info;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(NQPyParser nQPyParser, int n) {
        this(n);
        this.parser = nQPyParser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return NQPyParserTreeConstants.jjtNodeName[this.id] + ": " + this.info;
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object object) {
        this.info = object;
    }

    public void setString(String string, int n) {
        this.info = this.parseString(string, n, this.beginLine, this.beginColumn);
    }

    public String parseString(String string, int n, int n2, int n3) {
        String string2 = string.substring(n, string.length() - n);
        string2 = Strings.change(string2, "\\n", "\n");
        string2 = Strings.change(string2, "\\\"", "\"");
        string2 = Strings.change(string2, "\\t", "\t");
        string2 = Strings.change(string2, "\\r", "\r");
        return string2;
    }

    protected void throwError(String string, Exception exception) {
        ErrorFactory.setCurNode(this);
        throw ErrorFactory.createCompilerException(string, exception);
    }

    protected void throwError(String string) {
        ErrorFactory.setCurNode(this);
        throw ErrorFactory.createCompilerException(string);
    }

    public void setInteger(String string, int n) {
        if (string.endsWith("L") || string.endsWith("l")) {
            string = string.substring(0, string.length() - 1);
            try {
                this.setInfo(Long.valueOf(string, n));
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Error creating long value";
                this.throwError(string2, numberFormatException);
            }
        } else {
            long l;
            int n2;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
            }
            if (n3 - n2 > 11) {
                this.throwError("Integer literal too large");
            }
            if ((l = Long.valueOf(string, n).longValue()) > 0xFFFFFFFFL || n == 10 && l > Integer.MAX_VALUE) {
                this.throwError("Integer literal too large");
            }
            this.setInfo(new Integer((int)l));
        }
    }

    public void setFloat(String string) {
        if (string.endsWith("F") || string.endsWith("f")) {
            string = string.substring(0, string.length() - 1);
            try {
                this.setInfo(Float.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Error creating float value";
                this.throwError(string2, numberFormatException);
            }
        } else {
            this.setInfo(Double.valueOf(string));
        }
    }

    public void compile(NQPyBlockCompiler nQPyBlockCompiler) {
        ErrorFactory.setCurNode(this);
        String string = "Unrecognized expression; compilation not supported on " + NQPyParserTreeConstants.jjtNodeName[this.id];
        throw ErrorFactory.createCompilerException(string);
    }

    public NQPyClass getNQPyClass(NQPyBlockCompiler nQPyBlockCompiler) {
        ErrorFactory.setCurNode(this);
        String string = "getNQPyClass not supported on " + NQPyParserTreeConstants.jjtNodeName[this.id];
        throw ErrorFactory.createCompilerException(string);
    }

    public NQPyClass getNQPyClassCallOp(NQPyBlockCompiler nQPyBlockCompiler, ASTarglist aSTarglist) {
        ErrorFactory.setCurNode(this);
        String string = "getNQPyClassCallOp not supported on " + NQPyParserTreeConstants.jjtNodeName[this.id];
        throw ErrorFactory.createCompilerException(string);
    }
}

