/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.reflector;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uchicago.src.reflector.ActionDescriptor;
import uchicago.src.reflector.DescriptorContainer;
import uchicago.src.reflector.Introspector;
import uchicago.src.reflector.PropertyButton;
import uchicago.src.reflector.PropertyDescriptor;
import uchicago.src.reflector.PropertyLabel;
import uchicago.src.reflector.PropertyWidget;
import uchicago.src.reflector.WidgetFactory;

public class IntrospectPanel
extends JPanel
implements ActionListener {
    private Introspector spector = new Introspector();
    private Object spectee;
    private String[] introProps = null;
    private PropertyWidget firstWidget = null;
    private ArrayList valueFields = new ArrayList(11);
    private boolean alphaOrder = true;
    private boolean first = true;

    public IntrospectPanel(Object object) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        this(object, null, true);
    }

    public IntrospectPanel(Object object, String[] stringArray, boolean bl) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        this.spectee = object;
        this.introProps = stringArray;
        this.alphaOrder = bl;
        this.init();
    }

    public void setAlphaOrder(boolean bl) {
        this.alphaOrder = bl;
    }

    private Iterator getProps() {
        Iterator iterator = null;
        if (this.alphaOrder) {
            iterator = this.spector.getPropertyNames();
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            if (this.introProps != null && this.introProps.length > 0) {
                n = this.introProps.length;
            }
            for (int i = 0; i < n; ++i) {
                StringBuffer stringBuffer = new StringBuffer(this.introProps[i].trim());
                if (stringBuffer.length() <= 0) continue;
                char c = Character.toUpperCase(stringBuffer.charAt(0));
                stringBuffer.setCharAt(0, c);
                String string = stringBuffer.toString();
                if (!this.spector.hasProperty(string)) continue;
                arrayList.add(string);
            }
            iterator = arrayList.iterator();
        }
        return iterator;
    }

    private void init() throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        Object object;
        Object object2;
        Object object3;
        Hashtable hashtable = new Hashtable();
        ArrayList arrayList = new ArrayList();
        if (this.spectee instanceof DescriptorContainer) {
            hashtable = ((DescriptorContainer)this.spectee).getParameterDescriptors();
            object3 = hashtable.keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = hashtable.get(object2);
                if (!(object instanceof ActionDescriptor)) continue;
                arrayList.add(object);
                hashtable.remove(object2);
            }
        }
        this.setLayout(new GridBagLayout());
        object3 = new GridBagConstraints();
        ((GridBagConstraints)object3).gridx = 0;
        ((GridBagConstraints)object3).gridy = 0;
        ((GridBagConstraints)object3).weightx = 0.0;
        ((GridBagConstraints)object3).weighty = 0.0;
        ((GridBagConstraints)object3).fill = 2;
        this.spector.introspect(this.spectee, this.introProps);
        object2 = this.getProps();
        while (object2.hasNext()) {
            object = (String)object2.next();
            JLabel jLabel = new JLabel(object + ": ");
            this.add((Component)jLabel, object3);
            ((GridBagConstraints)object3).gridx = 1;
            ((GridBagConstraints)object3).weightx = 1.0;
            if (!this.spector.isWriteOnly((String)object)) {
                Object object4;
                Object object5;
                boolean bl = this.spector.isPropertyStringable((String)object);
                boolean bl2 = this.spector.isReadOnly((String)object);
                if (bl && bl2) {
                    object5 = this.spector.getPropertyAsString((String)object);
                    object4 = new PropertyLabel((String)object5);
                    ((PropertyLabel)object4).setPropertyName((String)object);
                    this.add((Component)object4, object3);
                    this.valueFields.add(object4);
                } else {
                    object5 = null;
                    object4 = (PropertyDescriptor)hashtable.get(object);
                    if (object4 != null || bl) {
                        object5 = WidgetFactory.getWidget((PropertyDescriptor)object4, this.spector.isPropertyBoolean((String)object), object);
                        object5.setValue(this.spector.getPropertyValue((String)object));
                    } else {
                        object5 = this.spector.getPropertyValue((String)object) == null ? new PropertyLabel("Null") : new PropertyButton(this.spector.getPropertyValue((String)object), !bl2);
                    }
                    if (this.first) {
                        this.firstWidget = object5;
                        this.first = false;
                    }
                    object5.addActionListener(this);
                    object5.setPropertyName((String)object);
                    this.add((Component)object5, object3);
                    this.valueFields.add(object5);
                }
            } else {
                JLabel jLabel2 = new JLabel("Is Write-only");
                jLabel2.setBorder(BorderFactory.createEtchedBorder());
                this.add((Component)jLabel2, object3);
            }
            ++((GridBagConstraints)object3).gridy;
            ((GridBagConstraints)object3).gridx = 0;
            ((GridBagConstraints)object3).weightx = 0.0;
        }
        this.addActionDescriptors(arrayList, (GridBagConstraints)object3);
    }

    private void addActionDescriptors(ArrayList arrayList, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridwidth = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionDescriptor actionDescriptor = (ActionDescriptor)arrayList.get(i);
            this.add((Component)actionDescriptor.getComponent(), gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
    }

    public void redraw() throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        this.removeAll();
        this.init();
        this.invalidate();
    }

    public void reset() {
        Iterator iterator = this.valueFields.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                PropertyWidget propertyWidget = (PropertyWidget)e;
                propertyWidget.setValue(this.spector.getPropertyValue(propertyWidget.getPropertyName()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(0);
            }
        }
    }

    public void setFocus() {
        if (this.firstWidget != null) {
            this.firstWidget.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PropertyWidget propertyWidget = (PropertyWidget)actionEvent.getSource();
        Object object = propertyWidget.getValue();
        try {
            this.spector.invokeSetMethod(propertyWidget.getPropertyName(), object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setEnabled(boolean bl) {
        for (int i = 0; i < this.valueFields.size(); ++i) {
            PropertyWidget propertyWidget = (PropertyWidget)this.valueFields.get(i);
            propertyWidget.setEnabled(bl);
        }
    }
}

