/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.reflector;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uchicago.src.reflector.PropertyWidget;

public class RangeWidget
extends JPanel
implements PropertyWidget {
    private String propertyName;
    private JSlider slider;
    private JTextField field;
    private int min;
    private int max;
    private ArrayList listeners = new ArrayList();

    public RangeWidget(int n, int n2, int n3) {
        super(new FlowLayout());
        this.slider = new JSlider(n, n2);
        this.field = new JTextField(String.valueOf(n2).length());
        this.add(this.slider);
        this.add(this.field);
        this.min = n;
        this.max = n2;
        this.slider.setMajorTickSpacing(n3);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() == RangeWidget.this.field) {
                    RangeWidget.this.setValue(new Integer(RangeWidget.this.field.getText()));
                } else {
                    RangeWidget.this.field.setText(String.valueOf(RangeWidget.this.slider.getValue()));
                    if (!RangeWidget.this.slider.getValueIsAdjusting()) {
                        RangeWidget.this.fireActionPerformed();
                    }
                }
            }
        });
        this.field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RangeWidget.this.setSlider();
                RangeWidget.this.setValue(new Integer(RangeWidget.this.field.getText()));
                RangeWidget.this.fireActionPerformed();
            }
        });
        this.field.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RangeWidget.this.setSlider();
                RangeWidget.this.fireActionPerformed();
            }
        });
    }

    private void setSlider() {
        try {
            Integer n = new Integer(this.field.getText());
            this.setValue(n);
        }
        catch (NumberFormatException numberFormatException) {
            Integer n = (Integer)this.getValue();
            this.field.setText(n.toString());
            this.setValue(n);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public void setValue(Object object) {
        int n = (Integer)object;
        n = n < this.min ? this.min : (n > this.max ? this.max : n);
        this.field.setText(String.valueOf(n));
        this.slider.setValue(n);
    }

    public Object getValue() {
        return new Integer(this.slider.getValue());
    }

    public void requestFocus() {
        this.slider.requestFocus();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed() {
        ArrayList arrayList;
        ArrayList arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener = (ActionListener)arrayList.get(i);
            actionListener.actionPerformed(new ActionEvent(this, 0, "action"));
        }
    }

    public void setEnabled(boolean bl) {
        this.slider.setEnabled(bl);
        this.field.setEnabled(bl);
    }
}

