/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import uchicago.src.sim.analysis.BlockFileWriter;
import uchicago.src.sim.analysis.DataFileHeader;
import uchicago.src.sim.util.SimUtilities;

public class DataFileWriter
implements BlockFileWriter {
    private String dataHeader;
    private String fileName;
    private String blockHeader;
    private boolean nothingWritten = true;
    private boolean writeBlockHeader = false;
    private DataFileHeader dfHeader;

    public DataFileWriter(String string, DataFileHeader dataFileHeader) {
        try {
            this.fileName = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Fatal file error", iOException);
            System.exit(0);
        }
        this.dfHeader = dataFileHeader;
    }

    private void renameFile() throws IOException {
        File file = new File(this.fileName);
        this.fileName = file.getCanonicalPath();
        if (file.exists()) {
            File file2;
            int n = 1;
            String string = this.fileName;
            String string2 = "";
            if (this.fileName.indexOf(".") != -1) {
                int n2 = this.fileName.lastIndexOf(".");
                string = this.fileName.substring(0, n2);
                string2 = this.fileName.substring(n2, this.fileName.length());
            }
            if (this.dfHeader.isBatch()) {
                string = string + ".bak";
            }
            do {
                file2 = new File(string + n + string2);
                ++n;
            } while (file2.exists());
            file.renameTo(file2);
            file.delete();
        }
    }

    public void setBlockHeader(String string) {
        this.blockHeader = string;
        this.writeBlockHeader = true;
    }

    public void writeToFile(Object object) {
        String string = object.toString();
        BufferedWriter bufferedWriter = null;
        try {
            if (this.nothingWritten) {
                if (this.dfHeader.doWriteHeader(this.fileName)) {
                    this.renameFile();
                    bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
                    bufferedWriter.write(this.dfHeader.getFileHeader());
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    this.dfHeader.setWriteHeader(this.fileName, false);
                }
                this.nothingWritten = false;
            }
            if (bufferedWriter == null) {
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            }
            if (this.writeBlockHeader) {
                bufferedWriter.write(this.dfHeader.getBlockHeaderAsComments());
                bufferedWriter.write(this.blockHeader);
                bufferedWriter.newLine();
                this.writeBlockHeader = false;
            }
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write data to file", iOException);
            iOException.printStackTrace();
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }
}

