/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import uchicago.src.sim.analysis.AbstractDataSourceRecorder;
import uchicago.src.sim.analysis.DataSource;
import uchicago.src.sim.analysis.DataWriter;
import uchicago.src.sim.analysis.ListDataSource;
import uchicago.src.sim.analysis.ObjectDataSource;
import uchicago.src.sim.engine.IController;
import uchicago.src.sim.engine.RemoteBatchController;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimModel;

public class DistributedDataRecorder
extends AbstractDataSourceRecorder {
    protected DataWriter writer;
    protected String name;
    protected String fileName;
    protected IController control;
    protected Hashtable dynParams;
    protected boolean writeHeader = true;
    protected String writeKey;
    public static final String WRITE_END_KEY = "_WRITE_END";
    static /* synthetic */ Class class$java$lang$Object;

    public DistributedDataRecorder(String string, DataWriter dataWriter, SimModel simModel, String string2) {
        this.writer = dataWriter;
        this.initData(simModel, string2);
        this.fileName = string;
        this.control = simModel.getController();
        this.control.addSimEventListener(this);
        this.dynParams = this.dfHeader.getDynParamMethod();
        this.writeKey = this.fileName + "_WRITE_HEADER";
        this.writeHeader = ((RemoteBatchController)this.control).getPutPersistentObject(this.writeKey, Boolean.FALSE);
        Enumeration enumeration = this.dynParams.keys();
        HashSet<Class<Serializable>> hashSet = new HashSet<Class<Serializable>>();
        hashSet.add(Integer.TYPE);
        hashSet.add(Float.TYPE);
        hashSet.add(Double.TYPE);
        hashSet.add(Byte.TYPE);
        hashSet.add(Long.TYPE);
        hashSet.add(Character.TYPE);
        this.data.addToHeader("run");
        while (enumeration.hasMoreElements()) {
            String string3;
            Method method;
            if ((class$java$lang$Object == null ? DistributedDataRecorder.class$("java.lang.Object") : class$java$lang$Object).isAssignableFrom((method = (Method)this.dynParams.get(string3 = (String)enumeration.nextElement())).getReturnType())) {
                this.createObjectDataSource(string3, this.model, method.getName());
                continue;
            }
            if (hashSet.contains(method.getReturnType())) {
                this.createNumericDataSource(string3, this.model, method.getName(), -1, -1);
                continue;
            }
            ObjectDataSource objectDataSource = new ObjectDataSource(string3, (Object)simModel, (Method)this.dynParams.get(string3));
            this.sources.add(objectDataSource);
            this.data.addToHeader(string3);
        }
    }

    public DistributedDataRecorder(String string, DataWriter dataWriter, SimModel simModel) {
        this(string, dataWriter, simModel, "");
    }

    public void record() {
        Vector<Object> vector = new Vector<Object>();
        if (this.model == null) {
            System.out.println("no model - record");
        }
        Double d = new Double(this.model.getTickCount());
        vector.add(d);
        for (int i = 0; i < this.sources.size(); ++i) {
            DataSource dataSource = (DataSource)this.sources.elementAt(i);
            if (dataSource instanceof ListDataSource) {
                vector.addAll((List)dataSource.execute());
                continue;
            }
            Object object = dataSource.execute();
            vector.add(object);
        }
        vector.add(0, new Long(this.control.getRunCount()));
        this.data.addData(vector);
    }

    public void writeToFile() {
        this.writer.write(this.data, this.writeHeader);
    }

    public void write() {
        this.writeToFile();
    }

    public void simEventPerformed(SimEvent simEvent) {
    }

    public void writeEnd() {
        this.writer.writeEnd();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

