/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import hep.aida.IAxis;
import hep.aida.ref.Histogram1D;
import java.text.NumberFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import uchicago.src.codegen.GeneratorException;
import uchicago.src.sim.analysis.BinDataSource;
import uchicago.src.sim.util.ByteCodeBuilder;
import uchicago.src.sim.util.SimUtilities;

public class HistogramItem {
    protected List list;
    protected int numBins;
    protected long lowerBound;
    protected String[] labels;
    protected BinDataSource source = null;
    private NumberFormat formatter = NumberFormat.getInstance();

    public HistogramItem(List list, String string, int n, long l) {
        try {
            this.source = ByteCodeBuilder.generateNoTargetBinDataSource(list.listIterator().next(), string);
            this.list = list;
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating HistorgramItem: ", generatorException);
            generatorException.printStackTrace();
            System.exit(0);
        }
        this.numBins = n;
        this.lowerBound = l;
        this.formatter.setMaximumFractionDigits(340);
    }

    public HistogramItem(List list, String string, int n, long l, int n2, int n3) {
        try {
            this.source = ByteCodeBuilder.generateNoTargetBinDataSource(list.listIterator().next(), string);
            this.list = list;
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating HistorgramItem: ", generatorException);
            generatorException.printStackTrace();
            System.exit(0);
        }
        this.numBins = n;
        this.lowerBound = l;
        this.formatter.setMaximumFractionDigits(340);
        if (n2 != -1) {
            this.formatter.setMaximumIntegerDigits(n2);
        }
        if (n3 != -1) {
            this.formatter.setMaximumFractionDigits(n3);
        }
    }

    public HistogramItem(List list, BinDataSource binDataSource, int n, long l) {
        this.source = binDataSource;
        this.numBins = n;
        this.list = list;
        this.lowerBound = l;
        this.formatter.setMaximumFractionDigits(340);
    }

    public HistogramItem(List list, BinDataSource binDataSource, int n, long l, int n2, int n3) {
        this.source = binDataSource;
        this.numBins = n;
        this.list = list;
        this.lowerBound = l;
        this.formatter.setMaximumFractionDigits(340);
        if (n2 != -1) {
            this.formatter.setMaximumIntegerDigits(n2);
        }
        if (n3 != -1) {
            this.formatter.setMaximumFractionDigits(n3);
        }
    }

    public Vector getBinValues() {
        int n;
        Vector<Double> vector = new Vector<Double>(this.numBins);
        double[] dArray = new double[this.numBins];
        for (int i = 0; i < this.numBins; ++i) {
            dArray[i] = 0.0;
        }
        double[] dArray2 = new double[this.list.size()];
        double d = 0.0;
        ListIterator listIterator = this.list.listIterator();
        int n2 = 0;
        while (listIterator.hasNext()) {
            double d2 = this.source.getBinValue(listIterator.next());
            if (n2 == 0) {
                d = d2;
            } else if (d2 > d) {
                d = d2;
            }
            dArray2[n2++] = d2;
        }
        Histogram1D histogram1D = new Histogram1D("foo", this.numBins, this.lowerBound, d);
        for (int i = 0; i < dArray2.length; ++i) {
            histogram1D.fill(dArray2[i]);
        }
        IAxis iAxis = histogram1D.xAxis();
        this.labels = new String[this.numBins];
        for (n = 0; n < iAxis.bins(); ++n) {
            this.labels[n] = this.formatter.format(iAxis.binLowerEdge(n)) + "-" + this.formatter.format(iAxis.binUpperEdge(n));
            vector.add(new Double(histogram1D.binEntries(n)));
        }
        n = iAxis.bins() - 1;
        double d3 = histogram1D.binEntries(n) + histogram1D.binEntries(-1);
        vector.add(n, new Double(d3));
        return vector;
    }

    public String[] getBinLabels() {
        return this.labels;
    }
}

