/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import uchicago.src.sim.analysis.AbstractDataSourceRecorder;
import uchicago.src.sim.analysis.DataSource;
import uchicago.src.sim.analysis.ListDataSource;
import uchicago.src.sim.analysis.ObjectDataSource;
import uchicago.src.sim.engine.IController;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.util.SimUtilities;

public class LocalDataRecorder
extends AbstractDataSourceRecorder {
    protected String fileName;
    protected boolean isBatch;
    protected Hashtable dynParams;
    protected boolean writeHeader = true;
    protected IController control;
    protected String writeKey;
    static /* synthetic */ Class class$java$lang$Object;

    public LocalDataRecorder(String string, SimModel simModel) {
        this(string, simModel, null);
    }

    public LocalDataRecorder(String string, SimModel simModel, String string2) {
        this.initData(simModel, string2);
        this.isBatch = simModel.getController().isBatch();
        this.fileName = string;
        if (this.isBatch) {
            this.control = simModel.getController();
            this.control.addSimEventListener(this);
            this.dynParams = this.dfHeader.getDynParamMethod();
            this.data.addToHeader("run");
            this.writeKey = this.fileName + "_WRITE_HEADER";
            Boolean bl = null;
            bl = (Boolean)this.control.getPersistentObj(this.writeKey);
            if (bl == null) {
                this.writeHeader = true;
                this.control.putPersistentObj(this.writeKey, Boolean.TRUE);
            } else {
                this.writeHeader = bl;
            }
            Enumeration enumeration = this.dynParams.keys();
            HashSet<Class<Serializable>> hashSet = new HashSet<Class<Serializable>>();
            hashSet.add(Integer.TYPE);
            hashSet.add(Float.TYPE);
            hashSet.add(Double.TYPE);
            hashSet.add(Byte.TYPE);
            hashSet.add(Long.TYPE);
            hashSet.add(Character.TYPE);
            while (enumeration.hasMoreElements()) {
                String string3;
                Method method;
                if ((class$java$lang$Object == null ? LocalDataRecorder.class$("java.lang.Object") : class$java$lang$Object).isAssignableFrom((method = (Method)this.dynParams.get(string3 = (String)enumeration.nextElement())).getReturnType())) {
                    this.createObjectDataSource(string3, this.model, method.getName());
                    continue;
                }
                if (hashSet.contains(method.getReturnType())) {
                    this.createNumericDataSource(string3, this.model, method.getName(), -1, -1);
                    continue;
                }
                ObjectDataSource objectDataSource = new ObjectDataSource(string3, (Object)simModel, (Method)this.dynParams.get(string3));
                this.sources.add(objectDataSource);
                this.data.addToHeader(string3);
            }
        }
    }

    public LocalDataRecorder(String string, SimModel simModel, boolean bl) {
        this(string, simModel, bl, null);
    }

    public LocalDataRecorder(String string, SimModel simModel, boolean bl, String string2) {
        this(string, simModel, string2);
        bl = false;
    }

    public void setDelimiter(String string) {
        this.data.setDelimiter(string);
    }

    public void record() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Double d = new Double(this.model.getTickCount());
        arrayList.add(d);
        for (int i = 0; i < this.sources.size(); ++i) {
            DataSource dataSource = (DataSource)this.sources.elementAt(i);
            if (dataSource instanceof ListDataSource) {
                arrayList.addAll((List)dataSource.execute());
                continue;
            }
            Object object = dataSource.execute();
            arrayList.add(object);
        }
        if (this.isBatch) {
            arrayList.add(0, new Long(this.control.getRunCount()));
        }
        this.data.addData(arrayList);
    }

    private void renameFile() throws IOException {
        File file = new File(this.fileName);
        this.fileName = file.getCanonicalPath();
        if (file.exists()) {
            File file2;
            int n = 1;
            String string = this.fileName;
            String string2 = "";
            if (this.fileName.indexOf(".") != -1) {
                int n2 = this.fileName.lastIndexOf(".");
                string = this.fileName.substring(0, n2);
                string2 = this.fileName.substring(n2, this.fileName.length());
            }
            if (this.isBatch) {
                string = string + ".bak";
            }
            do {
                file2 = new File(string + n + string2);
                ++n;
            } while (file2.exists());
            file.renameTo(file2);
            file.delete();
        }
    }

    public void writeToFile() {
        BufferedWriter bufferedWriter = null;
        try {
            if (this.writeHeader) {
                this.renameFile();
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
                bufferedWriter.write(this.data.getModelHeader());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                bufferedWriter.write(this.data.getHeader());
                bufferedWriter.newLine();
                if (this.isBatch) {
                    this.control.putPersistentObj(this.writeKey, Boolean.FALSE);
                }
                this.writeHeader = false;
            }
            if (bufferedWriter == null) {
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            }
            Iterator iterator = this.data.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write((String)iterator.next());
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write data to file", iOException);
            iOException.printStackTrace();
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public void write() {
        this.writeToFile();
    }

    public void writeEnd() {
        BufferedWriter bufferedWriter = null;
        try {
            if (this.writeHeader) {
                this.writeToFile();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            Date date = new Date();
            String string = DateFormat.getDateTimeInstance().format(date);
            bufferedWriter.newLine();
            bufferedWriter.write("End Time: " + string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write footer to file", iOException);
            iOException.printStackTrace();
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

