/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.util.Vector;
import uchicago.src.sim.analysis.DataFileHeader;
import uchicago.src.sim.analysis.DataFileWriter;
import uchicago.src.sim.engine.SimModel;

public class ObjectDataRecorder {
    protected Vector data = new Vector(57);
    protected DataFileHeader dfHeader;
    protected String lineSep;
    protected DataFileWriter writer;

    public ObjectDataRecorder(String string, SimModel simModel) {
        this.dfHeader = new DataFileHeader(simModel);
        this.lineSep = System.getProperty("line.separator");
        this.writer = new DataFileWriter(string, this.dfHeader);
    }

    public void record(Object object, String string) {
        this.data.add(new ObjectStringPair(object, string));
    }

    public void record(Object object) {
        this.record(object, "");
    }

    public void write() {
        for (int i = 0; i < this.data.size(); ++i) {
            ObjectStringPair objectStringPair = (ObjectStringPair)this.data.get(i);
            this.writer.setBlockHeader(objectStringPair.blockHeader);
            this.writer.writeToFile(objectStringPair.object);
        }
        this.data.clear();
    }

    protected class ObjectStringPair {
        Object object;
        String blockHeader;

        public ObjectStringPair(Object object, String string) {
            this.object = object;
            this.blockHeader = string;
        }
    }
}

