/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import ViolinStrings.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import uchicago.src.sim.engine.IController;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.util.SimUtilities;

public class SimData {
    private ArrayList data = new ArrayList();
    private String header = "\"tick\"";
    private String modelHeader;
    private String fileName;
    private boolean isBatch = false;
    private boolean writeHeader = true;
    private IController control;
    private String delimiter = ",";

    public SimData(String string, String string2, SimModel simModel, boolean bl) {
        this.isBatch = bl;
        this.modelHeader = string2;
        try {
            this.fileName = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Fatal file error", iOException);
            System.exit(0);
        }
        if (bl) {
            this.header = "\"run\"" + this.delimiter + this.header;
            this.control = simModel.getController();
            Boolean bl2 = (Boolean)this.control.getPersistentObj(this.fileName + "_WRITE_HEADER");
            if (bl2 == null) {
                this.writeHeader = true;
                this.control.putPersistentObj(this.fileName + "_WRITE_HEADER", Boolean.TRUE);
            } else {
                this.writeHeader = bl2;
            }
        }
    }

    public SimData(String string, SimModel simModel, boolean bl) {
        this.isBatch = bl;
        this.modelHeader = string;
    }

    public String getHeader() {
        this.writeHeader = false;
        return this.header;
    }

    public boolean writeHeader() {
        return this.writeHeader;
    }

    public String getModelHeader() {
        return this.modelHeader;
    }

    public void setDelimiter(String string) {
        this.header = Strings.change(this.header, this.delimiter, string);
        this.delimiter = string;
    }

    public void addToHeader(String string) {
        this.header = this.header.length() == 0 ? this.header + "\"" + string + "\"" : this.header + this.delimiter + "\"" + string + "\"";
    }

    public void addToHeader(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (this.header.length() == 0) {
                this.header = this.header + string;
                continue;
            }
            this.header = this.header + this.delimiter + string;
        }
    }

    public void addData(List list) {
        this.data.add(list);
    }

    private void renameFile() throws IOException {
        File file = new File(this.fileName);
        this.fileName = file.getCanonicalPath();
        if (file.exists()) {
            File file2;
            int n = 1;
            String string = this.fileName;
            String string2 = "";
            if (this.fileName.indexOf(".") != -1) {
                int n2 = this.fileName.lastIndexOf(".");
                string = this.fileName.substring(0, n2);
                string2 = this.fileName.substring(n2, this.fileName.length());
            }
            if (this.isBatch) {
                string = string + ".bak";
            }
            do {
                file2 = new File(string + n + string2);
                ++n;
            } while (file2.exists());
            file.renameTo(file2);
            file.delete();
        }
    }

    public void writeEnd() {
        BufferedWriter bufferedWriter = null;
        try {
            if (this.writeHeader) {
                this.writeToFile();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            Date date = new Date();
            String string = DateFormat.getDateTimeInstance().format(date);
            bufferedWriter.newLine();
            bufferedWriter.write("End Time: " + string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write footer to file", iOException);
            iOException.printStackTrace();
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public void writeToFile() {
        BufferedWriter bufferedWriter = null;
        try {
            if (this.writeHeader) {
                this.renameFile();
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
                bufferedWriter.write(this.modelHeader);
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                bufferedWriter.write(this.header);
                bufferedWriter.newLine();
                if (this.isBatch) {
                    this.control.putPersistentObj(this.fileName + "_WRITE_HEADER", Boolean.FALSE);
                }
                this.writeHeader = false;
            }
            if (bufferedWriter == null) {
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            }
            for (int i = 0; i < this.data.size(); ++i) {
                List list = (List)this.data.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    if (j == 0) {
                        bufferedWriter.write(list.get(j).toString());
                        continue;
                    }
                    bufferedWriter.write(this.delimiter + list.get(j).toString());
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            this.data.clear();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write data to file", iOException);
            iOException.printStackTrace();
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public String getData() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.data.size(); ++i) {
            List list = (List)this.data.get(i);
            for (int j = 0; j < list.size(); ++j) {
                if (j == 0) {
                    stringBuffer.append(list.get(j).toString());
                    continue;
                }
                stringBuffer.append(this.delimiter + list.get(j).toString());
            }
            stringBuffer.append("\n");
        }
        this.data.clear();
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new SimDataIterator();
    }

    public class SimDataIterator
    implements Iterator {
        private Iterator i;

        SimDataIterator() {
            this.i = SimData.this.data.iterator();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            List list = (List)this.i.next();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    stringBuffer.append(list.get(i).toString());
                    continue;
                }
                stringBuffer.append(SimData.this.delimiter + list.get(i).toString());
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        public void remove() {
            this.i.remove();
        }
    }
}

