/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import uchicago.src.codegen.GeneratorException;
import uchicago.src.guiUtils.GuiUtilities;
import uchicago.src.sim.analysis.BinDataSource;
import uchicago.src.sim.analysis.Sequence;
import uchicago.src.sim.analysis.plot.RepastPlot;
import uchicago.src.sim.analysis.plot.ZoomListener;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.gui.FrameFactory;
import uchicago.src.sim.gui.MediaProducer;
import uchicago.src.sim.gui.MovieMaker;
import uchicago.src.sim.util.ByteCodeBuilder;
import uchicago.src.sim.util.SimUtilities;

public abstract class OpenGraph
implements ZoomListener,
MediaProducer {
    public static final int SEQUENCE = 0;
    public static final int HISTOGRAM = 1;
    public static final int FILLED_CIRCLE = 0;
    public static final int CROSS = 1;
    public static final int SQUARE = 2;
    public static final int FILLED_TRIANGLE = 3;
    public static final int DIAMOND = 4;
    public static final int CIRCLE = 5;
    public static final int PLUS_SIGN = 6;
    public static final int FILLED_SQUARE = 7;
    public static final int TRIANGLE = 8;
    public static final int FILLED_DIAMOND = 9;
    protected JFrame f;
    protected boolean inNormalState = true;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected double xIncr = 5.0;
    protected double yIncr = 5.0;
    protected RepastPlot plot;
    protected SimModel model = null;
    protected Point location;
    protected MovieMaker movieMaker;
    protected String title = "";
    protected String fileName = null;

    public OpenGraph(String string) {
        this.title = string;
        this.plot = new RepastPlot(this);
        this.plot.setTitle(string);
        this.xMin = 0.0;
        this.xMax = 100.0;
        this.yMin = 0.0;
        this.yMax = 100.0;
        this.addListeners();
    }

    private void addListeners() {
        this.plot.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (!OpenGraph.this.inNormalState && n == 82) {
                    OpenGraph.this.plot.setYRange(OpenGraph.this.yMin, OpenGraph.this.yMax);
                    OpenGraph.this.plot.setXRange(OpenGraph.this.xMin, OpenGraph.this.xMax);
                    OpenGraph.this.inNormalState = true;
                    OpenGraph.this.plot.repaint();
                }
            }
        });
    }

    public void setXRange(double d, double d2) {
        this.xMin = d;
        this.xMax = d2;
        if (this.xMin >= this.xMax) {
            throw new IllegalArgumentException("Min. value must be less than max. value");
        }
        this.plot.setXRange(d, d2);
    }

    public double[] getXRange() {
        return this.plot.getXRange();
    }

    public void setYRange(double d, double d2) {
        this.yMin = d;
        this.yMax = d2;
        if (this.yMin >= this.yMax) {
            throw new IllegalArgumentException("Min. value must be less than max. value");
        }
        this.plot.setYRange(d, d2);
    }

    public double[] getYRange() {
        return this.plot.getYRange();
    }

    public void setSize(int n, int n2) {
        this.plot.setSize(n, n2);
    }

    public Dimension getSize() {
        return this.plot.getSize();
    }

    public void setLocation(int n, int n2) {
        this.location = new Point(n, n2);
        if (this.f != null) {
            this.f.setLocation(this.location);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setYIncrement(double d) {
        this.yIncr = d;
    }

    public double getYIncrement() {
        return this.yIncr;
    }

    public void setXIncrement(double d) {
        this.xIncr = d;
    }

    public double getXIncrement() {
        return this.xIncr;
    }

    public void setAxisTitles(String string, String string2) {
        this.plot.setXLabel(string);
        this.plot.setYLabel(string2);
    }

    public String[] getAxisTitles() {
        String[] stringArray = new String[]{this.plot.getXLabel(), this.plot.getYLabel()};
        return stringArray;
    }

    public void setXTick(double d, String string) {
        this.plot.addXTick(string, d);
    }

    public void updateXTick(double d, String string, int n) {
        this.plot.updateXTick(string, d, n);
    }

    public void setBars(double d, double d2) {
        this.plot.setBars(d, d2);
    }

    public void step() {
        this.record();
        if (this.f.getState() != 1) {
            this.updateGraph();
        }
    }

    public abstract void record();

    public abstract void updateGraph();

    public void zoom(int n, int n2) {
        this.inNormalState = false;
    }

    public void display() {
        if (this.f == null) {
            this.f = FrameFactory.createFrame(this.title);
            this.f.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (!OpenGraph.this.inNormalState && n == 82) {
                        OpenGraph.this.plot.setYRange(OpenGraph.this.yMin, OpenGraph.this.yMax);
                        OpenGraph.this.plot.setXRange(OpenGraph.this.xMin, OpenGraph.this.xMax);
                        OpenGraph.this.inNormalState = true;
                        OpenGraph.this.plot.repaint();
                    }
                }
            });
            this.f.addWindowListener(new WindowAdapter(){

                public void windowDeiconified(WindowEvent windowEvent) {
                    OpenGraph.this.updateGraph();
                }
            });
            this.f.setDefaultCloseOperation(2);
            this.f.getContentPane().setLayout(new BorderLayout());
            this.f.getContentPane().add((Component)this.plot, "Center");
            this.f.setTitle(this.title);
            this.f.pack();
            Rectangle rectangle = FrameFactory.getBounds(this.title);
            if (this.location != null) {
                this.f.setLocation(this.location);
                if (rectangle != null) {
                    this.f.setSize(rectangle.width, rectangle.height);
                }
            } else if (rectangle != null) {
                this.f.setBounds(rectangle);
            } else {
                GuiUtilities.centerComponentOnScreen(this.f);
            }
            this.f.setVisible(true);
        }
    }

    public void dispose() {
        if (this.f != null) {
            this.f.dispose();
            this.f = null;
        }
    }

    protected BinDataSource createBinDataSource(Object object, String string) {
        BinDataSource binDataSource = null;
        try {
            binDataSource = ByteCodeBuilder.generateBinDataSource(object, string);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating BinDataSource: " + generatorException.getMessage(), generatorException);
            System.exit(0);
        }
        return binDataSource;
    }

    protected BinDataSource createListBinDataSource(Object object, String string) {
        BinDataSource binDataSource = null;
        try {
            binDataSource = ByteCodeBuilder.generateNoTargetBinDataSource(object, string);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating ListBinDataSource: " + generatorException.getMessage(), generatorException);
            System.exit(0);
        }
        return binDataSource;
    }

    protected Sequence createSequence(Object object, String string) {
        Sequence sequence = null;
        try {
            sequence = ByteCodeBuilder.generateSequence(object, string);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating Sequence: " + generatorException.getMessage(), generatorException);
            System.exit(0);
        }
        return sequence;
    }

    public void takeSnapshot() {
        if (this.fileName == null) {
            SimUtilities.showMessage("Snapshot filename is not set");
            return;
        }
        if (this.model == null) {
            SimUtilities.showMessage("No model associated with this graph.");
            return;
        }
        BufferedImage bufferedImage = this.plot.getImage();
        String string = this.fileName + this.model.getTickCount() + ".png";
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            ImageIO.write((RenderedImage)bufferedImage, "png", dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error writing graph to file", iOException);
        }
    }

    public void setSnapshotFileName(String string) {
        this.fileName = string;
    }

    public void setMovieName(String string, String string2) {
        Dimension dimension = this.getSize();
        if (string2.equals("video.quicktime")) {
            string = string + ".mov";
            this.movieMaker = new MovieMaker(dimension.width, dimension.height, 1, string, string2);
        } else {
            SimUtilities.showMessage("Movie type " + string2 + " is unsupported");
        }
    }

    public void addMovieFrame() {
        if (this.movieMaker == null) {
            SimUtilities.showMessage("Unable to create frame - use setMovieFileName first");
            return;
        }
        BufferedImage bufferedImage = this.plot.getGraphicsConfiguration().createCompatibleImage(this.plot.getWidth(), this.plot.getHeight());
        Graphics graphics = bufferedImage.getGraphics();
        this.plot.paint(graphics);
        this.movieMaker.addImageAsFrame(bufferedImage);
        graphics.dispose();
    }

    public void closeMovie() {
        if (this.movieMaker != null) {
            this.movieMaker.cleanUp();
        }
    }
}

