/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import uchicago.src.reflector.IntrospectPanel;
import uchicago.src.sim.analysis.AbstractChartModel;
import uchicago.src.sim.analysis.ChartArchiver;
import uchicago.src.sim.analysis.CustomChartGui;
import uchicago.src.sim.analysis.plot.OpenGraph;
import uchicago.src.sim.engine.BaseController;
import uchicago.src.sim.engine.LoadModelDialog;
import uchicago.src.sim.engine.MediaScheduler;
import uchicago.src.sim.engine.ModelManipulator;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.engine.SnapshotScheduler;
import uchicago.src.sim.engine.gui.MakeMovieDialog;
import uchicago.src.sim.engine.gui.SnapshotDialog;
import uchicago.src.sim.gui.DisplayConstants;
import uchicago.src.sim.gui.FrameFactory;
import uchicago.src.sim.gui.ProducerNamePair;
import uchicago.src.sim.gui.RepastConsole;
import uchicago.src.sim.parameter.DefaultParameterSetter;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterSetterFactory;
import uchicago.src.sim.parameter.ParameterUtility;
import uchicago.src.sim.util.ProbeUtilities;
import uchicago.src.sim.util.SimUtilities;

public abstract class AbstractGUIController
extends BaseController {
    public static boolean SHOW_CHARTS = true;
    public static boolean ALPHA_ORDER = true;
    public static boolean CONSOLE_OUT = true;
    public static boolean CONSOLE_ERR = true;
    public static boolean DEFAULTS_INCLUDE_RNGSEED = false;
    public static boolean UPDATE_PROBES = false;
    protected String[] myParams = new String[]{"PauseAt", "RandomSeed", "CellWidth", "CellHeight", "CellDepth"};
    protected Vector mediaSchedulers = new Vector();
    protected ArrayList chartModels = new ArrayList();
    protected ArrayList customCharts = new ArrayList();
    protected RepastConsole console = null;

    public AbstractGUIController() {
        ParameterUtility.createInstance(new DefaultParameterSetter());
    }

    public AbstractGUIController(ParameterSetter parameterSetter) {
        ParameterUtility.createInstance(parameterSetter);
        this.params = parameterSetter;
    }

    public void setConsoleOut(boolean bl) {
        CONSOLE_OUT = bl;
    }

    public boolean getConsoleOut() {
        return CONSOLE_OUT;
    }

    public void setConsoleErr(boolean bl) {
        CONSOLE_ERR = bl;
    }

    public boolean getConsoleErr() {
        return CONSOLE_ERR;
    }

    public void setModel(SimModel simModel) {
        if (simModel != null) {
            this.chartModels = ChartArchiver.loadCharts(simModel);
        }
        super.setModel(simModel);
    }

    public void showLoadModelDialog(JFrame jFrame) {
        LoadModelDialog loadModelDialog = new LoadModelDialog();
        loadModelDialog.display(jFrame);
        if (loadModelDialog.getModel() != null) {
            this.stopSimulation();
            if (this.model != null) {
                this.model.setup();
                this.model = null;
            }
            DisplayConstants.CELL_WIDTH = 5;
            DisplayConstants.CELL_HEIGHT = 5;
            SHOW_CHARTS = true;
            ALPHA_ORDER = true;
            DEFAULTS_INCLUDE_RNGSEED = false;
            UPDATE_PROBES = false;
            this.model = loadModelDialog.getModel();
            this.params = null;
            try {
                String string = loadModelDialog.getParameterFile();
                if (string.trim().length() > 0) {
                    this.params = ParameterSetterFactory.createParameterSetter(loadModelDialog.getParameterFile());
                    ParameterUtility.createInstance(this.params);
                }
            }
            catch (Exception exception) {
                SimUtilities.showError("Error reading parameter file", exception);
                System.exit(0);
            }
            FrameFactory.load(this.model.getClass().getName());
            this.model.setController(this);
            this.model.addSimEventListener(this);
            jFrame.setTitle(this.model.getName());
            this.chartModels = ChartArchiver.loadCharts(this.model);
            this.model.setup();
            this.setup();
        }
    }

    public void beginModel() {
        super.beginModel();
        if (SHOW_CHARTS) {
            int n = this.chartModels.size();
            for (int i = 0; i < n; ++i) {
                AbstractChartModel abstractChartModel = (AbstractChartModel)this.chartModels.get(i);
                OpenGraph openGraph = abstractChartModel.createChart();
                Schedule schedule = this.model.getSchedule();
                schedule.scheduleActionAtInterval(schedule.repeatInterval, (Object)openGraph, "step", Schedule.LAST);
                this.customCharts.add(openGraph);
                openGraph.display();
            }
            if (CONSOLE_ERR | CONSOLE_OUT) {
                this.console = null;
                this.console = new RepastConsole(CONSOLE_OUT, CONSOLE_ERR);
                this.console.display();
            }
        }
        this.executeBegin = false;
    }

    public void stepSim() {
        this.doStep = true;
        this.pauseSim = false;
        this.go = true;
        this.enableManipulation(true);
        if (this.runThread == null) {
            if (this.executeBegin) {
                this.beginModel();
            }
            this.schedule = this.model.getSchedule();
            this.setupSchedule();
            this.runThread = new Thread(this.simRun);
            this.runThread.start();
        }
        this.notifyMonitor();
    }

    public void loadAndStart() {
        if (this.params != null) {
            this.setParameters();
        }
        this.startSim();
    }

    public void setup() {
        if (this.runThread != null) {
            this.runThread.interrupt();
            try {
                this.runThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interrupted");
            }
        }
        this.model.clearMediaProducers();
        this.model.generateNewSeed();
        this.model.setup();
        int n = this.customCharts.size();
        for (int i = 0; i < n; ++i) {
            ((OpenGraph)this.customCharts.get(i)).dispose();
        }
        if (this.params != null) {
            this.setParameters();
        }
        this.runThread = null;
        this.executeBegin = true;
        this.setMediaSchedulers();
        if (this.console != null) {
            this.console.dispose();
            this.console = null;
        }
    }

    private void setMediaSchedulers() {
        if (this.mediaSchedulers.size() > 0) {
            Vector vector = this.model.getMediaProducers();
            block0: for (int i = 0; i < this.mediaSchedulers.size(); ++i) {
                MediaScheduler mediaScheduler = (MediaScheduler)this.mediaSchedulers.get(i);
                for (int j = 0; j < vector.size(); ++j) {
                    ProducerNamePair producerNamePair = (ProducerNamePair)vector.get(j);
                    if (producerNamePair.getName() != mediaScheduler.getName()) continue;
                    mediaScheduler.setProducer(producerNamePair.getProducer());
                    continue block0;
                }
            }
        }
    }

    public void exitSim() {
        if (this.exitOnExit) {
            this.stopSim();
            if (this.runThread != null) {
                this.runThread.interrupt();
                try {
                    this.runThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.model != null) {
                String string = this.model.getClass().getName();
                FrameFactory.saveFrameData(string);
                ChartArchiver.saveCharts(string, this.chartModels);
            }
            if (this.console != null) {
                this.console.dispose();
                this.console = null;
            }
            System.exit(0);
        } else {
            this.shutdown();
        }
    }

    public void shutdown() {
        this.stopSim();
        this.model.setup();
        if (this.model != null) {
            String string = this.model.getClass().getName();
            FrameFactory.saveFrameData(string);
            ChartArchiver.saveCharts(string, this.chartModels);
        }
        this.model = null;
        System.gc();
        if (this.console != null) {
            this.console.dispose();
            this.console = null;
        }
    }

    protected void onTickCountUpdate() {
        if (UPDATE_PROBES) {
            ProbeUtilities.updateProbePanels();
        }
    }

    public void enableManipulation(boolean bl) {
        ModelManipulator modelManipulator = this.model.getModelManipulator();
        modelManipulator.setEnabled(bl);
    }

    public void stopSimulation() {
        this.stopSim();
    }

    public void pauseSimulation() {
        this.pauseSim();
    }

    public void exitSimulation() {
        this.exitSim();
    }

    private String[] makeModelParams(boolean bl) {
        String[] stringArray = this.model.getInitParam();
        if (bl) {
            String[] stringArray2 = new String[stringArray.length + this.myParams.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            System.arraycopy(this.myParams, 0, stringArray2, stringArray.length, this.myParams.length);
            stringArray2[stringArray2.length - 1] = "RngSeed";
            return stringArray2;
        }
        return stringArray;
    }

    protected void setParameters() {
        this.params.setModelParameters(this.model);
    }

    public IntrospectPanel getModelParameterPanel() {
        IntrospectPanel introspectPanel = null;
        try {
            introspectPanel = new IntrospectPanel(this.model, this.model.getInitParam(), ALPHA_ORDER);
            ProbeUtilities.addModelProbePanel(introspectPanel);
        }
        catch (Exception exception) {
            SimUtilities.showError("Unable to create model parameter panel", exception);
            exception.printStackTrace();
            System.exit(0);
        }
        return introspectPanel;
    }

    public IntrospectPanel getRepastParameterPanel() {
        IntrospectPanel introspectPanel = null;
        try {
            introspectPanel = new IntrospectPanel(this, this.myParams, true);
        }
        catch (Exception exception) {
            SimUtilities.showError("Unable to display repast parameters", exception);
            exception.printStackTrace();
            System.exit(0);
        }
        return introspectPanel;
    }

    public Action showSnapshotDialog(JFrame jFrame) {
        Vector vector = this.model.getMediaProducers();
        if (vector.size() == 0) {
            SimUtilities.showMessage("<html><b><font color=black size=-1>No DisplaySurface or MediaProducers registered.<p>Use registerDisplaySurface(...)  or registerMediaProducer(...) in model's setup method</font></b></html>");
            return null;
        }
        SnapshotDialog snapshotDialog = new SnapshotDialog(vector);
        snapshotDialog.display(jFrame, "Snapshot Setup");
        SnapshotScheduler snapshotScheduler = snapshotDialog.scheduleSnapshot(this.model.getSchedule());
        if (snapshotScheduler != null) {
            this.mediaSchedulers.add(snapshotScheduler);
            return snapshotScheduler.getButtonAction();
        }
        return null;
    }

    public void showMakeMovieDialog(JFrame jFrame) {
        Vector vector = this.model.getMediaProducers();
        if (vector.size() == 0) {
            SimUtilities.showMessage("<html><b><font color=black size=-1>No DisplaySurface registered.<p>Use registerDisplaySurface(...) in model's setup method</font></b></html>");
            return;
        }
        MakeMovieDialog makeMovieDialog = new MakeMovieDialog(vector);
        makeMovieDialog.display(jFrame, "Make Movie");
        makeMovieDialog.scheduleMovie(this.model.getSchedule());
    }

    public void showVersion() {
        String string = "RePast Version: 2.2";
        JFrame jFrame = new JFrame();
        JOptionPane.showMessageDialog(jFrame, string);
        jFrame.dispose();
    }

    public void makeCurrentParamsDefault() {
        try {
            ParameterUtility parameterUtility = ParameterUtility.getInstance();
            String[] stringArray = this.makeModelParams(DEFAULTS_INCLUDE_RNGSEED);
            this.params = parameterUtility.createParameters(this.model, stringArray);
        }
        catch (Exception exception) {
            SimUtilities.showError("Error setting default parameters", exception);
            System.exit(0);
        }
    }

    public void showWriteParamsDialog(JFrame jFrame) {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Save Parameters");
            int n = jFileChooser.showSaveDialog(jFrame);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                ParameterUtility.getInstance().makeParameterFileFromCurVals(this.model, this.makeModelParams(DEFAULTS_INCLUDE_RNGSEED), string);
            }
        }
        catch (Exception exception) {
            SimUtilities.showError("Error writing parameters to file", exception);
            System.exit(0);
        }
    }

    public void showChartDialog(JFrame jFrame) {
        if (this.model != null) {
            CustomChartGui customChartGui = new CustomChartGui(this.model, this.chartModels);
            customChartGui.display(jFrame);
            if (customChartGui.getModels() != null) {
                this.chartModels = customChartGui.getModels();
            }
        } else {
            SimUtilities.showMessage("Cannot create a custom chart without a model");
        }
    }

    public void simEventPerformed(SimEvent simEvent) {
        if (simEvent.getId() == 0) {
            this.stopSimulation();
        } else if (simEvent.getId() == 2) {
            this.exitSimulation();
        } else if (simEvent.getId() == 1) {
            this.pauseSimulation();
        }
    }

    public long getRunCount() {
        return 1L;
    }

    public boolean isGUI() {
        return true;
    }

    public boolean isBatch() {
        return false;
    }
}

