/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import cern.jet.random.Uniform;
import java.util.ArrayList;
import java.util.Vector;
import uchicago.src.sim.engine.ActionUtilities;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.util.SimUtilities;

public class ActionGroup
extends BasicAction {
    public static final int SEQUENTIAL = 0;
    public static final int RANDOM = 1;
    private static Class[] paramTypes = new Class[0];
    private int actionType;
    private Uniform rng = null;
    Vector actions = new Vector(7);

    public ActionGroup() {
        this(0);
    }

    public ActionGroup(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Action type value");
        }
        if (n > 1) {
            throw new IllegalArgumentException("Illegal Action type value");
        }
        this.actionType = n;
    }

    public int getType() {
        return this.actionType;
    }

    public void setRng(Uniform uniform) {
        this.rng = uniform;
    }

    public void execute() {
        int n = this.actions.size();
        if (this.actionType == 1 && n > 1) {
            if (this.rng == null) {
                SimUtilities.shuffle(this.actions);
            } else {
                SimUtilities.shuffle(this.actions, this.rng);
            }
        }
        for (int i = 0; i < n; ++i) {
            BasicAction basicAction = (BasicAction)this.actions.elementAt(i);
            basicAction.execute();
        }
    }

    public void createActionFor(Object object, String string) {
        BasicAction basicAction = ActionUtilities.createActionFor(object, string);
        this.actions.add(basicAction);
    }

    public void createActionForEach(ArrayList arrayList, String string) throws NoSuchMethodException {
        BasicAction basicAction = ActionUtilities.createActionForEach(arrayList, string);
        this.actions.add(basicAction);
    }

    public void createActionForEach(ArrayList arrayList, Class clazz, String string) throws NoSuchMethodException {
        BasicAction basicAction = ActionUtilities.createActionForEach(arrayList, clazz, string);
        this.actions.add(basicAction);
    }

    public void addAction(BasicAction basicAction) {
        this.actions.add(basicAction);
    }

    public void removeAction(BasicAction basicAction) {
        this.actions.remove(basicAction);
    }
}

