/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import uchicago.src.sim.engine.ActionQueue;
import uchicago.src.sim.engine.ScheduleGroup;

public abstract class BasicAction {
    public static final int INTERVAL_UPDATER = 1;
    public static final int ONE_TIME_UPDATER = 2;
    private String name = "";
    double nextTime = Double.NaN;
    long index = 0L;
    double intervalTime = 0.0;
    protected Updater updater = new IntervalUpdater();

    public void setNextTime(double d) {
        this.nextTime = d;
    }

    public double getNextTime() {
        return this.nextTime;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    void setUpdater(int n) {
        if (n == 1) {
            this.updater = new IntervalUpdater();
        } else if (n == 2) {
            this.updater = new OneTimeUpdater();
        } else {
            throw new IllegalArgumentException("Illegal Updater type");
        }
    }

    public abstract void execute();

    public void reSchedule(ActionQueue actionQueue) {
        this.updater.update(actionQueue);
    }

    public void addToGroup(ScheduleGroup scheduleGroup) {
        scheduleGroup.addBasicAction(this);
    }

    class OneTimeUpdater
    implements Updater {
        OneTimeUpdater() {
        }

        public void update(ActionQueue actionQueue) {
        }
    }

    class IntervalUpdater
    implements Updater {
        IntervalUpdater() {
        }

        public void update(ActionQueue actionQueue) {
            BasicAction.this.nextTime += BasicAction.this.intervalTime;
            actionQueue.toss(BasicAction.this);
        }
    }

    static interface Updater {
        public void update(ActionQueue var1);
    }
}

