/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.util.ArrayList;
import java.util.Hashtable;
import uchicago.src.sim.engine.BaseController;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.DefaultParameterSetter;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.ParameterUtility;

public class BatchController
extends BaseController {
    protected String[] pArray;
    protected long batchCount = 0L;
    protected ArrayList nameList;
    protected ArrayList dynNameList;
    protected Hashtable nameParam = new Hashtable(5);
    protected volatile boolean finished = false;
    private Object appMonitor = new Object();

    BatchController() {
        this.params = new DefaultParameterSetter();
    }

    public BatchController(ParameterSetter parameterSetter) {
        this.params = parameterSetter;
        ParameterUtility.createInstance(this.params);
    }

    public void setModel(SimModel simModel) {
        super.setModel(simModel);
        this.params.setModelParameters(simModel);
        simModel.addSimEventListener(this);
    }

    public long getRunCount() {
        return this.batchCount;
    }

    public boolean doWriteHeader(String string) {
        Boolean bl = (Boolean)this.persistentObj.get(string = string + "_WRITE_HEADER");
        if (bl == null) {
            bl = Boolean.TRUE;
            this.persistentObj.put(string, bl);
        }
        return bl;
    }

    public void setWriteHeader(String string, boolean bl) {
        this.persistentObj.put(string + "_WRITE_HEADER", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void onTickCountUpdate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                while (!BatchController.this.finished) {
                    BatchController.this.start();
                    object = BatchController.this.monitor;
                    synchronized (object) {
                        while (!BatchController.this.runFinished) {
                            try {
                                BatchController.this.monitor.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    BatchController.this.stopRun();
                }
                object = BatchController.this.appMonitor;
                synchronized (object) {
                    BatchController.this.appMonitor.notify();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        Object object = this.appMonitor;
        synchronized (object) {
            while (!this.finished) {
                try {
                    this.appMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.exitSim();
    }

    public void start() {
        this.incrementBatchCount();
        System.out.println("Run: " + this.getRunCount());
        this.listenerList.clear();
        this.startSim();
    }

    public void stopRun() {
        this.model.generateNewSeed();
        this.model.setup();
        this.runThread = null;
        this.params.setNextModelParameters(this.model);
        this.finished = !this.params.hasNext();
        this.runFinished = false;
    }

    public void simEventPerformed(SimEvent simEvent) {
        if (simEvent.getId() == 0) {
            this.stopSim();
        }
    }

    public void exitSim() {
        System.out.println("Batch Done");
        this.fireSimEvent(new SimEvent(this, 2));
        if (this.exitOnExit) {
            System.exit(0);
        }
    }

    public void incrementBatchCount() {
        ++this.batchCount;
    }

    public boolean isBatch() {
        return true;
    }

    public boolean isGUI() {
        return false;
    }
}

