/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uchicago.src.codegen.GeneratorException;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.Group;
import uchicago.src.sim.engine.ObjectPicker;
import uchicago.src.sim.engine.StatCalculator;
import uchicago.src.sim.util.ByteCodeBuilder;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.SimUtilities;

public class DefaultGroup
implements Group {
    private List items = new ArrayList();
    private BasicAction stepMethod;
    private String stepMethodName;
    private Map minCalculators = new HashMap();
    private Map maxCalculators = new HashMap();
    private Map avgCalculators = new HashMap();
    private Map minPickers = new HashMap();
    private Map maxPickers = new HashMap();
    private Map methods = new HashMap();
    private Class objClass;

    public DefaultGroup(Class clazz, String string) {
        this.stepMethodName = string;
        this.objClass = clazz;
    }

    public DefaultGroup(Collection collection, String string) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("DefaultGroup cannot be created with an empty collection");
        }
        this.items.addAll(collection);
        this.objClass = this.items.get(0).getClass();
        this.stepMethodName = string;
    }

    public DefaultGroup(Class clazz, Collection collection, String string) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("DefaultGroup cannot be created with an empty collection");
        }
        this.items.addAll(collection);
        this.stepMethodName = string;
        this.objClass = clazz;
    }

    public boolean add(Object object) {
        return this.items.add(object);
    }

    public boolean remove(Object object) {
        return this.items.remove(object);
    }

    public int size() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    public Iterator iterator() {
        return this.items.iterator();
    }

    public Object getRandomItem() {
        if (this.items.size() == 0) {
            return null;
        }
        int n = Random.uniform.nextIntFromTo(0, this.items.size() - 1);
        return this.items.get(n);
    }

    public void step() {
        if (this.stepMethod == null) {
            try {
                this.stepMethod = ByteCodeBuilder.generateBasicActionForList(this.items, this.stepMethodName, this.objClass, false);
            }
            catch (GeneratorException generatorException) {
                SimUtilities.showError("Error executing step method '" + this.stepMethodName + "'", generatorException);
                System.exit(0);
            }
        }
        this.stepMethod.execute();
    }

    public void call(String string) {
        BasicAction basicAction = (BasicAction)this.methods.get(string);
        if (basicAction == null) {
            try {
                basicAction = ByteCodeBuilder.generateBasicActionForList(this.items, string, this.objClass, false);
                this.methods.put(string, basicAction);
            }
            catch (GeneratorException generatorException) {
                SimUtilities.showError("Error calling '" + string + "' method", generatorException);
                System.exit(0);
            }
        }
        basicAction.execute();
    }

    public double min(String string) {
        StatCalculator statCalculator = (StatCalculator)this.minCalculators.get(string);
        if (statCalculator == null) {
            try {
                statCalculator = ByteCodeBuilder.generateMinCalculator(this.objClass, this.items, string);
                this.minCalculators.put(string, statCalculator);
            }
            catch (GeneratorException generatorException) {
                SimUtilities.showError("Error executing min('" + string + "') method", generatorException);
                System.exit(0);
            }
        }
        return statCalculator.calc();
    }

    public double max(String string) {
        StatCalculator statCalculator = (StatCalculator)this.maxCalculators.get(string);
        if (statCalculator == null) {
            try {
                statCalculator = ByteCodeBuilder.generateMaxCalculator(this.objClass, this.items, string);
                this.maxCalculators.put(string, statCalculator);
            }
            catch (GeneratorException generatorException) {
                SimUtilities.showError("Error executing max('" + string + "') method", generatorException);
                System.exit(0);
            }
        }
        return statCalculator.calc();
    }

    public double avg(String string) {
        StatCalculator statCalculator = (StatCalculator)this.avgCalculators.get(string);
        if (statCalculator == null) {
            try {
                statCalculator = ByteCodeBuilder.generateAvgCalculator(this.objClass, this.items, string);
                this.avgCalculators.put(string, statCalculator);
            }
            catch (GeneratorException generatorException) {
                SimUtilities.showError("Error executing avg('" + string + "') method", generatorException);
                System.exit(0);
            }
        }
        return statCalculator.calc();
    }

    public List getItemWithMinValue(String string) {
        ObjectPicker objectPicker = (ObjectPicker)this.minPickers.get(string);
        if (objectPicker == null) {
            try {
                objectPicker = ByteCodeBuilder.generateMinObjectPicker(this.objClass, this.items, string);
                this.minPickers.put(string, objectPicker);
            }
            catch (GeneratorException generatorException) {
                SimUtilities.showError("Error executing getItemWithMinValue('" + string + "') method", generatorException);
                System.exit(0);
            }
        }
        return objectPicker.pickObjects();
    }

    public List getItemWithMaxValue(String string) {
        ObjectPicker objectPicker = (ObjectPicker)this.maxPickers.get(string);
        if (objectPicker == null) {
            try {
                objectPicker = ByteCodeBuilder.generateMaxObjectPicker(this.objClass, this.items, string);
                this.maxPickers.put(string, objectPicker);
            }
            catch (GeneratorException generatorException) {
                SimUtilities.showError("Error executing getItemWithMaxValue('" + string + "') method", generatorException);
                System.exit(0);
            }
        }
        return objectPicker.pickObjects();
    }

    public boolean contains(Object object) {
        return this.items.contains(object);
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.items.toArray(objectArray);
    }

    public boolean containsAll(Collection collection) {
        return this.items.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.items.addAll(collection);
    }

    public boolean removeAll(Collection collection) {
        return this.items.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.items.retainAll(collection);
    }
}

