/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.proactive.ProActive;
import uchicago.src.reflector.Introspector;
import uchicago.src.sim.analysis.DataWriter;
import uchicago.src.sim.engine.RemoteBatchController;
import uchicago.src.sim.parameter.Parameter;
import uchicago.src.sim.parameter.ParameterReader;
import uchicago.src.sim.util.SimUtilities;

public class HomeController {
    protected ArrayList dynNameList;
    protected Hashtable nameParam = new Hashtable(5);
    protected Vector params;
    protected boolean finished = false;
    protected ArrayList nameList = new ArrayList();
    private long batchCount = 0L;
    private Hashtable persistent;
    private RemoteBatchController controllers;
    protected String modelClass;
    Object persKey = new Object();

    public HomeController() {
        this.persistent = new Hashtable();
        this.params = new Vector();
        this.modelClass = "";
    }

    public HomeController(String string, String string2) {
        this.persistent = new Hashtable();
        ParameterReader parameterReader = null;
        try {
            parameterReader = new ParameterReader(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.params = parameterReader.getParameters();
        this.getParameterNames();
        this.modelClass = string2;
    }

    public void setControllers(RemoteBatchController remoteBatchController) {
        this.controllers = remoteBatchController;
    }

    public long getRunCount() {
        return this.batchCount;
    }

    private void incrementBatchCount() {
        ++this.batchCount;
    }

    protected void setModelParameters(Introspector introspector) {
        for (int i = 0; i < this.params.size(); ++i) {
            Parameter parameter = (Parameter)this.params.elementAt(i);
            this.setParameters(introspector, parameter);
        }
    }

    private void setParameters(Introspector introspector, Parameter parameter) {
        if (parameter.hasChildren()) {
            Vector vector = parameter.getChildren();
            for (int i = 0; i < vector.size(); ++i) {
                this.setParameters(introspector, (Parameter)vector.elementAt(i));
            }
        }
        try {
            introspector.invokeSetMethod(parameter.getName(), parameter.getValue());
        }
        catch (InvocationTargetException invocationTargetException) {
            SimUtilities.showError("Unable to set model parameter " + parameter.getName(), invocationTargetException);
            invocationTargetException.printStackTrace();
            System.exit(0);
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Unable to set model parameter " + parameter.getName(), illegalAccessException);
            illegalAccessException.printStackTrace();
            System.exit(0);
        }
        catch (NullPointerException nullPointerException) {
            SimUtilities.showError("Unable to set model parameter " + parameter.getName(), nullPointerException);
            nullPointerException.printStackTrace();
            System.exit(0);
        }
    }

    protected void incrementParameters(Introspector introspector) {
        for (int i = 0; i < this.params.size(); ++i) {
            Parameter parameter = (Parameter)this.params.elementAt(i);
            if (parameter.increment()) continue;
            if (parameter.isConstant()) {
                if (this.getDynamicParameterNames().size() != 0) continue;
                this.finished = true;
                return;
            }
            this.finished = true;
            return;
        }
        this.setModelParameters(introspector);
    }

    public ArrayList getParameterNames() {
        this.nameList = new ArrayList(11);
        this.getParamNames(this.params);
        return this.nameList;
    }

    public ArrayList getDynamicParameterNames() {
        this.dynNameList = new ArrayList(11);
        this.getDynParamNames(this.params);
        return this.dynNameList;
    }

    private void getParamNames(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Parameter parameter = (Parameter)vector.get(i);
            StringBuffer stringBuffer = new StringBuffer(parameter.getName());
            char c = Character.toUpperCase(stringBuffer.charAt(0));
            stringBuffer.setCharAt(0, c);
            this.nameParam.put(stringBuffer.toString(), parameter);
            String string = parameter.getName().toLowerCase();
            this.nameList.add(string);
            if (!parameter.hasChildren()) continue;
            this.getParamNames(parameter.getChildren());
        }
    }

    private void getDynParamNames(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Parameter parameter = (Parameter)vector.get(i);
            if (!parameter.isConstant()) {
                String string = parameter.getName().toLowerCase();
                this.dynNameList.add(string);
            }
            if (!parameter.hasChildren()) continue;
            this.getDynParamNames(parameter.getChildren());
        }
    }

    public synchronized long nextModel(Introspector introspector) {
        this.incrementBatchCount();
        if (this.batchCount == 1L) {
            this.setModelParameters(introspector);
        } else {
            this.incrementParameters(introspector);
        }
        if (this.finished) {
            return -1L;
        }
        System.out.println("Run: " + this.getRunCount());
        return this.getRunCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPutPersistenceObject(Object object, Object object2) {
        Object object3 = this.persKey;
        synchronized (object3) {
            if (this.persistent.get(object) == null) {
                this.persistent.put(object, object2);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPersistentObj(Object object, Object object2) {
        Object object3 = this.persKey;
        synchronized (object3) {
            this.persistent.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPersistentObj(Object object) {
        Object object2 = this.persKey;
        synchronized (object2) {
            return this.persistent.get(object);
        }
    }

    public void begin() {
        DataWriter dataWriter = new DataWriter();
        try {
            this.putPersistentObj("WRITER", ProActive.turnActive((Object)dataWriter));
            this.controllers.setModelClass(this.modelClass);
            System.out.println("about to start controllers");
            ProActive.waitFor((Object)this.controllers.beginRemoteRun());
            this.controllers.quit();
            dataWriter.writeEnd();
            System.out.println("Batch Done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }
}

